/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.utilint;

import com.tangosol.internal.sleepycat.je.utilint.FileStoreInfo;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;

class Java7FileStoreInfo
extends FileStoreInfo {
    private final FileStore fileStore;

    Java7FileStoreInfo(String file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The file must not be null");
        }
        this.fileStore = Files.getFileStore(FileSystems.getDefault().getPath(file, new String[0]));
    }

    @Override
    public long getTotalSpace() throws IOException {
        return this.fileStore.getTotalSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        return this.fileStore.getUsableSpace();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Java7FileStoreInfo)) {
            return false;
        }
        return this.fileStore.equals(((Java7FileStoreInfo)obj).fileStore);
    }

    public int hashCode() {
        return 197 + (this.fileStore.hashCode() ^ 0xC7);
    }

    public String toString() {
        return this.fileStore.toString();
    }

    static class Java7Factory
    implements FileStoreInfo.Factory {
        Java7Factory() {
        }

        @Override
        public void factoryCheckSupported() {
        }

        @Override
        public FileStoreInfo factoryGetInfo(String file) throws IOException {
            return new Java7FileStoreInfo(file);
        }
    }
}

