/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.persist;

import com.tangosol.internal.sleepycat.bind.EntityBinding;
import com.tangosol.internal.sleepycat.bind.EntryBinding;
import com.tangosol.internal.sleepycat.collections.StoredSortedMap;
import com.tangosol.internal.sleepycat.compat.DbCompat;
import com.tangosol.internal.sleepycat.je.Database;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.LockMode;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import com.tangosol.internal.sleepycat.je.SecondaryConfig;
import com.tangosol.internal.sleepycat.je.SecondaryDatabase;
import com.tangosol.internal.sleepycat.je.Transaction;
import com.tangosol.internal.sleepycat.je.TransactionConfig;
import com.tangosol.internal.sleepycat.persist.BasicIndex;
import com.tangosol.internal.sleepycat.persist.EntityIndex;
import com.tangosol.internal.sleepycat.persist.EntityValueAdapter;
import com.tangosol.internal.sleepycat.persist.KeysIndex;
import com.tangosol.internal.sleepycat.persist.PrimaryIndex;
import com.tangosol.internal.sleepycat.persist.SubIndex;
import java.util.Map;
import java.util.SortedMap;

public class SecondaryIndex<SK, PK, E>
extends BasicIndex<SK, E> {
    private SecondaryDatabase secDb;
    private Database keysDb;
    private PrimaryIndex<PK, E> priIndex;
    private EntityBinding<E> entityBinding;
    private EntityIndex<SK, PK> keysIndex;
    private SortedMap<SK, E> map;

    public SecondaryIndex(SecondaryDatabase database, Database keysDatabase, PrimaryIndex<PK, E> primaryIndex, Class<SK> secondaryKeyClass, EntryBinding<SK> secondaryKeyBinding) throws DatabaseException {
        super(database, secondaryKeyClass, secondaryKeyBinding, new EntityValueAdapter<E>(primaryIndex.getEntityClass(), primaryIndex.getEntityBinding(), true));
        this.secDb = database;
        this.keysDb = keysDatabase;
        this.priIndex = primaryIndex;
        this.entityBinding = primaryIndex.getEntityBinding();
    }

    @Override
    public SecondaryDatabase getDatabase() {
        return this.secDb;
    }

    public Database getKeysDatabase() {
        return this.keysDb;
    }

    public PrimaryIndex<PK, E> getPrimaryIndex() {
        return this.priIndex;
    }

    public Class<SK> getKeyClass() {
        return this.keyClass;
    }

    public EntryBinding<SK> getKeyBinding() {
        return this.keyBinding;
    }

    public synchronized EntityIndex<SK, PK> keysIndex() throws DatabaseException {
        if (this.keysIndex == null) {
            if (this.keysDb == null) {
                SecondaryConfig config = this.secDb.getConfig();
                config.setReadOnly(true);
                config.setAllowCreate(false);
                config.setExclusiveCreate(false);
                this.keysDb = DbCompat.openDatabase(this.db.getEnvironment(), null, DbCompat.getDatabaseFile(this.secDb), this.secDb.getDatabaseName(), config);
                if (this.keysDb == null) {
                    throw new IllegalStateException("Could not open existing DB, file: " + DbCompat.getDatabaseFile(this.secDb) + " name: " + this.secDb.getDatabaseName());
                }
            }
            this.keysIndex = new KeysIndex(this.keysDb, this.keyClass, this.keyBinding, this.priIndex.getKeyClass(), this.priIndex.getKeyBinding());
        }
        return this.keysIndex;
    }

    public EntityIndex<PK, E> subIndex(SK key) throws DatabaseException {
        return new SubIndex(this, this.entityBinding, key);
    }

    @Override
    public E get(SK key) throws DatabaseException {
        return this.get((Transaction)null, key, (LockMode)null);
    }

    @Override
    public E get(Transaction txn, SK key, LockMode lockMode) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry pkeyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationStatus status = this.secDb.get(txn, keyEntry, pkeyEntry, dataEntry, lockMode);
        if (status == OperationStatus.SUCCESS) {
            return this.entityBinding.entryToObject(pkeyEntry, dataEntry);
        }
        return null;
    }

    @Override
    public Map<SK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<SK, E> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap<SK, E>(this.db, this.keyBinding, this.entityBinding, true);
        }
        return this.map;
    }

    protected TransactionConfig getAutoCommitTransactionConfig() {
        return null;
    }

    @Override
    boolean isUpdateAllowed() {
        return false;
    }
}

