/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.persist.impl;

import com.tangosol.internal.sleepycat.compat.DbCompat;
import com.tangosol.internal.sleepycat.persist.evolve.Converter;
import com.tangosol.internal.sleepycat.persist.evolve.Deleter;
import com.tangosol.internal.sleepycat.persist.evolve.EntityConverter;
import com.tangosol.internal.sleepycat.persist.evolve.Mutations;
import com.tangosol.internal.sleepycat.persist.evolve.Renamer;
import com.tangosol.internal.sleepycat.persist.impl.Accessor;
import com.tangosol.internal.sleepycat.persist.impl.Catalog;
import com.tangosol.internal.sleepycat.persist.impl.CollectionProxy;
import com.tangosol.internal.sleepycat.persist.impl.EnhancedAccessor;
import com.tangosol.internal.sleepycat.persist.impl.EntityInput;
import com.tangosol.internal.sleepycat.persist.impl.EntityOutput;
import com.tangosol.internal.sleepycat.persist.impl.Evolver;
import com.tangosol.internal.sleepycat.persist.impl.FieldInfo;
import com.tangosol.internal.sleepycat.persist.impl.Format;
import com.tangosol.internal.sleepycat.persist.impl.PersistKeyCreator;
import com.tangosol.internal.sleepycat.persist.impl.RawAccessor;
import com.tangosol.internal.sleepycat.persist.impl.RawComplexInput;
import com.tangosol.internal.sleepycat.persist.impl.RawSingleInput;
import com.tangosol.internal.sleepycat.persist.impl.Reader;
import com.tangosol.internal.sleepycat.persist.impl.RecordInput;
import com.tangosol.internal.sleepycat.persist.impl.ReflectionAccessor;
import com.tangosol.internal.sleepycat.persist.impl.RefreshException;
import com.tangosol.internal.sleepycat.persist.impl.WidenerInput;
import com.tangosol.internal.sleepycat.persist.model.ClassMetadata;
import com.tangosol.internal.sleepycat.persist.model.DeleteAction;
import com.tangosol.internal.sleepycat.persist.model.EntityMetadata;
import com.tangosol.internal.sleepycat.persist.model.EntityModel;
import com.tangosol.internal.sleepycat.persist.model.FieldMetadata;
import com.tangosol.internal.sleepycat.persist.model.Relationship;
import com.tangosol.internal.sleepycat.persist.model.SecondaryKeyMetadata;
import com.tangosol.internal.sleepycat.persist.raw.RawField;
import com.tangosol.internal.sleepycat.persist.raw.RawObject;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComplexFormat
extends Format {
    private static final long serialVersionUID = -2847843033590454917L;
    private ClassMetadata clsMeta;
    private EntityMetadata entityMeta;
    private FieldInfo priKeyField;
    private List<FieldInfo> secKeyFields;
    private List<FieldInfo> nonKeyFields;
    private FieldReader secKeyFieldReader;
    private FieldReader nonKeyFieldReader;
    private Map<String, String> oldToNewKeyMap;
    private Map<String, String> newToOldFieldMap;
    private boolean evolveNeeded;
    private transient Accessor objAccessor;
    private transient Accessor rawAccessor;
    private transient ComplexFormat entityFormat;
    private transient Map<String, FieldAddress> secKeyAddresses;
    private volatile transient Map<String, RawField> rawFields;
    private volatile transient FieldInfo[] rawInputFields;
    private volatile transient int[] rawInputLevels;
    private volatile transient int rawInputDepth;
    private Set<String> incorrectlyOrderedSecKeys = new HashSet<String>();
    private boolean newStringFormat = true;

    ComplexFormat(Catalog catalog, Class cls, ClassMetadata clsMeta, EntityMetadata entityMeta) {
        super(catalog, cls);
        this.clsMeta = clsMeta;
        this.entityMeta = entityMeta;
        this.secKeyFields = new ArrayList<FieldInfo>();
        this.nonKeyFields = FieldInfo.getInstanceFields(cls, clsMeta);
        if (clsMeta.getPrimaryKey() != null) {
            String fieldName = clsMeta.getPrimaryKey().getName();
            FieldInfo field = FieldInfo.getField(this.nonKeyFields, fieldName);
            if (field == null) {
                throw new IllegalArgumentException("Primary key field does not exist: " + this.getClassName() + '.' + fieldName);
            }
            this.nonKeyFields.remove(field);
            this.priKeyField = field;
        }
        if (clsMeta.getSecondaryKeys() != null) {
            for (SecondaryKeyMetadata secKeyMeta : clsMeta.getSecondaryKeys().values()) {
                String fieldName = secKeyMeta.getName();
                FieldInfo field = FieldInfo.getField(this.nonKeyFields, fieldName);
                if (field == null) {
                    throw new IllegalArgumentException("Secondary key field does not exist: " + this.getClassName() + '.' + fieldName);
                }
                Class fieldCls = field.getFieldClass(this.getCatalog());
                Relationship rel = secKeyMeta.getRelationship();
                if (rel == Relationship.ONE_TO_MANY || rel == Relationship.MANY_TO_MANY) {
                    if (!PersistKeyCreator.isManyType(fieldCls)) {
                        throw new IllegalArgumentException("ONE_TO_MANY and MANY_TO_MANY keys must have an array or Collection type: " + this.getClassName() + '.' + fieldName);
                    }
                } else if (PersistKeyCreator.isManyType(fieldCls)) {
                    throw new IllegalArgumentException("ONE_TO_ONE and MANY_TO_ONE keys must not have an array or Collection type: " + this.getClassName() + '.' + fieldName);
                }
                if (fieldCls.isPrimitive() && secKeyMeta.getDeleteAction() == DeleteAction.NULLIFY) {
                    throw new IllegalArgumentException("NULLIFY may not be used with primitive fields: " + this.getClassName() + '.' + fieldName);
                }
                this.nonKeyFields.remove(field);
                this.secKeyFields.add(field);
            }
        }
        Collections.sort(this.secKeyFields);
        Collections.sort(this.nonKeyFields);
    }

    @Override
    void migrateFromBeta(Map<String, Format> formatMap) {
        super.migrateFromBeta(formatMap);
        if (this.priKeyField != null) {
            this.priKeyField.migrateFromBeta(formatMap);
        }
        for (FieldInfo field : this.secKeyFields) {
            field.migrateFromBeta(formatMap);
        }
        for (FieldInfo field : this.nonKeyFields) {
            field.migrateFromBeta(formatMap);
        }
    }

    ComplexFormat getComplexSuper() {
        return (ComplexFormat)this.getSuperFormat();
    }

    private ComplexFormat getComplexLatest() {
        return (ComplexFormat)this.getLatestVersion();
    }

    FieldInfo getPriKeyFieldInfo() {
        return this.priKeyField;
    }

    String getPriKeyField() {
        if (this.clsMeta.getPrimaryKey() != null) {
            return this.clsMeta.getPrimaryKey().getName();
        }
        return null;
    }

    @Override
    boolean isEntity() {
        return this.clsMeta.isEntityClass();
    }

    @Override
    boolean isModelClass() {
        return true;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        return this.clsMeta;
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        return this.entityMeta;
    }

    @Override
    ComplexFormat getEntityFormat() {
        if (this.isInitialized()) {
            return this.entityFormat;
        }
        if (this.isNew()) {
            throw DbCompat.unexpectedState(this.toString());
        }
        for (ComplexFormat format = this; format != null; format = format.getComplexSuper()) {
            if (!format.isEntity()) continue;
            return format;
        }
        return null;
    }

    @Override
    void setEvolveNeeded(boolean needed) {
        this.evolveNeeded = needed;
    }

    @Override
    boolean getEvolveNeeded() {
        return this.evolveNeeded;
    }

    @Override
    boolean getNewStringFormat() {
        if (this.getEntityFormat() == null) {
            throw DbCompat.unexpectedState();
        }
        return this.newStringFormat;
    }

    @Override
    public Map<String, RawField> getFields() {
        if (this.rawFields == null) {
            HashMap<String, RawField> map = new HashMap<String, RawField>();
            if (this.priKeyField != null) {
                map.put(this.priKeyField.getName(), this.priKeyField);
            }
            for (RawField rawField : this.secKeyFields) {
                map.put(rawField.getName(), rawField);
            }
            for (RawField rawField : this.nonKeyFields) {
                map.put(rawField.getName(), rawField);
            }
            this.rawFields = map;
        }
        return this.rawFields;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
        Format superFormat;
        Class superCls;
        Class cls = this.getType();
        if (this.priKeyField != null) {
            this.priKeyField.collectRelatedFormats(catalog, newFormats);
        }
        for (FieldInfo field : this.secKeyFields) {
            field.collectRelatedFormats(catalog, newFormats);
        }
        for (FieldInfo field : this.nonKeyFields) {
            field.collectRelatedFormats(catalog, newFormats);
        }
        if (this.entityMeta != null) {
            for (SecondaryKeyMetadata secKeyMeta : this.entityMeta.getSecondaryKeys().values()) {
                String elemClsName = secKeyMeta.getElementClassName();
                if (elemClsName == null) continue;
                Class elemCls = catalog.resolveKeyClass(elemClsName);
                catalog.createFormat(elemCls, newFormats);
            }
        }
        if ((superCls = cls.getSuperclass()) != Object.class && !((superFormat = catalog.createFormat(superCls, newFormats)) instanceof ComplexFormat)) {
            throw new IllegalArgumentException("The superclass of a complex type must not be a composite key class or a simple type class: " + superCls.getName());
        }
        String proxiedClsName = this.clsMeta.getProxiedClassName();
        if (proxiedClsName != null) {
            catalog.createFormat(proxiedClsName, newFormats);
        }
    }

    @Override
    void initialize(Catalog catalog, EntityModel model, int initVersion) {
        Class superCls;
        Class type = this.getType();
        boolean useEnhanced = false;
        if (type != null) {
            useEnhanced = EnhancedAccessor.isEnhanced(type);
        }
        if (this.priKeyField != null) {
            this.priKeyField.initialize(catalog, model, initVersion);
        }
        for (FieldInfo field : this.secKeyFields) {
            field.initialize(catalog, model, initVersion);
        }
        for (FieldInfo field : this.nonKeyFields) {
            field.initialize(catalog, model, initVersion);
        }
        ComplexFormat superFormat = this.getComplexSuper();
        if (type != null && superFormat == null && (superCls = type.getSuperclass()) != Object.class) {
            superFormat = (ComplexFormat)catalog.getFormat(superCls.getName());
            this.setSuperFormat(superFormat);
        }
        if (superFormat != null) {
            superFormat.initializeIfNeeded(catalog, model);
            Accessor superAccessor = superFormat.objAccessor;
            if (type != null && superAccessor != null) {
                if (useEnhanced) {
                    if (!(superAccessor instanceof EnhancedAccessor)) {
                        throw new IllegalStateException("The superclass of an enhanced class must also be enhanced: " + this.getClassName() + " extends " + superFormat.getClassName());
                    }
                } else if (!(superAccessor instanceof ReflectionAccessor)) {
                    throw new IllegalStateException("The superclass of an unenhanced class must not be enhanced: " + this.getClassName() + " extends " + superFormat.getClassName());
                }
            }
        }
        for (ComplexFormat format = this; format != null; format = format.getComplexSuper()) {
            if (!format.isEntity()) continue;
            this.entityFormat = format;
            break;
        }
        if (this.isEntity() && this.isCurrentVersion()) {
            this.entityMeta = model.getEntityMetadata(this.getClassName());
        }
        if (this.clsMeta.getProxiedClassName() != null && this.entityFormat != null) {
            throw new IllegalArgumentException("A proxy may not be an entity: " + this.getClassName());
        }
        if (this.entityFormat != null && this.entityFormat != this && this.priKeyField != null) {
            throw new IllegalArgumentException("A PrimaryKey may not appear on an Entity subclass: " + this.getClassName() + " field: " + this.priKeyField.getName());
        }
        if (type != null) {
            if (useEnhanced) {
                this.objAccessor = new EnhancedAccessor(catalog, type, this);
            } else {
                Accessor superObjAccessor = superFormat != null ? superFormat.objAccessor : null;
                this.objAccessor = new ReflectionAccessor(catalog, type, superObjAccessor, this.priKeyField, this.secKeyFields, this.nonKeyFields);
            }
        }
        Accessor superRawAccessor = superFormat != null ? superFormat.rawAccessor : null;
        this.rawAccessor = new RawAccessor(this, superRawAccessor, this.priKeyField, this.secKeyFields, this.nonKeyFields);
        EntityMetadata latestEntityMeta = null;
        if (this.entityFormat != null) {
            latestEntityMeta = this.entityFormat.getLatestVersion().getEntityMetadata();
        }
        if (latestEntityMeta != null) {
            this.secKeyAddresses = new HashMap<String, FieldAddress>();
            ComplexFormat thisLatest = this.getComplexLatest();
            if (thisLatest != this) {
                thisLatest.initializeIfNeeded(catalog, model);
            }
            block3: for (SecondaryKeyMetadata secKeyMeta : latestEntityMeta.getSecondaryKeys().values()) {
                String clsName = secKeyMeta.getDeclaringClassName();
                String fieldName = secKeyMeta.getName();
                int superLevel = 0;
                for (ComplexFormat format = this; format != null; format = format.getComplexSuper()) {
                    if (clsName.equals(format.getLatestVersion().getClassName())) {
                        int fieldNum;
                        boolean isSecField;
                        String useFieldName = null;
                        useFieldName = format.newToOldFieldMap != null && format.newToOldFieldMap.containsKey(fieldName) ? format.newToOldFieldMap.get(fieldName) : fieldName;
                        FieldInfo info = FieldInfo.getField(format.secKeyFields, useFieldName);
                        if (info != null) {
                            isSecField = true;
                            fieldNum = format.secKeyFields.indexOf(info);
                        } else {
                            isSecField = false;
                            info = FieldInfo.getField(format.nonKeyFields, useFieldName);
                            if (info == null) {
                                assert (thisLatest != this);
                                thisLatest.checkNewSecKeyInitializer(secKeyMeta);
                                continue block3;
                            }
                            fieldNum = format.nonKeyFields.indexOf(info);
                        }
                        FieldAddress addr = new FieldAddress(isSecField, fieldNum, superLevel, format, info.getType());
                        this.secKeyAddresses.put(secKeyMeta.getKeyName(), addr);
                    }
                    ++superLevel;
                }
            }
        }
    }

    private void checkNewSecKeyInitializer(SecondaryKeyMetadata secKeyMeta) {
        if (this.objAccessor != null) {
            if (Modifier.isAbstract(this.getType().getModifiers())) {
                return;
            }
            FieldAddress addr = this.secKeyAddresses.get(secKeyMeta.getKeyName());
            Object obj = this.objAccessor.newInstance();
            Object val = this.objAccessor.getField(obj, addr.fieldNum, addr.superLevel, addr.isSecField);
            if (val != null) {
                if (addr.keyFormat.isPrimitive()) {
                    throw new IllegalArgumentException("For a new secondary key field the field type must not be a primitive -- class: " + secKeyMeta.getDeclaringClassName() + " field: " + secKeyMeta.getName());
                }
                throw new IllegalArgumentException("For a new secondary key field the default constructor must not initialize the field to a non-null value -- class: " + secKeyMeta.getDeclaringClassName() + " field: " + secKeyMeta.getName());
            }
        }
    }

    private boolean nullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    @Override
    Object newArray(int len) {
        return this.objAccessor.newArray(len);
    }

    @Override
    public Object newInstance(EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        return accessor.newInstance();
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) throws RefreshException {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.readSecKeyFields(o, input, 0, 0x7FFFFFFE, -1);
        accessor.readNonKeyFields(o, input, 0, 0x7FFFFFFE, -1);
        return o;
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) throws RefreshException {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.writeSecKeyFields(o, output);
        accessor.writeNonKeyFields(o, output);
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) throws RefreshException {
        FieldInfo[] fields = this.rawInputFields;
        int[] levels = this.rawInputLevels;
        int depth = this.rawInputDepth;
        if (fields == null || levels == null || depth == 0) {
            ComplexFormat format;
            depth = 0;
            int nFields = 0;
            for (ComplexFormat format2 = this; format2 != null; format2 = format2.getComplexSuper()) {
                nFields += format2.getNFields();
                ++depth;
            }
            ComplexFormat[] hierarchy = new ComplexFormat[depth];
            int level = depth;
            for (ComplexFormat format3 = this; format3 != null; format3 = format3.getComplexSuper()) {
                hierarchy[--level] = format3;
            }
            assert (level == 0);
            levels = new int[nFields];
            fields = new FieldInfo[nFields];
            int index = 0;
            if (this.getEntityFormat() != null) {
                for (level = depth - 1; level >= 0; --level) {
                    format = hierarchy[level];
                    if (format.priKeyField == null) continue;
                    levels[index] = level;
                    fields[index] = format.priKeyField;
                    ++index;
                    break;
                }
                assert (index == 1);
            }
            for (level = 0; level < depth; ++level) {
                format = hierarchy[level];
                for (FieldInfo field : format.secKeyFields) {
                    levels[index] = level;
                    fields[index] = field;
                    ++index;
                }
            }
            for (level = 0; level < depth; ++level) {
                format = hierarchy[level];
                for (FieldInfo field : format.nonKeyFields) {
                    levels[index] = level;
                    fields[index] = field;
                    ++index;
                }
            }
            assert (index == fields.length);
            this.rawInputFields = fields;
            this.rawInputLevels = levels;
            this.rawInputDepth = depth;
        }
        RawObject[] objectsByLevel = new RawObject[depth];
        int level = depth;
        for (RawObject raw = rawObject; raw != null; raw = raw.getSuper()) {
            if (level == 0) {
                throw new IllegalArgumentException("RawObject has too many superclasses: " + rawObject.getType().getClassName());
            }
            objectsByLevel[--level] = raw;
        }
        if (level > 0) {
            throw new IllegalArgumentException("RawObject has too few superclasses: " + rawObject.getType().getClassName());
        }
        assert (level == 0);
        RawObject[] objects = new RawObject[fields.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = objectsByLevel[levels[i]];
        }
        RawComplexInput in = new RawComplexInput(catalog, rawAccess, converted, fields, objects);
        Object o = this.newInstance(in, rawAccess);
        converted.put(rawObject, o);
        if (this.getEntityFormat() != null) {
            this.readPriKey(o, in, rawAccess);
        }
        return this.readObject(o, in, rawAccess);
    }

    @Override
    boolean isPriKeyNullOrZero(Object o, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        return accessor.isPriKeyFieldNullOrZero(o);
    }

    @Override
    void writePriKey(Object o, EntityOutput output, boolean rawAccess) throws RefreshException {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.writePriKeyField(o, output);
    }

    @Override
    public void readPriKey(Object o, EntityInput input, boolean rawAccess) throws RefreshException {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.readPriKeyField(o, input);
    }

    @Override
    public String getOldKeyName(String keyName) {
        if (this.newToOldFieldMap != null && this.newToOldFieldMap.containsKey(keyName)) {
            return this.newToOldFieldMap.get(keyName);
        }
        return keyName;
    }

    @Override
    boolean nullifySecKey(Catalog catalog, Object entity, String keyName, Object keyElement) {
        if (this.secKeyAddresses == null) {
            throw DbCompat.unexpectedState();
        }
        FieldAddress addr = this.secKeyAddresses.get(keyName);
        if (addr != null) {
            Object oldVal = this.rawAccessor.getField(entity, addr.fieldNum, addr.superLevel, addr.isSecField);
            if (oldVal != null) {
                if (keyElement != null) {
                    boolean isArray;
                    RawObject container = (RawObject)oldVal;
                    Object[] a1 = container.getElements();
                    boolean bl = isArray = a1 != null;
                    if (!isArray) {
                        a1 = CollectionProxy.getElements(container);
                    }
                    if (a1 != null) {
                        for (int i = 0; i < a1.length; ++i) {
                            if (!keyElement.equals(a1[i])) continue;
                            int len = a1.length - 1;
                            Object[] a2 = new Object[len];
                            System.arraycopy(a1, 0, a2, 0, i);
                            System.arraycopy(a1, i + 1, a2, i, len - i);
                            if (isArray) {
                                this.rawAccessor.setField(entity, addr.fieldNum, addr.superLevel, addr.isSecField, new RawObject(container.getType(), a2));
                            } else {
                                CollectionProxy.setElements(container, a2);
                            }
                            return true;
                        }
                    }
                    return false;
                }
                this.rawAccessor.setField(entity, addr.fieldNum, addr.superLevel, addr.isSecField, null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    void skipContents(RecordInput input) throws RefreshException {
        this.skipToSecKeyField(input, 0x7FFFFFFE);
        this.skipToNonKeyField(input, 0x7FFFFFFE);
    }

    @Override
    void copySecMultiKey(RecordInput input, Format keyFormat, Set results) throws RefreshException {
        CollectionProxy.copyElements(input, this, keyFormat, results);
    }

    @Override
    Format skipToSecKey(RecordInput input, String keyName) throws RefreshException {
        if (this.secKeyAddresses == null) {
            throw DbCompat.unexpectedState();
        }
        FieldAddress addr = this.secKeyAddresses.get(keyName);
        if (addr != null) {
            if (addr.isSecField) {
                addr.clsFormat.skipToSecKeyField(input, addr.fieldNum);
            } else {
                this.skipToSecKeyField(input, 0x7FFFFFFE);
                addr.clsFormat.skipToNonKeyField(input, addr.fieldNum);
            }
            return addr.keyFormat;
        }
        return null;
    }

    private int getNFields() {
        return (this.priKeyField != null ? 1 : 0) + this.secKeyFields.size() + this.nonKeyFields.size();
    }

    private void skipToSecKeyField(RecordInput input, int toFieldNum) throws RefreshException {
        ComplexFormat superFormat = this.getComplexSuper();
        if (superFormat != null) {
            superFormat.skipToSecKeyField(input, 0x7FFFFFFE);
        }
        int maxNum = Math.min(this.secKeyFields.size(), toFieldNum);
        for (int i = 0; i < maxNum; ++i) {
            input.skipField(this.secKeyFields.get(i).getType());
        }
    }

    private void skipToNonKeyField(RecordInput input, int toFieldNum) throws RefreshException {
        ComplexFormat superFormat = this.getComplexSuper();
        if (superFormat != null) {
            superFormat.skipToNonKeyField(input, 0x7FFFFFFE);
        }
        int maxNum = Math.min(this.nonKeyFields.size(), toFieldNum);
        for (int i = 0; i < maxNum; ++i) {
            input.skipField(this.nonKeyFields.get(i).getType());
        }
    }

    @Override
    boolean evolve(Format newFormatParam, Evolver evolver) {
        Class newFormatCls;
        String newEntityClass;
        String oldEntityClass;
        if (!(newFormatParam instanceof ComplexFormat)) {
            evolver.addMissingMutation(this, newFormatParam, "Converter is required when a complex type is changed to a simple type or enum type");
            return false;
        }
        ComplexFormat newFormat = (ComplexFormat)newFormatParam;
        Mutations mutations = evolver.getMutations();
        boolean thisChanged = false;
        boolean hierarchyChanged = false;
        HashMap<String, String> allKeyNameMap = new HashMap<String, String>();
        assert (this.isEntity() == newFormat.isEntity());
        assert (this.isEntity() == (this.entityMeta != null));
        assert (newFormat.isEntity() == (newFormat.entityMeta != null));
        if (this.isEntity()) {
            oldEntityClass = this.getClassName();
            newEntityClass = newFormat.getClassName();
        } else {
            oldEntityClass = null;
            newEntityClass = null;
        }
        for (ComplexFormat oldSuper = this.getComplexSuper(); oldSuper != null; oldSuper = oldSuper.getComplexSuper()) {
            Converter converter = mutations.getConverter(oldSuper.getClassName(), oldSuper.getVersion(), null);
            if (converter != null) {
                evolver.addMissingMutation(this, newFormatParam, "Converter is required for this subclass when a Converter appears on its superclass: " + converter);
                return false;
            }
            if (!evolver.evolveFormat(oldSuper)) {
                return false;
            }
            if (oldSuper.isCurrentVersion()) continue;
            if (oldSuper.isDeleted() && !oldSuper.evolveDeletedClass(evolver)) {
                return false;
            }
            if (oldSuper.oldToNewKeyMap != null) {
                allKeyNameMap.putAll(oldSuper.oldToNewKeyMap);
            }
            hierarchyChanged = true;
        }
        Class newSuper = newFormatCls = newFormat.getExistingType();
        ArrayList<Integer> newLevels = new ArrayList<Integer>();
        int newLevel = 0;
        newLevels.add(newLevel);
        if (this.getSuperFormat() == null) {
            if (newFormatCls.getSuperclass() != Object.class) {
                thisChanged = true;
                hierarchyChanged = true;
            }
        } else if (!this.getSuperFormat().getLatestVersion().getClassName().equals(newFormatCls.getSuperclass().getName())) {
            thisChanged = true;
            hierarchyChanged = true;
        }
        for (ComplexFormat oldSuper = this.getComplexSuper(); oldSuper != null; oldSuper = oldSuper.getComplexSuper()) {
            ComplexFormat oldSuperLatest;
            Class newSuper2;
            String oldSuperName = oldSuper.getLatestVersion().getClassName();
            Class foundNewSuper = null;
            int tryNewLevel = newLevel;
            for (newSuper2 = newSuper.getSuperclass(); newSuper2 != Object.class; newSuper2 = newSuper2.getSuperclass()) {
                ++tryNewLevel;
                if (!oldSuperName.equals(newSuper2.getName())) continue;
                foundNewSuper = newSuper2;
                newLevel = tryNewLevel;
                if (!oldSuper.isEntity()) break;
                assert (oldEntityClass == null);
                assert (newEntityClass == null);
                oldEntityClass = oldSuper.getClassName();
                newEntityClass = foundNewSuper.getName();
                break;
            }
            if (foundNewSuper != null) {
                for (newSuper2 = newSuper.getSuperclass(); newSuper2 != foundNewSuper; newSuper2 = newSuper2.getSuperclass()) {
                    hierarchyChanged = true;
                    for (ComplexFormat oldSuper2 = oldSuper.getComplexSuper(); oldSuper2 != null; oldSuper2 = oldSuper2.getComplexSuper()) {
                        String oldSuper2Name = oldSuper2.getLatestVersion().getClassName();
                        if (!oldSuper2Name.equals(newSuper2.getName())) continue;
                        evolver.addMissingMutation(this, newFormatParam, "Class Converter is required when a superclass is moved in the class hierarchy: " + newSuper2.getName());
                        return false;
                    }
                }
                newSuper = foundNewSuper;
                newLevels.add(newLevel);
                continue;
            }
            hierarchyChanged = true;
            if (!oldSuper.isDeleted() && (oldSuperLatest = oldSuper.getComplexLatest()).getNFields() != 0) {
                evolver.addMissingMutation(this, newFormatParam, "When a superclass is removed from the class hierarchy, the superclass or all of its persistent fields must be deleted with a Deleter: " + oldSuperLatest.getClassName());
                return false;
            }
            if (oldEntityClass != null && this.isCurrentVersion()) {
                Map<String, SecondaryKeyMetadata> secKeys = oldSuper.clsMeta.getSecondaryKeys();
                for (FieldInfo field : oldSuper.secKeyFields) {
                    SecondaryKeyMetadata meta = ComplexFormat.getSecondaryKeyMetadataByFieldName(secKeys, field.getName());
                    assert (meta != null);
                    allKeyNameMap.put(meta.getKeyName(), null);
                }
            }
            newLevels.add(Integer.MAX_VALUE);
        }
        int result = this.evolveAllFields(newFormat, evolver);
        if (result == 2) {
            return false;
        }
        if (result == 1) {
            thisChanged = true;
        }
        if (this.oldToNewKeyMap != null) {
            allKeyNameMap.putAll(this.oldToNewKeyMap);
        }
        if (thisChanged && !evolver.checkUpdatedVersion("Changes to the fields or superclass were detected", (Format)this, (Format)newFormat)) {
            return false;
        }
        if (allKeyNameMap.size() > 0 && oldEntityClass != null && newEntityClass != null && this.isCurrentVersion()) {
            for (Map.Entry entry : allKeyNameMap.entrySet()) {
                String oldKeyName = (String)entry.getKey();
                String newKeyName = (String)entry.getValue();
                if (newKeyName != null) {
                    evolver.renameSecondaryDatabase(oldEntityClass, newEntityClass, oldKeyName, newKeyName);
                    continue;
                }
                evolver.deleteSecondaryDatabase(oldEntityClass, oldKeyName);
            }
        }
        if (hierarchyChanged || thisChanged || !this.newStringFormat) {
            EvolveReader reader = new EvolveReader(newLevels);
            evolver.useEvolvedFormat(this, reader, newFormat);
        } else {
            evolver.useOldFormat(this, newFormat);
        }
        return true;
    }

    @Override
    boolean evolveMetadata(Format newFormatParam, Converter converter, Evolver evolver) {
        Set<Object> deletedKeys;
        assert (!this.isDeleted());
        assert (this.isEntity());
        assert (newFormatParam.isEntity());
        ComplexFormat newFormat = (ComplexFormat)newFormatParam;
        if (!this.checkKeyTypeChange(newFormat, this.entityMeta.getPrimaryKey(), newFormat.entityMeta.getPrimaryKey(), "primary key", evolver)) {
            return false;
        }
        if (converter instanceof EntityConverter) {
            EntityConverter entityConverter = (EntityConverter)converter;
            deletedKeys = entityConverter.getDeletedKeys();
        } else {
            deletedKeys = Collections.emptySet();
        }
        Map<String, SecondaryKeyMetadata> oldSecondaryKeys = this.entityMeta.getSecondaryKeys();
        Map<String, SecondaryKeyMetadata> newSecondaryKeys = newFormat.entityMeta.getSecondaryKeys();
        HashSet<String> insertedKeys = new HashSet<String>(newSecondaryKeys.keySet());
        for (SecondaryKeyMetadata oldMeta : oldSecondaryKeys.values()) {
            String keyName = oldMeta.getKeyName();
            if (deletedKeys.contains(keyName)) {
                if (!this.isCurrentVersion()) continue;
                evolver.deleteSecondaryDatabase(this.getClassName(), keyName);
                continue;
            }
            SecondaryKeyMetadata newMeta = newSecondaryKeys.get(keyName);
            if (newMeta == null) {
                evolver.addInvalidMutation(this, newFormat, converter, "Existing key not found in new entity metadata: " + keyName);
                return false;
            }
            insertedKeys.remove(keyName);
            String keyLabel = "secondary key: " + keyName;
            if (!this.checkKeyTypeChange(newFormat, oldMeta, newMeta, keyLabel, evolver)) {
                return false;
            }
            if (this.checkSecKeyMetadata(newFormat, oldMeta, newMeta, evolver)) continue;
            return false;
        }
        if (!insertedKeys.isEmpty()) {
            evolver.addEvolveError(this, newFormat, "Error", "New keys " + insertedKeys + " not allowed when using a Converter with an entity class");
        }
        return true;
    }

    private boolean checkSecKeyMetadata(Format newFormat, SecondaryKeyMetadata oldMeta, SecondaryKeyMetadata newMeta, Evolver evolver) {
        if (oldMeta.getRelationship() != newMeta.getRelationship()) {
            evolver.addEvolveError(this, newFormat, "Change detected in the relate attribute (Relationship) of a secondary key", "Old key: " + oldMeta.getKeyName() + " relate: " + (Object)((Object)oldMeta.getRelationship()) + " new key: " + newMeta.getKeyName() + " relate: " + (Object)((Object)newMeta.getRelationship()));
            return false;
        }
        return true;
    }

    private boolean checkKeyTypeChange(Format newFormat, FieldMetadata oldMeta, FieldMetadata newMeta, String keyLabel, Evolver evolver) {
        String newClass;
        String oldClass = oldMeta.getClassName();
        if (!oldClass.equals(newClass = newMeta.getClassName())) {
            Format oldType = this.getCatalog().getFormat(oldClass);
            Format newType = this.getCatalog().getFormat(newClass);
            if (oldType == null || newType == null || (oldType.getWrapperFormat() == null || oldType.getWrapperFormat().getId() != newType.getId()) && (newType.getWrapperFormat() == null || newType.getWrapperFormat().getId() != oldType.getId())) {
                evolver.addEvolveError(this, newFormat, "Type change detected for " + keyLabel, "Old field type: " + oldClass + " is not compatible with the new type: " + newClass + " old field: " + oldMeta.getName() + " new field: " + newMeta.getName());
                return false;
            }
        }
        return true;
    }

    private boolean evolveDeletedClass(Evolver evolver) {
        assert (this.isDeleted());
        if (this.secKeyFieldReader == null || this.nonKeyFieldReader == null) {
            if (this.priKeyField != null && this.getEntityFormat() != null && !this.getEntityFormat().isDeleted()) {
                evolver.addEvolveError(this, this, "Class containing primary key field was deleted ", "Primary key is needed in an entity class hierarchy: " + this.priKeyField.getName());
                return false;
            }
            this.secKeyFieldReader = new SkipFieldReader(0, this.secKeyFields);
            this.nonKeyFieldReader = new SkipFieldReader(0, this.nonKeyFields);
            return true;
        }
        return true;
    }

    private int evolveAllFields(ComplexFormat newFormat, Evolver evolver) {
        assert (!this.isDeleted());
        this.secKeyFieldReader = null;
        this.nonKeyFieldReader = null;
        this.oldToNewKeyMap = null;
        boolean evolveFailure = false;
        boolean localEvolveNeeded = false;
        if (this.priKeyField != null) {
            int result = evolver.evolveRequiredKeyField(this, newFormat, this.priKeyField, newFormat.priKeyField);
            if (result == 2) {
                evolveFailure = true;
            } else if (result == 1) {
                localEvolveNeeded = true;
            }
        }
        this.copyIncorrectlyOrderedSecKeys(newFormat);
        FieldReader reader = this.evolveFieldList(this.secKeyFields, newFormat.secKeyFields, true, newFormat.nonKeyFields, newFormat, evolver);
        if (reader == FieldReader.EVOLVE_FAILURE) {
            evolveFailure = true;
        } else if (reader != null) {
            localEvolveNeeded = true;
        }
        if (reader != FieldReader.EVOLVE_NEEDED) {
            this.secKeyFieldReader = reader;
        }
        if ((reader = this.evolveFieldList(this.nonKeyFields, newFormat.nonKeyFields, false, newFormat.secKeyFields, newFormat, evolver)) == FieldReader.EVOLVE_FAILURE) {
            evolveFailure = true;
        } else if (reader != null) {
            localEvolveNeeded = true;
        }
        if (reader != FieldReader.EVOLVE_NEEDED) {
            this.nonKeyFieldReader = reader;
        }
        if (evolveFailure) {
            return 2;
        }
        if (localEvolveNeeded) {
            return 1;
        }
        return 0;
    }

    private FieldReader getDoNothingFieldReader() {
        List<FieldReader> emptyList = Collections.emptyList();
        return new MultiFieldReader(emptyList);
    }

    private FieldReader evolveFieldList(List<FieldInfo> oldFields, List<FieldInfo> newFields, boolean isOldSecKeyField, List<FieldInfo> otherNewFields, ComplexFormat newFormat, Evolver evolver) {
        Mutations mutations = evolver.getMutations();
        boolean evolveFailure = false;
        boolean localEvolveNeeded = false;
        boolean readerNeeded = false;
        ArrayList<FieldReader> fieldReaders = new ArrayList<FieldReader>();
        FieldReader currentReader = null;
        int newFieldsMatched = 0;
        block0: for (int oldFieldIndex = 0; oldFieldIndex < oldFields.size(); ++oldFieldIndex) {
            FieldInfo oldField = oldFields.get(oldFieldIndex);
            String oldName = oldField.getName();
            SecondaryKeyMetadata oldMeta = null;
            if (isOldSecKeyField) {
                oldMeta = ComplexFormat.getSecondaryKeyMetadataByFieldName(this.clsMeta.getSecondaryKeys(), oldName);
                assert (oldMeta != null);
            }
            Renamer renamer = mutations.getRenamer(this.getClassName(), this.getVersion(), oldName);
            Deleter deleter = mutations.getDeleter(this.getClassName(), this.getVersion(), oldName);
            Converter converter = mutations.getConverter(this.getClassName(), this.getVersion(), oldName);
            if (deleter != null && (converter != null || renamer != null)) {
                evolver.addInvalidMutation(this, newFormat, deleter, "Field Deleter is not allowed along with a Renamer or Converter for the same field: " + oldName);
                evolveFailure = true;
                continue;
            }
            String newName = renamer != null ? renamer.getNewName() : oldName;
            boolean nameChanged = false;
            if (!oldName.equals(newName)) {
                if (this.newToOldFieldMap == null) {
                    this.newToOldFieldMap = new HashMap<String, String>();
                }
                this.newToOldFieldMap.put(newName, oldName);
                nameChanged = true;
            }
            int newFieldIndex = FieldInfo.getFieldIndex(newFields, newName);
            FieldInfo newField = null;
            boolean isNewSecKeyField = isOldSecKeyField;
            if (newFieldIndex >= 0) {
                newField = newFields.get(newFieldIndex);
                if (nameChanged && newFormat.incorrectlyOrderedSecKeys != null && newFormat.incorrectlyOrderedSecKeys.remove(oldName)) {
                    newFormat.incorrectlyOrderedSecKeys.add(newName);
                }
                if (newFieldIndex != oldFieldIndex) {
                    localEvolveNeeded = true;
                    readerNeeded = true;
                }
            } else {
                newFieldIndex = FieldInfo.getFieldIndex(otherNewFields, newName);
                if (newFieldIndex >= 0) {
                    newField = otherNewFields.get(newFieldIndex);
                    isNewSecKeyField = !isOldSecKeyField;
                }
                localEvolveNeeded = true;
                readerNeeded = true;
                if (newFormat.incorrectlyOrderedSecKeys != null) {
                    newFormat.incorrectlyOrderedSecKeys.remove(oldName);
                }
            }
            if (deleter != null) {
                if (newField != null) {
                    evolver.addInvalidMutation(this, newFormat, deleter, "Field Deleter is not allowed when the persistent field is still present: " + oldName);
                    evolveFailure = true;
                }
                if (currentReader instanceof SkipFieldReader && currentReader.acceptField(oldFieldIndex, newFieldIndex, isNewSecKeyField)) {
                    currentReader.addField(oldField);
                } else {
                    currentReader = new SkipFieldReader(oldFieldIndex, oldField);
                    fieldReaders.add(currentReader);
                    readerNeeded = true;
                    localEvolveNeeded = true;
                }
                if (!isOldSecKeyField) continue;
                if (this.oldToNewKeyMap == null) {
                    this.oldToNewKeyMap = new HashMap<String, String>();
                }
                this.oldToNewKeyMap.put(oldMeta.getKeyName(), null);
                continue;
            }
            if (newField == null) {
                evolver.addMissingMutation(this, newFormat, "Field is not present or not persistent: " + oldName);
                evolveFailure = true;
                continue;
            }
            ++newFieldsMatched;
            SecondaryKeyMetadata newMeta = null;
            if (isOldSecKeyField && isNewSecKeyField) {
                String newKeyName;
                newMeta = ComplexFormat.getSecondaryKeyMetadataByFieldName(newFormat.clsMeta.getSecondaryKeys(), newName);
                assert (newMeta != null);
                if (!this.checkSecKeyMetadata(newFormat, oldMeta, newMeta, evolver)) {
                    evolveFailure = true;
                    continue;
                }
                String oldKeyName = oldMeta.getKeyName();
                if (!oldKeyName.equals(newKeyName = newMeta.getKeyName())) {
                    if (this.oldToNewKeyMap == null) {
                        this.oldToNewKeyMap = new HashMap<String, String>();
                    }
                    this.oldToNewKeyMap.put(oldName, newName);
                    localEvolveNeeded = true;
                }
            } else if (isOldSecKeyField && !isNewSecKeyField) {
                if (this.oldToNewKeyMap == null) {
                    this.oldToNewKeyMap = new HashMap<String, String>();
                }
                this.oldToNewKeyMap.put(oldMeta.getKeyName(), null);
            }
            if (converter != null) {
                if (isOldSecKeyField) {
                    evolver.addInvalidMutation(this, newFormat, converter, "Field Converter is not allowed for secondary key fields: " + oldName);
                    evolveFailure = true;
                    continue;
                }
                currentReader = new ConvertFieldReader(converter, oldFieldIndex, newFieldIndex, isNewSecKeyField);
                fieldReaders.add(currentReader);
                readerNeeded = true;
                localEvolveNeeded = true;
                continue;
            }
            boolean allClassesConverted = true;
            Format oldFieldFormat = oldField.getType();
            Format formatVersion = oldFieldFormat.getLatestVersion();
            while (true) {
                Set<Format> subclassFormats;
                assert (formatVersion != null);
                if (!evolver.evolveFormat(formatVersion)) {
                    evolveFailure = true;
                    continue block0;
                }
                if (!formatVersion.isNew() && !evolver.isClassConverted(formatVersion)) {
                    allClassesConverted = false;
                }
                if ((subclassFormats = evolver.getSubclassFormats(formatVersion)) != null) {
                    for (Format format2 : subclassFormats) {
                        if (!evolver.evolveFormat(format2)) {
                            evolveFailure = true;
                            continue block0;
                        }
                        if (format2.isNew() || evolver.isClassConverted(format2)) continue;
                        allClassesConverted = false;
                    }
                }
                if (formatVersion == oldFieldFormat) break;
                formatVersion = formatVersion.getPreviousVersion();
            }
            Format oldLatestFormat = oldFieldFormat.getLatestVersion();
            Format newFieldFormat = newField.getType();
            if (!oldLatestFormat.getClassName().equals(newFieldFormat.getClassName()) || oldLatestFormat.isDeleted()) {
                if (allClassesConverted) {
                    localEvolveNeeded = true;
                } else {
                    if (WidenerInput.isWideningSupported(oldLatestFormat, newFieldFormat, isOldSecKeyField)) {
                        currentReader = new WidenFieldReader(oldLatestFormat, newFieldFormat, newFieldIndex, isNewSecKeyField);
                        fieldReaders.add(currentReader);
                        readerNeeded = true;
                        localEvolveNeeded = true;
                        continue;
                    }
                    boolean refWidened = false;
                    if (!(newFieldFormat.isPrimitive() || oldLatestFormat.isPrimitive() || oldLatestFormat.isDeleted() || evolver.isClassConverted(oldLatestFormat))) {
                        Class oldCls = oldLatestFormat.getExistingType();
                        Class newCls = newFieldFormat.getExistingType();
                        if (newCls.isAssignableFrom(oldCls)) {
                            refWidened = true;
                        }
                    }
                    if (refWidened) {
                        localEvolveNeeded = true;
                    } else {
                        evolver.addMissingMutation(this, newFormat, "Old field type: " + oldLatestFormat.getClassName() + " is not compatible with the new type: " + newFieldFormat.getClassName() + " for field: " + oldName);
                        evolveFailure = true;
                        continue;
                    }
                }
            }
            if (currentReader instanceof PlainFieldReader && currentReader.acceptField(oldFieldIndex, newFieldIndex, isNewSecKeyField)) {
                currentReader.addField(oldField);
                continue;
            }
            currentReader = new PlainFieldReader(oldFieldIndex, newFieldIndex, isNewSecKeyField);
            fieldReaders.add(currentReader);
        }
        if (newFieldsMatched < newFields.size()) {
            localEvolveNeeded = true;
            readerNeeded = true;
        }
        if (evolveFailure) {
            return FieldReader.EVOLVE_FAILURE;
        }
        if (readerNeeded) {
            if (fieldReaders.size() == 0) {
                return this.getDoNothingFieldReader();
            }
            if (fieldReaders.size() == 1) {
                return (FieldReader)fieldReaders.get(0);
            }
            return new MultiFieldReader(fieldReaders);
        }
        if (localEvolveNeeded) {
            return FieldReader.EVOLVE_NEEDED;
        }
        return null;
    }

    static SecondaryKeyMetadata getSecondaryKeyMetadataByFieldName(Map<String, SecondaryKeyMetadata> secKeys, String fieldName) {
        for (SecondaryKeyMetadata meta : secKeys.values()) {
            if (!meta.getName().equals(fieldName)) continue;
            return meta;
        }
        return null;
    }

    boolean isSecKeyIncorrectlyOrdered(String keyName) {
        return this.incorrectlyOrderedSecKeys == null || this.incorrectlyOrderedSecKeys.contains(keyName);
    }

    boolean setSecKeyCorrectlyOrdered(String keyName) {
        if (this.incorrectlyOrderedSecKeys != null) {
            return this.incorrectlyOrderedSecKeys.remove(keyName);
        }
        this.incorrectlyOrderedSecKeys = new HashSet<String>();
        assert (this.entityMeta != null);
        for (String name : this.entityMeta.getSecondaryKeys().keySet()) {
            if (name.equals(keyName)) continue;
            this.incorrectlyOrderedSecKeys.add(name);
        }
        return true;
    }

    private void copyIncorrectlyOrderedSecKeys(ComplexFormat newFormat) {
        if (this == this.getLatestVersion()) {
            newFormat.incorrectlyOrderedSecKeys = this.incorrectlyOrderedSecKeys == null ? null : new HashSet<String>(this.incorrectlyOrderedSecKeys);
        }
    }

    public Set<String> getIncorrectlyOrderedSecKeys() {
        return this.incorrectlyOrderedSecKeys;
    }

    @Override
    public Accessor getAccessor(boolean rawAccess) {
        return rawAccess ? this.rawAccessor : this.objAccessor;
    }

    private static class EvolveReader
    implements Reader {
        static final int DO_NOT_READ_ACCESSOR = Integer.MAX_VALUE;
        private static final long serialVersionUID = -1016140948306913283L;
        private transient ComplexFormat newFormat;
        private transient ComplexFormat[] oldHierarchy;
        private int[] newHierarchyLevels;

        EvolveReader(List<Integer> newHierarchyLevelsList) {
            int oldDepth = newHierarchyLevelsList.size();
            this.newHierarchyLevels = new int[oldDepth];
            newHierarchyLevelsList.toArray();
            for (int i = 0; i < oldDepth; ++i) {
                this.newHierarchyLevels[i] = newHierarchyLevelsList.get(i);
            }
        }

        @Override
        public void initializeReader(Catalog catalog, EntityModel model, int initVersion, Format oldFormatParam) {
            ComplexFormat oldFormat = (ComplexFormat)oldFormatParam;
            this.newFormat = oldFormat.getComplexLatest();
            this.newFormat.initializeIfNeeded(catalog, model);
            int newDepth = 0;
            for (Format format = this.newFormat; format != null; format = format.getSuperFormat()) {
                ++newDepth;
            }
            ComplexFormat[] newHierarchy = new ComplexFormat[newDepth];
            int level = 0;
            for (ComplexFormat format = this.newFormat; format != null; format = format.getComplexSuper()) {
                newHierarchy[level] = format;
                ++level;
            }
            assert (level == newDepth);
            int oldDepth = this.newHierarchyLevels.length;
            this.oldHierarchy = new ComplexFormat[oldDepth];
            level = 0;
            for (ComplexFormat oldFormat2 = oldFormat; oldFormat2 != null; oldFormat2 = oldFormat2.getComplexSuper()) {
                this.oldHierarchy[level] = oldFormat2;
                int level2 = this.newHierarchyLevels[level];
                ComplexFormat newFormat2 = level2 != Integer.MAX_VALUE ? newHierarchy[level2] : null;
                ++level;
                if (oldFormat2.secKeyFieldReader != null) {
                    oldFormat2.secKeyFieldReader.initialize(catalog, initVersion, oldFormat2, newFormat2, true);
                }
                if (oldFormat2.nonKeyFieldReader == null) continue;
                oldFormat2.nonKeyFieldReader.initialize(catalog, initVersion, oldFormat2, newFormat2, false);
            }
            assert (level == oldDepth);
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return this.newFormat.newInstance(input, rawAccess);
        }

        @Override
        public void readPriKey(Object o, EntityInput input, boolean rawAccess) throws RefreshException {
            this.newFormat.readPriKey(o, input, rawAccess);
        }

        @Override
        public Object readObject(Object o, EntityInput input, boolean rawAccess) throws RefreshException {
            int newLevel;
            FieldReader reader;
            int maxMinusOne;
            int i;
            Accessor accessor = rawAccess ? this.newFormat.rawAccessor : this.newFormat.objAccessor;
            for (i = maxMinusOne = this.oldHierarchy.length - 1; i >= 0; --i) {
                reader = this.oldHierarchy[i].secKeyFieldReader;
                newLevel = this.newHierarchyLevels[i];
                if (reader != null) {
                    reader.readFields(o, input, accessor, newLevel);
                    continue;
                }
                if (newLevel == Integer.MAX_VALUE) continue;
                accessor.readSecKeyFields(o, input, 0, 0x7FFFFFFE, newLevel);
            }
            for (i = maxMinusOne; i >= 0; --i) {
                reader = this.oldHierarchy[i].nonKeyFieldReader;
                newLevel = this.newHierarchyLevels[i];
                if (reader != null) {
                    reader.readFields(o, input, accessor, newLevel);
                    continue;
                }
                if (newLevel == Integer.MAX_VALUE) continue;
                accessor.readNonKeyFields(o, input, 0, 0x7FFFFFFE, newLevel);
            }
            return o;
        }

        @Override
        public Accessor getAccessor(boolean rawAccess) {
            return this.newFormat.getAccessor(rawAccess);
        }
    }

    private static class MultiFieldReader
    extends FieldReader {
        private static final long serialVersionUID = -6035976787562441473L;
        private List<FieldReader> subReaders;

        MultiFieldReader(List<FieldReader> subReaders) {
            this.subReaders = subReaders;
        }

        @Override
        void initialize(Catalog catalog, int initVersion, ComplexFormat oldParentFormat, ComplexFormat newParentFormat, boolean isOldSecKey) {
            for (FieldReader reader : this.subReaders) {
                reader.initialize(catalog, initVersion, oldParentFormat, newParentFormat, isOldSecKey);
            }
        }

        @Override
        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) throws RefreshException {
            for (FieldReader reader : this.subReaders) {
                reader.readFields(o, input, accessor, superLevel);
            }
        }
    }

    private static class WidenFieldReader
    extends FieldReader {
        private static final long serialVersionUID = -2054520670170407282L;
        private int fromFormatId;
        private int toFormatId;
        private int fieldNum;
        private boolean secKeyField;

        WidenFieldReader(Format oldFormat, Format newFormat, int newFieldIndex, boolean isNewSecKeyField) {
            this.fromFormatId = oldFormat.getId();
            this.toFormatId = newFormat.getId();
            this.fieldNum = newFieldIndex;
            this.secKeyField = isNewSecKeyField;
        }

        @Override
        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) throws RefreshException {
            WidenerInput widenerInput = new WidenerInput(input, this.fromFormatId, this.toFormatId);
            if (this.secKeyField) {
                accessor.readSecKeyFields(o, widenerInput, this.fieldNum, this.fieldNum, superLevel);
            } else {
                accessor.readNonKeyFields(o, widenerInput, this.fieldNum, this.fieldNum, superLevel);
            }
        }
    }

    private static class ConvertFieldReader
    extends FieldReader {
        private static final long serialVersionUID = 8736410481633998710L;
        private Converter converter;
        private int oldFieldNum;
        private int fieldNum;
        private boolean secKeyField;
        private transient Format oldFormat;
        private transient Format newFormat;

        ConvertFieldReader(Converter converter, int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            this.converter = converter;
            this.oldFieldNum = oldFieldIndex;
            this.fieldNum = newFieldIndex;
            this.secKeyField = isNewSecKeyField;
        }

        @Override
        void initialize(Catalog catalog, int initVersion, ComplexFormat oldParentFormat, ComplexFormat newParentFormat, boolean isOldSecKey) {
            if (initVersion < 1) {
                this.oldFieldNum = this.fieldNum;
            }
            this.oldFormat = isOldSecKey ? ((FieldInfo)oldParentFormat.secKeyFields.get(this.oldFieldNum)).getType() : ((FieldInfo)oldParentFormat.nonKeyFields.get(this.oldFieldNum)).getType();
            this.newFormat = this.secKeyField ? ((FieldInfo)newParentFormat.secKeyFields.get(this.fieldNum)).getType() : ((FieldInfo)newParentFormat.nonKeyFields.get(this.fieldNum)).getType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) throws RefreshException {
            Object value;
            boolean currentRawMode = input.setRawAccess(true);
            try {
                value = this.oldFormat.isPrimitive() ? input.readKeyObject(this.oldFormat) : (this.oldFormat.getId() == 18 ? input.readStringObject() : input.readObject());
            }
            finally {
                input.setRawAccess(currentRawMode);
            }
            Catalog catalog = input.getCatalog();
            value = this.converter.getConversion().convert(value);
            RawSingleInput rawInput = new RawSingleInput(catalog, currentRawMode, null, value, this.newFormat);
            if (this.secKeyField) {
                accessor.readSecKeyFields(o, rawInput, this.fieldNum, this.fieldNum, superLevel);
            } else {
                accessor.readNonKeyFields(o, rawInput, this.fieldNum, this.fieldNum, superLevel);
            }
        }
    }

    private static class SkipFieldReader
    extends FieldReader {
        private static final long serialVersionUID = -3060281692155253098L;
        private List<Format> fieldFormats;
        private transient int endField;

        SkipFieldReader(int startField, List<FieldInfo> fields) {
            this.endField = startField + fields.size() - 1;
            this.fieldFormats = new ArrayList<Format>(fields.size());
            for (FieldInfo field : fields) {
                this.fieldFormats.add(field.getType());
            }
        }

        SkipFieldReader(int startField, FieldInfo oldField) {
            this.endField = startField;
            this.fieldFormats = new ArrayList<Format>();
            this.fieldFormats.add(oldField.getType());
        }

        @Override
        boolean acceptField(int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            return oldFieldIndex == this.endField + 1;
        }

        @Override
        void addField(FieldInfo oldField) {
            ++this.endField;
            this.fieldFormats.add(oldField.getType());
        }

        @Override
        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) throws RefreshException {
            for (Format format : this.fieldFormats) {
                input.skipField(format);
            }
        }
    }

    private static class PlainFieldReader
    extends FieldReader {
        private static final long serialVersionUID = 1795593463439931402L;
        private int startField;
        private int endField;
        private boolean secKeyField;
        private transient int endOldField;

        PlainFieldReader(int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            this.endOldField = oldFieldIndex;
            this.startField = newFieldIndex;
            this.endField = newFieldIndex;
            this.secKeyField = isNewSecKeyField;
        }

        @Override
        boolean acceptField(int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            return oldFieldIndex == this.endOldField + 1 && newFieldIndex == this.endField + 1 && this.secKeyField == isNewSecKeyField;
        }

        @Override
        void addField(FieldInfo oldField) {
            ++this.endField;
            ++this.endOldField;
        }

        @Override
        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) throws RefreshException {
            if (this.secKeyField) {
                accessor.readSecKeyFields(o, input, this.startField, this.endField, superLevel);
            } else {
                accessor.readNonKeyFields(o, input, this.startField, this.endField, superLevel);
            }
        }
    }

    private static abstract class FieldReader
    implements Serializable {
        static final FieldReader EVOLVE_NEEDED = new PlainFieldReader(0, 0, false);
        static final FieldReader EVOLVE_FAILURE = new PlainFieldReader(0, 0, false);
        private static final long serialVersionUID = 866041475399255164L;

        FieldReader() {
        }

        void initialize(Catalog catalog, int initVersion, ComplexFormat oldParentFormat, ComplexFormat newParentFormat, boolean isOldSecKey) {
        }

        boolean acceptField(int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            return false;
        }

        void addField(FieldInfo oldField) {
            throw DbCompat.unexpectedState();
        }

        abstract void readFields(Object var1, EntityInput var2, Accessor var3, int var4) throws RefreshException;
    }

    private static class FieldAddress {
        boolean isSecField;
        int fieldNum;
        int superLevel;
        ComplexFormat clsFormat;
        Format keyFormat;

        FieldAddress(boolean isSecField, int fieldNum, int superLevel, ComplexFormat clsFormat, Format keyFormat) {
            this.isSecField = isSecField;
            this.fieldNum = fieldNum;
            this.superLevel = superLevel;
            this.clsFormat = clsFormat;
            this.keyFormat = keyFormat;
        }
    }
}

