/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.tracing.NoopAware;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.Tracer;
import com.tangosol.internal.tracing.TracingShim;
import com.tangosol.internal.tracing.TracingShimLoader;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.util.Base;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public final class TracingHelper {
    protected static TracingShim m_tracingShim = TracingShim.Noop.INSTANCE;

    private TracingHelper() {
    }

    public static TracingShim.Control initialize(TracingShim.Dependencies dependencies) {
        TracingShim tracingShim = m_tracingShim;
        ClassLoader[] classLoaders = new ClassLoader[]{Base.getContextClassLoader(), TracingShimLoader.class.getClassLoader()};
        int len = classLoaders.length;
        block4: for (int i = 0; i < len; ++i) {
            ClassLoader loader = classLoaders[i];
            try {
                ServiceLoader<TracingShimLoader> tracingShimLoaderService = ServiceLoader.load(TracingShimLoader.class, loader);
                for (TracingShimLoader tracingShimLoader : tracingShimLoaderService) {
                    try {
                        tracingShim = tracingShimLoader.loadTracingShim();
                    }
                    catch (Throwable t) {
                        Logger.err("Error invoking TracingShimLoader.loadTracingShim().  Continuing to search for a valid tracing shim: ", t);
                        continue;
                    }
                    if (TracingHelper.isNoop(tracingShim)) continue;
                    m_tracingShim = tracingShim;
                    break block4;
                }
                break;
            }
            catch (Throwable t) {
                if (!Logger.isEnabled(2)) continue;
                String msg = "Error loading tracing shim using the %s classloader:";
                if (i == 0) {
                    Logger.warn(String.format(msg, "context"), t);
                    Logger.warn("Attempting to load tracing shim using the fallback classloader.");
                    continue;
                }
                Logger.warn(String.format(msg, "fallback"), t);
                Logger.warn("Tracing failed to initialize.");
                continue;
            }
        }
        return tracingShim.initialize(dependencies);
    }

    public static boolean isEnabled() {
        return m_tracingShim.isEnabled();
    }

    public static Tracer getTracer() {
        return m_tracingShim.getTracer();
    }

    public static Span getActiveSpan() {
        return TracingHelper.isEnabled() ? TracingHelper.getTracer().getCurrentSpan() : null;
    }

    public static Span augmentSpan() {
        Span span = TracingHelper.getActiveSpan();
        return span == null ? m_tracingShim.getNoopSpan() : span;
    }

    public static Span augmentSpanWithErrorDetails(Span span, boolean fIsError, final Throwable t) {
        if (!TracingHelper.isNoop(span)) {
            if (fIsError) {
                span.setMetadata("error", true);
            }
            span.log((Map<String, ? super Serializable>)new HashMap<String, Serializable>(5){
                {
                    super(arg0);
                    this.put("event", "error");
                    this.put("error.object", t);
                }
            });
        }
        return span;
    }

    public static Span.Builder newSpan(String sOpName) {
        if (TracingHelper.isEnabled()) {
            Span.Builder builder = TracingHelper.getTracer().spanBuilder(sOpName).withMetadata("thread", Thread.currentThread().getName());
            try {
                Member member;
                Cluster cluster = CacheFactory.getCluster();
                Member member2 = member = cluster.isRunning() ? cluster.getLocalMember() : null;
                if (member != null) {
                    builder = builder.withMetadata("member", member.getId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Float.compare(0.0f, m_tracingShim.getDependencies().getSamplingRatio()) == 0 ? new ConditionalSpanBuilder(builder) : builder;
        }
        return m_tracingShim.getNoopSpanBuilder();
    }

    public static Span.Builder newSpan(String sStage, Object op) {
        if (TracingHelper.isEnabled()) {
            String sOpName;
            String sOpClass = null;
            if (op == null) {
                sOpName = sStage;
            } else {
                Class<?> clz = op.getClass();
                sOpName = sOpClass = clz.getName();
                int ofDot = sOpName.lastIndexOf(46) + 1;
                sOpName = sOpName.endsWith("$Poll") ? sOpName.substring(ofDot, sOpName.length() - 5) : sOpName.substring(ofDot);
                int ofDol = sOpName.lastIndexOf(36) + 1;
                String string = sOpName = sOpName.endsWith("Request") ? sOpName.substring(ofDol, sOpName.length() - 7) : sOpName.substring(ofDol);
                if (sStage != null) {
                    sOpName = sOpName + '.' + sStage;
                }
            }
            Span.Builder builder = TracingHelper.newSpan(sOpName);
            if (sOpClass != null) {
                builder = builder.withMetadata("operation.class", sOpClass);
            }
            builder = builder.withMetadata("span.kind", sStage == null || !sStage.equals("request") ? "server" : "client");
            return builder;
        }
        return TracingHelper.newSpan("no-op");
    }

    public static boolean isNoop(NoopAware target) {
        return target == null || target.isNoop();
    }

    protected static class ConditionalSpanBuilder
    implements Span.Builder {
        protected Span.Builder m_delegate;
        protected boolean m_fIgnoreActiveSpan;

        protected ConditionalSpanBuilder(Span.Builder delegate) {
            Objects.requireNonNull(delegate, "Parameter delegate cannot be null");
            this.m_delegate = delegate;
        }

        @Override
        public Span.Builder setParent(Span parent) {
            if (!TracingHelper.isNoop(parent)) {
                this.m_delegate = this.m_delegate.setParent(parent);
            }
            return this;
        }

        @Override
        public Span.Builder setParent(SpanContext remoteParent) {
            if (!TracingHelper.isNoop(remoteParent)) {
                this.m_delegate = this.m_delegate.setParent(remoteParent);
            }
            return this;
        }

        @Override
        public Span.Builder setNoParent() {
            this.m_fIgnoreActiveSpan = true;
            this.m_delegate = this.m_delegate.setNoParent();
            return this;
        }

        @Override
        public Span.Builder withMetadata(String sKey, String sValue) {
            this.m_delegate = this.m_delegate.withMetadata(sKey, sValue);
            return this;
        }

        @Override
        public Span.Builder withMetadata(String sKey, boolean fValue) {
            this.m_delegate = this.m_delegate.withMetadata(sKey, fValue);
            return this;
        }

        @Override
        public Span.Builder withMetadata(String sKey, long lValue) {
            this.m_delegate = this.m_delegate.withMetadata(sKey, lValue);
            return this;
        }

        @Override
        public Span.Builder withMetadata(String sKey, double dValue) {
            this.m_delegate = this.m_delegate.withMetadata(sKey, dValue);
            return this;
        }

        @Override
        public Span.Builder withAssociation(String sLabel, SpanContext associatedContext) {
            this.m_delegate = this.m_delegate.withAssociation(sLabel, associatedContext);
            return this;
        }

        @Override
        public Span.Builder setStartTimestamp(long ldtStartTime) {
            this.m_delegate = this.m_delegate.setStartTimestamp(ldtStartTime);
            return this;
        }

        @Override
        public Span startSpan() {
            return this.dropSpan() ? m_tracingShim.getNoopSpan() : this.m_delegate.startSpan();
        }

        protected boolean dropSpan() {
            return this.m_fIgnoreActiveSpan || TracingHelper.isNoop(TracingHelper.getActiveSpan());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConditionalSpanBuilder)) {
                return false;
            }
            ConditionalSpanBuilder that = (ConditionalSpanBuilder)o;
            return this.m_fIgnoreActiveSpan == that.m_fIgnoreActiveSpan && Base.equals(this.m_delegate, that.m_delegate);
        }

        public int hashCode() {
            return Objects.hash(this.m_delegate, this.m_fIgnoreActiveSpan);
        }

        public String toString() {
            return "ConditionalSpanBuilder(DelegateBuilder=" + this.m_delegate + ", IgnoreActiveSpan=" + this.m_fIgnoreActiveSpan + ')';
        }
    }
}

