/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing.opentracing33;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.tracing.TracingShim;
import com.tangosol.internal.tracing.TracingShimLoader;
import com.tangosol.internal.tracing.opentracing33.OpenTracingShim;
import com.tangosol.util.Base;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OpenTracingShimLoader
implements TracingShimLoader {
    protected static final Map<String, String> EXPECTED_CLASSES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("io.opentracing.Span", "opentracing-api");
            this.put("io.opentracing.noop.NoopSpan", "opentracing-noop");
            this.put("io.opentracing.util.GlobalTracer", "opentracing-util");
            this.put("io.opentracing.contrib.tracerresolver.TracerResolver", "opentracing-tracerresolver");
        }
    });

    @Override
    public TracingShim loadTracingShim() {
        return this.ensureDependenciesPresent() ? new OpenTracingShim() : TracingShim.Noop.INSTANCE;
    }

    protected boolean ensureDependenciesPresent() {
        ClassLoader loader = Base.getContextClassLoader();
        ArrayList<String> listMissingDeps = null;
        for (Map.Entry<String, String> entry : EXPECTED_CLASSES.entrySet()) {
            String sClassName = entry.getKey();
            if (this.ensureClassPresent(sClassName, loader)) continue;
            if (listMissingDeps == null) {
                listMissingDeps = new ArrayList<String>(EXPECTED_CLASSES.size());
            }
            listMissingDeps.add(entry.getValue());
        }
        if (listMissingDeps != null) {
            Logger.info("Tracing support will not be enabled.  The following dependencies appear to be missing: " + ((Object)listMissingDeps).toString());
            return false;
        }
        try {
            Class<?> clsGlobalTracer = Class.forName("io.opentracing.util.GlobalTracer");
            clsGlobalTracer.getMethod("registerIfAbsent", Class.forName("io.opentracing.Tracer", false, loader));
        }
        catch (NoSuchMethodException e) {
            Logger.warn("Detected incompatible OpenTracing artifacts on the classpath. Coherence supports OpenTracing 0.32.0 or later.");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return true;
    }

    protected boolean ensureClassPresent(String sClassName, ClassLoader classLoader) {
        try {
            Class.forName(sClassName, false, classLoader);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

