/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.net.BackingMapContext;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class ConversionHelper {
    protected static final Converter CONV_MAPVALUES = new MapValuesConverter();
    public static final Converter<BackingMapContext, String> CONV_CACHE_NAME = BackingMapContext::getCacheName;

    public static Converter getCollectionConverter(final Converter convUp, final Converter convDown) {
        return new Converter(){

            @Override
            public Object convert(Object value) {
                return ConverterCollections.getCollection((Collection)value, convUp, convDown);
            }
        };
    }

    public static Collection getFilterCollection(Collection col, Filter filter) {
        return new FilterCollection(col, filter);
    }

    public static Converter getMapValuesConverter() {
        return CONV_MAPVALUES;
    }

    public static Converter<BackingMapContext, String> getCacheNameConverter() {
        return CONV_CACHE_NAME;
    }

    public static Converter getMapValuesConverter(Converter convUp, Converter convDown) {
        return new MapValuesConverter(convUp, convDown);
    }

    protected static class FilterCollection<E>
    extends AbstractCollection<E> {
        protected final Collection f_col;
        protected final Filter f_filter;
        protected int m_cSize = -1;

        protected FilterCollection(Collection<E> col, Filter filter) {
            this.f_col = col;
            this.f_filter = filter;
        }

        @Override
        public Iterator<E> iterator() {
            return new FilterEnumerator(this.f_col.iterator(), this.f_filter);
        }

        @Override
        public int size() {
            if (this.m_cSize < 0) {
                int cSize = 0;
                Iterator<E> iter = this.iterator();
                while (iter.hasNext()) {
                    ++cSize;
                    iter.next();
                }
                this.m_cSize = cSize;
            }
            return this.m_cSize;
        }

        @Override
        public boolean isEmpty() {
            Iterator<E> iter = this.iterator();
            return !iter.hasNext();
        }
    }

    protected static class MapValuesConverter
    implements Converter {
        protected final Converter f_convUp;
        protected final Converter f_convDown;

        public MapValuesConverter() {
            this(null, null);
        }

        public MapValuesConverter(Converter convUp, Converter convDown) {
            this.f_convUp = convUp;
            this.f_convDown = convDown;
        }

        @Override
        public Object convert(Object value) {
            Collection colVals = ((Map)value).values();
            if (this.f_convUp != null || this.f_convDown != null) {
                colVals = ConverterCollections.getCollection(colVals, this.f_convUp, this.f_convDown);
            }
            return colVals;
        }
    }
}

