/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.DoubleConsumer;
import javax.json.bind.annotation.JsonbProperty;

public class DoubleBag
implements ExternalizableLite,
PortableObject {
    protected static final double[] EMPTY_ARRAY = new double[0];
    @JsonbProperty(value="array")
    protected double[] m_a;
    @JsonbProperty(value="size")
    protected int m_c;

    public DoubleBag() {
        this.m_a = EMPTY_ARRAY;
    }

    public DoubleBag(int nInitialCapacity) {
        this.m_a = new double[nInitialCapacity];
    }

    public void add(double dfl) {
        int i = this.m_c++;
        this.ensureStorage((int)(i + 1))[i] = dfl;
    }

    public void addAll(DoubleBag that) {
        double[] aThat = that.m_a;
        int cThat = that.m_c;
        this.ensureStorage(this.m_c + cThat);
        for (int i = 0; i < cThat; ++i) {
            this.add(aThat[i]);
        }
    }

    public void forEach(DoubleConsumer consumer) {
        double[] a = this.m_a;
        int c = this.m_c;
        for (int i = 0; i < c; ++i) {
            consumer.accept(a[i]);
        }
    }

    public int size() {
        return this.m_c;
    }

    public double[] toArray() {
        double[] a = this.m_a;
        int c = this.m_c;
        double[] aCopy = new double[c];
        System.arraycopy(a, 0, aCopy, 0, c);
        return aCopy;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int c = this.m_c = in.readInt();
        double[] a = new double[c];
        for (int i = 0; i < c; ++i) {
            a[i] = in.readDouble();
        }
        this.m_a = a;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        double[] a = this.m_a;
        int c = this.m_c;
        out.writeInt(c);
        for (int i = 0; i < c; ++i) {
            out.writeDouble(a[i]);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        double[] a = in.readDoubleArray(0);
        this.m_a = a;
        this.m_c = a.length;
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeDoubleArray(0, this.toArray());
    }

    public int hashCode() {
        double[] a = this.m_a;
        int n = 0;
        int c = this.m_c;
        for (int i = 0; i < c; ++i) {
            long l = Double.doubleToLongBits(a[i]);
            n = n * 31 + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.forEach(n -> sb.append(sb.length() == 0 ? "" : ", ").append(n));
        return "[" + sb + "]";
    }

    public boolean equals(Object oThat) {
        if (oThat == this) {
            return true;
        }
        if (!(oThat instanceof DoubleBag)) {
            return false;
        }
        DoubleBag that = (DoubleBag)oThat;
        double[] aThat = that.m_a;
        int cThat = that.m_c;
        double[] a = this.m_a;
        int c = this.m_c;
        if (c != cThat) {
            return false;
        }
        for (int i = 0; i < c; ++i) {
            if (a[i] == aThat[i]) continue;
            return false;
        }
        return true;
    }

    protected double[] ensureStorage(int c) {
        double[] a = this.m_a;
        if (a.length < c) {
            double[] aNew = new double[c * 2];
            System.arraycopy(a, 0, aNew, 0, a.length);
            a = aNew;
            this.m_a = aNew;
        }
        return a;
    }
}

