/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.graal;

import com.tangosol.internal.util.graal.ScriptHandler;
import com.tangosol.util.ScriptException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Value;

public class ScriptManager {
    private static final ScriptManager INSTANCE = new ScriptManager();
    private final Context f_context;
    private final Map<String, ScriptHandler> f_handlers = new HashMap<String, ScriptHandler>();
    private final Map<String, Boolean> m_onReadyCalled = new HashMap<String, Boolean>();

    private ScriptManager() {
        for (ScriptHandler handler : ServiceLoader.load(ScriptHandler.class)) {
            this.f_handlers.put(handler.getLanguage(), handler);
        }
        Context.Builder builder = Context.newBuilder((String[])new String[0]).allowAllAccess(true).allowHostAccess(HostAccess.ALL).allowPolyglotAccess(PolyglotAccess.ALL);
        for (ScriptHandler handler : this.f_handlers.values()) {
            handler.configure(builder);
            this.m_onReadyCalled.put(handler.getLanguage(), false);
        }
        this.f_context = builder.build();
        for (ScriptHandler handler : this.f_handlers.values()) {
            handler.initContext(this.f_context);
        }
    }

    public Context getContext() {
        return this.f_context;
    }

    public Collection<String> getSupportedLanguages() {
        return this.f_handlers.values().stream().map(h -> h.getLanguage()).collect(Collectors.toCollection(HashSet::new));
    }

    public Value execute(String sLanguage, String sName, Object ... aoArgs) {
        this.checkAndLoadStartupScripts(sLanguage);
        try {
            Value value = this.f_context.getBindings(sLanguage).getMember(sName);
            if (value == null) {
                throw new ScriptException("no object with name (" + sName + ") bound to the Context");
            }
            if (value.canInstantiate()) {
                value = value.newInstance(aoArgs);
            } else if (value.canExecute()) {
                value = value.execute(aoArgs);
            }
            return value;
        }
        catch (Throwable e) {
            throw new ScriptException("error ", e);
        }
    }

    public ScriptHandler getHandler(String sLanguage) {
        ScriptHandler handler = this.f_handlers.get(sLanguage);
        if (handler != null) {
            return handler;
        }
        throw new IllegalArgumentException("Unknown language: " + sLanguage);
    }

    public Value evaluateScript(String sLanguage, String sScriptPath) throws ScriptException {
        return this.getHandler(sLanguage).evaluateScript(sScriptPath);
    }

    private void checkAndLoadStartupScripts(String sLanguage) {
        if (!this.m_onReadyCalled.get(sLanguage).booleanValue()) {
            ScriptHandler handler = this.f_handlers.get(sLanguage);
            if (handler == null) {
                throw new ScriptException("Unsupported language: " + sLanguage);
            }
            handler.onReady(this.f_context);
            this.m_onReadyCalled.put(sLanguage, true);
        }
    }

    public static ScriptManager getInstance() {
        return INSTANCE;
    }
}

