/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.json.bind.annotation.JsonbProperty;

public class ClassIdentity
implements ExternalizableLite,
PortableObject {
    @JsonbProperty(value="package")
    protected String m_sPackage;
    @JsonbProperty(value="baseName")
    protected String m_sBaseName;
    @JsonbProperty(value="version")
    protected String m_sVersion;

    public ClassIdentity() {
    }

    public ClassIdentity(Class<?> clazz) {
        this(clazz.getPackage().getName().replace('.', '/'), clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1), Base.toHex(ClassIdentity.md5(clazz)));
    }

    protected ClassIdentity(String sPackage, String sBaseName, String sVersion) {
        this.m_sPackage = sPackage;
        this.m_sBaseName = sBaseName;
        this.m_sVersion = sVersion;
    }

    public String getPackage() {
        return this.m_sPackage;
    }

    public String getBaseName() {
        return this.m_sBaseName;
    }

    public String getVersion() {
        return this.m_sVersion;
    }

    public String getName() {
        return this.getPackage() + "/" + this.getSimpleName();
    }

    public String getSimpleName() {
        return this.getBaseName() + "$" + this.getVersion();
    }

    public boolean equals(Object o) {
        if (o instanceof ClassIdentity) {
            ClassIdentity that = (ClassIdentity)o;
            return this == that || this.getClass() == that.getClass() && Base.equals(this.m_sPackage, that.m_sPackage) && Base.equals(this.m_sBaseName, that.m_sBaseName) && Base.equals(this.m_sVersion, that.m_sVersion);
        }
        return false;
    }

    public int hashCode() {
        int nHash = this.m_sPackage.hashCode();
        nHash = 31 * nHash + this.m_sBaseName.hashCode();
        nHash = 31 * nHash + this.m_sVersion.hashCode();
        return nHash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{package='" + this.m_sPackage + '\'' + ", baseName='" + this.m_sBaseName + '\'' + ", version='" + this.m_sVersion + '\'' + '}';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sPackage = ExternalizableHelper.readSafeUTF(in);
        this.m_sBaseName = ExternalizableHelper.readSafeUTF(in);
        this.m_sVersion = ExternalizableHelper.readSafeUTF(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF(out, this.m_sPackage);
        ExternalizableHelper.writeSafeUTF(out, this.m_sBaseName);
        ExternalizableHelper.writeSafeUTF(out, this.m_sVersion);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sPackage = in.readString(0);
        this.m_sBaseName = in.readString(1);
        this.m_sVersion = in.readString(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sPackage);
        out.writeString(1, this.m_sBaseName);
        out.writeString(2, this.m_sVersion);
    }

    public static byte[] md5(String s) {
        return ClassIdentity.digest("MD5", s.getBytes());
    }

    public static byte[] md5(InputStream in) {
        return ClassIdentity.digest("MD5", in);
    }

    public static byte[] md5(Class<?> clazz) {
        byte[] byArray;
        block8: {
            InputStream in = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
            try {
                byArray = ClassIdentity.md5(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Base.ensureRuntimeException(e);
                }
            }
            in.close();
        }
        return byArray;
    }

    protected static byte[] digest(String sAlgorithm, byte[] ab) {
        try {
            MessageDigest digest = MessageDigest.getInstance(sAlgorithm);
            return digest.digest(ab);
        }
        catch (NoSuchAlgorithmException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected static byte[] digest(String sAlgorithm, InputStream in) {
        try {
            int cb;
            MessageDigest digest = MessageDigest.getInstance(sAlgorithm);
            byte[] ab = new byte[1024];
            while ((cb = in.read(ab, 0, 1024)) > 0) {
                digest.update(ab, 0, cb);
            }
            return digest.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw Base.ensureRuntimeException(e);
        }
    }
}

