/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke.lambda;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.SerializationSupport;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Objects;
import javax.json.bind.annotation.JsonbProperty;

public class StaticLambdaInfo<T>
implements ExternalizableLite,
PortableObject,
SerializationSupport {
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    @JsonbProperty(value="capturingClass")
    protected String m_sCapturingClass;
    @JsonbProperty(value="functionalInterfaceClass")
    protected String m_sFunctionalInterfaceClass;
    @JsonbProperty(value="functionalInterfaceMethodName")
    protected String m_sFunctionalInterfaceMethodName;
    @JsonbProperty(value="functionalInterfaceMethodSignature")
    protected String m_sFunctionalInterfaceMethodSignature;
    @JsonbProperty(value="implClass")
    protected String m_sImplClass;
    @JsonbProperty(value="implMethodName")
    protected String m_sImplMethodName;
    @JsonbProperty(value="implMethodSignature")
    protected String m_sImplMethodSignature;
    @JsonbProperty(value="implMethodKind")
    protected int m_nImplMethodKind;
    @JsonbProperty(value="instantiatedMethodType")
    protected String m_sInstantiatedMethodType;
    @JsonbProperty(value="capturedArgs")
    protected Object[] m_aoCapturedArgs;

    public StaticLambdaInfo() {
    }

    public StaticLambdaInfo(Class<T> clz, T function) {
        SerializedLambda lambda = Lambdas.getSerializedLambda(function);
        this.m_sCapturingClass = lambda.getCapturingClass();
        this.m_sFunctionalInterfaceClass = lambda.getFunctionalInterfaceClass();
        this.m_sFunctionalInterfaceMethodName = lambda.getFunctionalInterfaceMethodName();
        this.m_sFunctionalInterfaceMethodSignature = lambda.getFunctionalInterfaceMethodSignature();
        this.m_nImplMethodKind = lambda.getImplMethodKind();
        this.m_sImplClass = lambda.getImplClass();
        this.m_sImplMethodName = lambda.getImplMethodName();
        this.m_sImplMethodSignature = lambda.getImplMethodSignature();
        this.m_sInstantiatedMethodType = lambda.getInstantiatedMethodType();
        this.m_aoCapturedArgs = StaticLambdaInfo.getCapturedArguments(lambda);
    }

    public String getCapturingClass() {
        return this.m_sCapturingClass;
    }

    public String getFunctionalInterfaceClass() {
        return this.m_sFunctionalInterfaceClass;
    }

    public String getFunctionalInterfaceMethodName() {
        return this.m_sFunctionalInterfaceMethodName;
    }

    public String getFunctionalInterfaceMethodSignature() {
        return this.m_sFunctionalInterfaceMethodSignature;
    }

    public String getImplClass() {
        return this.m_sImplClass;
    }

    public String getImplMethodName() {
        return this.m_sImplMethodName;
    }

    public String getImplMethodSignature() {
        return this.m_sImplMethodSignature;
    }

    public int getImplMethodKind() {
        return this.m_nImplMethodKind;
    }

    public final String getInstantiatedMethodType() {
        return this.m_sInstantiatedMethodType;
    }

    public Object[] getCapturedArgs() {
        return this.m_aoCapturedArgs;
    }

    public int getCapturedArgCount() {
        return this.m_aoCapturedArgs.length;
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return StaticLambdaInfo.createLambda(this.toSerializedLambda(Base.getContextClassLoader(this)));
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sCapturingClass = ExternalizableHelper.readSafeUTF(in);
        this.m_sFunctionalInterfaceClass = ExternalizableHelper.readSafeUTF(in);
        this.m_sFunctionalInterfaceMethodName = ExternalizableHelper.readSafeUTF(in);
        this.m_sFunctionalInterfaceMethodSignature = ExternalizableHelper.readSafeUTF(in);
        this.m_nImplMethodKind = ExternalizableHelper.readInt(in);
        this.m_sImplClass = ExternalizableHelper.readSafeUTF(in);
        this.m_sImplMethodName = ExternalizableHelper.readSafeUTF(in);
        this.m_sImplMethodSignature = ExternalizableHelper.readSafeUTF(in);
        this.m_sInstantiatedMethodType = ExternalizableHelper.readSafeUTF(in);
        int cCapturedArgs = ExternalizableHelper.readInt(in);
        Object[] aoCapturedArgs = cCapturedArgs == 0 ? EMPTY_OBJECT_ARRAY : new Object[cCapturedArgs];
        for (int i = 0; i < cCapturedArgs; ++i) {
            aoCapturedArgs[i] = ExternalizableHelper.readObject(in);
        }
        this.m_aoCapturedArgs = aoCapturedArgs;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        Object[] aoCapturedArgs = this.m_aoCapturedArgs;
        int cCapturedArgs = aoCapturedArgs == null ? 0 : aoCapturedArgs.length;
        ExternalizableHelper.writeSafeUTF(out, this.m_sCapturingClass);
        ExternalizableHelper.writeSafeUTF(out, this.m_sFunctionalInterfaceClass);
        ExternalizableHelper.writeSafeUTF(out, this.m_sFunctionalInterfaceMethodName);
        ExternalizableHelper.writeSafeUTF(out, this.m_sFunctionalInterfaceMethodSignature);
        ExternalizableHelper.writeInt(out, this.m_nImplMethodKind);
        ExternalizableHelper.writeSafeUTF(out, this.m_sImplClass);
        ExternalizableHelper.writeSafeUTF(out, this.m_sImplMethodName);
        ExternalizableHelper.writeSafeUTF(out, this.m_sImplMethodSignature);
        ExternalizableHelper.writeSafeUTF(out, this.m_sInstantiatedMethodType);
        ExternalizableHelper.writeInt(out, cCapturedArgs);
        for (int i = 0; i < cCapturedArgs; ++i) {
            ExternalizableHelper.writeObject(out, this.m_aoCapturedArgs[i]);
        }
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_sCapturingClass = reader.readString(0);
        this.m_sFunctionalInterfaceClass = reader.readString(1);
        this.m_sFunctionalInterfaceMethodName = reader.readString(2);
        this.m_sFunctionalInterfaceMethodSignature = reader.readString(3);
        this.m_nImplMethodKind = reader.readInt(4);
        this.m_sImplClass = reader.readString(5);
        this.m_sImplMethodName = reader.readString(6);
        this.m_sImplMethodSignature = reader.readString(7);
        this.m_sInstantiatedMethodType = reader.readString(8);
        this.m_aoCapturedArgs = reader.readArray(9, Object[]::new);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeString(0, this.m_sCapturingClass);
        writer.writeString(1, this.m_sFunctionalInterfaceClass);
        writer.writeString(2, this.m_sFunctionalInterfaceMethodName);
        writer.writeString(3, this.m_sFunctionalInterfaceMethodSignature);
        writer.writeInt(4, this.m_nImplMethodKind);
        writer.writeString(5, this.m_sImplClass);
        writer.writeString(6, this.m_sImplMethodName);
        writer.writeString(7, this.m_sImplMethodSignature);
        writer.writeString(8, this.m_sInstantiatedMethodType);
        writer.writeObjectArray(9, this.m_aoCapturedArgs);
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (oThat == null || this.getClass() != oThat.getClass()) {
            return false;
        }
        StaticLambdaInfo info = (StaticLambdaInfo)oThat;
        return this.m_nImplMethodKind == info.m_nImplMethodKind && Base.equals(this.m_sCapturingClass, info.m_sCapturingClass) && Base.equals(this.m_sFunctionalInterfaceClass, info.m_sFunctionalInterfaceClass) && Base.equals(this.m_sFunctionalInterfaceMethodName, this.m_sFunctionalInterfaceMethodName) && Base.equals(this.m_sFunctionalInterfaceMethodSignature, this.m_sFunctionalInterfaceMethodSignature) && Base.equals(this.m_sImplClass, this.m_sImplClass) && Base.equals(this.m_sImplMethodName, this.m_sImplMethodName) && Base.equals(this.m_sImplMethodSignature, this.m_sImplMethodSignature) && Base.equals(this.m_sInstantiatedMethodType, this.m_sInstantiatedMethodType);
    }

    public int hashCode() {
        int nResult = HashHelper.hash(this.m_sCapturingClass.hashCode(), 31);
        nResult = HashHelper.hash(this.m_sFunctionalInterfaceClass.hashCode(), nResult);
        nResult = HashHelper.hash(this.m_sFunctionalInterfaceMethodName.hashCode(), nResult);
        nResult = HashHelper.hash(this.m_sFunctionalInterfaceMethodSignature.hashCode(), nResult);
        nResult = HashHelper.hash(this.m_sImplClass.hashCode(), nResult);
        nResult = HashHelper.hash(this.m_sImplMethodName.hashCode(), nResult);
        nResult = HashHelper.hash(this.m_sImplMethodSignature.hashCode(), nResult);
        nResult = HashHelper.hash(this.m_nImplMethodKind, nResult);
        nResult = HashHelper.hash(this.m_sInstantiatedMethodType.hashCode(), nResult);
        return nResult;
    }

    public String toString() {
        return "StaticLambdaInfo{capturingClass='" + this.m_sCapturingClass + '\'' + ", functionalInterfaceClass='" + this.m_sFunctionalInterfaceClass + '\'' + ", functionalInterfaceMethodName='" + this.m_sFunctionalInterfaceMethodName + '\'' + ", functionalInterfaceMethodSignature='" + this.m_sFunctionalInterfaceMethodSignature + '\'' + ", implClass='" + this.m_sImplClass + '\'' + ", implMethodName='" + this.m_sImplMethodName + '\'' + ", implMethodSignature='" + this.m_sImplMethodSignature + '\'' + ", implMethodKind=" + this.m_nImplMethodKind + ", instantiatedMethodType='" + this.m_sInstantiatedMethodType + '\'' + ", capturedArgs=" + Arrays.toString(this.m_aoCapturedArgs) + '}';
    }

    protected static Object createLambda(SerializedLambda serializedLambda) {
        Objects.requireNonNull(serializedLambda);
        try {
            Method methReadResolve = AccessController.doPrivileged(() -> {
                Method m = SerializedLambda.class.getDeclaredMethod("readResolve", new Class[0]);
                m.setAccessible(true);
                return m;
            });
            return methReadResolve.invoke((Object)serializedLambda, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception resolving static lambda " + serializedLambda, e);
        }
    }

    private static Object[] getCapturedArguments(SerializedLambda lambda) {
        Object[] args = new Object[lambda.getCapturedArgCount()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = lambda.getCapturedArg(i);
        }
        return args;
    }

    protected SerializedLambda toSerializedLambda(ClassLoader loader) {
        String sName = this.m_sCapturingClass.replace('/', '.');
        try {
            return new SerializedLambda(loader.loadClass(sName), this.m_sFunctionalInterfaceClass, this.m_sFunctionalInterfaceMethodName, this.m_sFunctionalInterfaceMethodSignature, this.m_nImplMethodKind, this.m_sImplClass, this.m_sImplMethodName, this.m_sImplMethodSignature, this.m_sInstantiatedMethodType, this.m_aoCapturedArgs);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to deserialize static lambda " + this.m_sImplClass + "$" + this.m_sImplMethodName + this.m_sImplMethodSignature + " due to missing context class " + sName + ".", e);
        }
    }
}

