/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardian;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.json.bind.annotation.JsonbProperty;

public class CacheProcessors {
    public static <K, V> InvocableMap.EntryProcessor<K, V, Void> nop() {
        return new Null();
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, V> get() {
        return new Get();
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, Optional<V>> getOrDefault() {
        return new GetOrDefault();
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, Void> put(V value, long cMillis) {
        return new Put(value, cMillis);
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, Void> putAll(Map<? extends K, ? extends V> map) {
        return new PutAll<K, V>(map);
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, V> putIfAbsent(V value) {
        return new PutIfAbsent(value);
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, V> remove() {
        return new Remove();
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, Void> removeBlind() {
        return new RemoveBlind();
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, Boolean> remove(Object value) {
        return new RemoveValue(value);
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, V> replace(V value) {
        return new Replace(value);
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, Boolean> replace(V oldValue, V newValue) {
        return new ReplaceValue(oldValue, newValue);
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, Void> replace(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        return entry -> {
            entry.setValue(function.apply((Object)entry.getKey(), (Object)entry.getValue()));
            return null;
        };
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, V> computeIfAbsent(Function<? super K, ? extends V> mappingFunction) {
        return entry -> {
            Object value = entry.getValue();
            if (value == null && (value = mappingFunction.apply((Object)entry.getKey())) != null) {
                entry.setValue(value);
            }
            return value;
        };
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, V> computeIfPresent(BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return entry -> {
            Object oldValue = entry.getValue();
            if (oldValue != null) {
                Object newValue = remappingFunction.apply((Object)entry.getKey(), (Object)oldValue);
                if (newValue == null) {
                    entry.remove(false);
                } else {
                    entry.setValue(newValue);
                    return newValue;
                }
            }
            return null;
        };
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, V> compute(BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return entry -> {
            Objects.requireNonNull(remappingFunction);
            Object oldValue = entry.getValue();
            Object newValue = remappingFunction.apply((Object)entry.getKey(), (Object)oldValue);
            if (newValue == null) {
                if (entry.isPresent()) {
                    entry.remove(false);
                }
                return null;
            }
            entry.setValue(newValue);
            return newValue;
        };
    }

    public static <K, V> InvocableMap.EntryProcessor<K, V, V> merge(V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return entry -> {
            Object valueNew;
            Objects.requireNonNull(remappingFunction);
            Objects.requireNonNull(value);
            Object valueOld = entry.getValue();
            Object object = valueNew = valueOld == null ? value : remappingFunction.apply((Object)valueOld, (Object)value);
            if (valueNew == null) {
                entry.remove(false);
            } else {
                entry.setValue(valueNew);
            }
            return valueNew;
        };
    }

    public static class ReplaceValue<K, V>
    extends BaseProcessor<K, V, Boolean> {
        @JsonbProperty(value="oldValue")
        protected V m_oldValue;
        @JsonbProperty(value="newValue")
        protected V m_newValue;

        public ReplaceValue() {
        }

        public ReplaceValue(V oldValue, V newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public Boolean process(InvocableMap.Entry<K, V> entry) {
            V valueCurrent = entry.getValue();
            if (entry.isPresent() && Objects.equals(valueCurrent, this.m_oldValue)) {
                entry.setValue(this.m_newValue);
                return true;
            }
            return false;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_oldValue = ReplaceValue.readObject(in);
            this.m_newValue = ReplaceValue.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ReplaceValue.writeObject(out, this.m_oldValue);
            ReplaceValue.writeObject(out, this.m_newValue);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_oldValue = in.readObject(0);
            this.m_newValue = in.readObject(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_oldValue);
            out.writeObject(1, this.m_newValue);
        }

        public V getOldValue() {
            return this.m_oldValue;
        }

        public V getNewValue() {
            return this.m_newValue;
        }
    }

    public static class Replace<K, V>
    extends BaseProcessor<K, V, V> {
        @JsonbProperty(value="value")
        protected V m_value;

        public Replace() {
        }

        public Replace(V value) {
            this.m_value = value;
        }

        @Override
        public V process(InvocableMap.Entry<K, V> entry) {
            return entry.getValue() != null || entry.isPresent() ? (V)entry.setValue(this.m_value) : null;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_value = Replace.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            Replace.writeObject(out, this.m_value);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_value = in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_value);
        }

        public V getValue() {
            return this.m_value;
        }
    }

    public static class RemoveValue<K, V>
    extends BaseProcessor<K, V, Boolean> {
        @JsonbProperty(value="value")
        protected Object m_oValue;

        public RemoveValue() {
        }

        public RemoveValue(Object oValue) {
            this.m_oValue = oValue;
        }

        @Override
        public Boolean process(InvocableMap.Entry<K, V> entry) {
            V valueCurrent = entry.getValue();
            if (Objects.equals(valueCurrent, this.m_oValue)) {
                entry.remove(false);
                return true;
            }
            return false;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_oValue = RemoveValue.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            RemoveValue.writeObject(out, this.m_oValue);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_oValue = in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_oValue);
        }

        public Object getValue() {
            return this.m_oValue;
        }
    }

    public static class RemoveBlind<K, V>
    extends BaseProcessor<K, V, Void> {
        @Override
        public Void process(InvocableMap.Entry<K, V> entry) {
            entry.remove(false);
            return null;
        }
    }

    public static class Remove<K, V>
    extends BaseProcessor<K, V, V> {
        @Override
        public V process(InvocableMap.Entry<K, V> entry) {
            V value = entry.getValue();
            entry.remove(false);
            return value;
        }
    }

    public static class PutIfAbsent<K, V>
    extends BaseProcessor<K, V, V> {
        @JsonbProperty(value="value")
        protected V m_value;

        public PutIfAbsent() {
        }

        public PutIfAbsent(V value) {
            this.m_value = value;
        }

        @Override
        public V process(InvocableMap.Entry<K, V> entry) {
            if (entry.getValue() != null) {
                return entry.getValue();
            }
            entry.setValue(this.m_value);
            return null;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_value = PutIfAbsent.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            PutIfAbsent.writeObject(out, this.m_value);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_value = in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_value);
        }

        public V getValue() {
            return this.m_value;
        }
    }

    public static class PutAll<K, V>
    extends BaseProcessor<K, V, Void> {
        @JsonbProperty(value="entries")
        protected Map<? extends K, ? extends V> m_map = new HashMap<K, V>();

        public PutAll() {
        }

        public PutAll(Map<? extends K, ? extends V> map) {
            this.m_map = map;
        }

        @Override
        public Void process(InvocableMap.Entry<K, V> entry) {
            entry.setValue(this.m_map.get(entry.getKey()), false);
            return null;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            PutAll.readMap(in, this.m_map, null);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            PutAll.writeMap(out, this.m_map);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            in.readMap(0, this.m_map);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeMap(0, this.m_map);
        }

        public Map<? extends K, ? extends V> getMap() {
            return this.m_map;
        }
    }

    public static class Put<K, V>
    extends BaseProcessor<K, V, Void> {
        @JsonbProperty(value="value")
        protected V m_value;
        @JsonbProperty(value="ttl")
        protected long m_cMillis;

        public Put() {
        }

        public Put(V value, long cMillis) {
            this.m_value = value;
            this.m_cMillis = cMillis;
        }

        @Override
        public Void process(InvocableMap.Entry<K, V> entry) {
            if (entry instanceof BinaryEntry) {
                ((BinaryEntry)entry).expire(this.m_cMillis);
            }
            entry.setValue(this.m_value);
            return null;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_value = Put.readObject(in);
            this.m_cMillis = Put.readLong(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            Put.writeObject(out, this.m_value);
            Put.writeLong(out, this.m_cMillis);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_value = in.readObject(0);
            this.m_cMillis = in.readLong(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_value);
            out.writeLong(1, this.m_cMillis);
        }

        public V getValue() {
            return this.m_value;
        }

        public long getMillis() {
            return this.m_cMillis;
        }
    }

    public static class GetOrDefault<K, V>
    extends BaseProcessor<K, V, Optional<V>> {
        @Override
        public Optional<V> process(InvocableMap.Entry<K, V> entry) {
            return Optional.ofNullable(entry.getValue());
        }
    }

    public static class Get<K, V>
    extends BaseProcessor<K, V, V> {
        @Override
        public V process(InvocableMap.Entry<K, V> entry) {
            return entry.getValue();
        }

        @Override
        public Map<K, V> processAll(Set<? extends InvocableMap.Entry<K, V>> setEntries) {
            LiteMap<K, V> mapResults = new LiteMap<K, V>();
            Guardian.GuardContext ctxGuard = GuardSupport.getThreadContext();
            long cMillis = ctxGuard == null ? 0L : ctxGuard.getTimeoutMillis();
            Iterator<InvocableMap.Entry<K, V>> iter = setEntries.iterator();
            while (iter.hasNext()) {
                InvocableMap.Entry<K, V> entry = iter.next();
                if (entry.isPresent()) {
                    mapResults.put(entry.getKey(), this.process(entry));
                }
                iter.remove();
                if (ctxGuard == null) continue;
                ctxGuard.heartbeat(cMillis);
            }
            return mapResults;
        }
    }

    public static class Null<K, V>
    extends BaseProcessor<K, V, Void> {
        @Override
        public Void process(InvocableMap.Entry<K, V> entry) {
            return null;
        }
    }

    static abstract class BaseProcessor<K, V, R>
    extends ExternalizableHelper
    implements InvocableMap.EntryProcessor<K, V, R>,
    ExternalizableLite,
    PortableObject {
        BaseProcessor() {
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }
    }
}

