/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Binary;
import java.io.IOException;

public final class DelegatingWriteBuffer
extends AbstractWriteBuffer {
    protected WriteBuffer m_buf;
    protected int m_ofStart;
    protected int m_cb;
    protected int m_cbMax;

    public DelegatingWriteBuffer(WriteBuffer buf, int of, int cb) {
        this.m_buf = buf;
        this.m_ofStart = of;
        this.m_cbMax = cb;
    }

    @Override
    public void write(int ofDest, byte b) {
        this.checkBounds(ofDest, 1);
        this.m_buf.write(this.m_ofStart + ofDest, b);
        this.updateLength(ofDest + 1);
    }

    @Override
    public void write(int ofDest, byte[] abSrc, int ofSrc, int cbSrc) {
        this.checkBounds(ofDest, cbSrc);
        this.m_buf.write(this.m_ofStart + ofDest, abSrc, ofSrc, cbSrc);
        this.updateLength(ofDest + cbSrc);
    }

    @Override
    public void write(int ofDest, ReadBuffer bufSrc, int ofSrc, int cbSrc) {
        this.checkBounds(ofDest, cbSrc);
        this.m_buf.write(this.m_ofStart + ofDest, bufSrc, ofSrc, cbSrc);
        this.updateLength(ofDest + cbSrc);
    }

    @Override
    public void write(int ofDest, InputStreaming stream) throws IOException {
        int cb = this.copyStream(ofDest, stream, this.m_cbMax - ofDest);
        this.updateLength(cb);
    }

    @Override
    public void write(int ofDest, InputStreaming stream, int cbSrc) throws IOException {
        this.checkBounds(ofDest, cbSrc);
        this.m_buf.write(this.m_ofStart + ofDest, stream, cbSrc);
        this.updateLength(ofDest + cbSrc);
    }

    @Override
    public int length() {
        return this.m_cb;
    }

    @Override
    public void retain(int of, int cb) {
        if (of < 0 || cb < 0 || of + cb > this.length()) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", length()=" + this.length());
        }
        if (cb == 0) {
            this.clear();
        } else {
            if (of > 0) {
                WriteBuffer buf = this.m_buf;
                int ofStart = this.m_ofStart;
                buf.write(ofStart, buf.getUnsafeReadBuffer(), ofStart + of, cb);
            }
            this.m_cb = cb;
        }
    }

    @Override
    public void clear() {
        this.m_cb = 0;
    }

    @Override
    public int getCapacity() {
        return Math.min(Math.max(0, this.m_buf.getCapacity() - this.m_ofStart), this.m_cbMax);
    }

    @Override
    public int getMaximumCapacity() {
        return this.m_cbMax;
    }

    @Override
    public WriteBuffer.BufferOutput getBufferOutput(int of) {
        return new DelegatingBufferOutput(of);
    }

    @Override
    public ReadBuffer getReadBuffer() {
        return this.toBinary();
    }

    @Override
    public ReadBuffer getUnsafeReadBuffer() {
        int cb = this.m_cb;
        return cb == 0 ? NO_BINARY : this.m_buf.getUnsafeReadBuffer().getReadBuffer(this.m_ofStart, cb);
    }

    @Override
    public byte[] toByteArray() {
        int cb = this.m_cb;
        return cb == 0 ? NO_BYTES : this.m_buf.getUnsafeReadBuffer().toByteArray(this.m_ofStart, cb);
    }

    @Override
    public Binary toBinary() {
        int cb = this.m_cb;
        return cb == 0 ? NO_BINARY : this.m_buf.getUnsafeReadBuffer().toBinary(this.m_ofStart, cb);
    }

    protected void checkBounds(int of, int cb) {
        if (of < 0 || cb < 0 || of + cb > this.m_cbMax) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", max=" + this.m_cbMax);
        }
    }

    protected void updateLength(int cb) {
        if (cb > this.m_cb) {
            this.m_cb = cb;
        }
    }

    @Override
    protected int copyStream(int ofDest, InputStreaming stream, int cbMax) throws IOException {
        WriteBuffer buf = this.m_buf;
        if (buf instanceof AbstractWriteBuffer) {
            AbstractWriteBuffer awbuf = (AbstractWriteBuffer)buf;
            return awbuf.copyStream(this.m_ofStart + ofDest, stream, cbMax);
        }
        return super.copyStream(ofDest, stream, cbMax);
    }

    public final class DelegatingBufferOutput
    extends AbstractWriteBuffer.AbstractBufferOutput {
        protected WriteBuffer.BufferOutput m_out;

        public DelegatingBufferOutput(int of) {
            super(DelegatingWriteBuffer.this);
            this.m_out = DelegatingWriteBuffer.this.m_buf.getBufferOutput();
            this.setOffset(of);
        }

        @Override
        public void write(int b) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, 1);
            this.m_out.write(b);
            this.moveOffset(1);
        }

        @Override
        public void write(byte[] ab, int of, int cb) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, cb);
            this.m_out.write(ab, of, cb);
            this.moveOffset(cb);
        }

        @Override
        public void writeBoolean(boolean f) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, 1);
            this.m_out.writeBoolean(f);
            this.moveOffset(1);
        }

        @Override
        public void writeByte(int b) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, 1);
            this.m_out.writeByte(b);
            this.moveOffset(1);
        }

        @Override
        public void writeShort(int n) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, 2);
            this.m_out.writeShort(n);
            this.moveOffset(2);
        }

        @Override
        public void writeChar(int ch) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, 2);
            this.m_out.writeChar(2);
            this.moveOffset(2);
        }

        @Override
        public void writeInt(int n) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, 4);
            this.m_out.writeInt(n);
            this.moveOffset(4);
        }

        @Override
        public void writeLong(long l) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, 8);
            this.m_out.writeLong(l);
            this.moveOffset(8);
        }

        @Override
        public void writeFloat(float fl) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, 4);
            this.m_out.writeFloat(fl);
            this.moveOffset(4);
        }

        @Override
        public void writeDouble(double dfl) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, 8);
            this.m_out.writeDouble(dfl);
            this.moveOffset(8);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            int cb = s.length();
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, cb);
            this.m_out.writeBytes(s);
            this.moveOffset(cb);
        }

        @Override
        public void writeChars(String s) throws IOException {
            int cb = s.length() * 2;
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, cb);
            this.m_out.writeChars(s);
            this.moveOffset(cb);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            int cbRemain;
            int cbMaxUtf = 2 + 3 * s.length();
            if (cbMaxUtf < (cbRemain = DelegatingWriteBuffer.this.m_cbMax - this.m_ofWrite)) {
                WriteBuffer.BufferOutput out = this.m_out;
                int ofBefore = out.getOffset();
                out.writeUTF(s);
                int ofAfter = out.getOffset();
                this.moveOffset(ofAfter - ofBefore);
            } else {
                super.writeUTF(s);
            }
        }

        @Override
        public void writeBuffer(ReadBuffer buf) throws IOException {
            int cb = buf.length();
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, cb);
            this.m_out.writeBuffer(buf);
            this.moveOffset(cb);
        }

        @Override
        public void writeBuffer(ReadBuffer buf, int of, int cb) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, cb);
            this.m_out.writeBuffer(buf, of, cb);
            this.moveOffset(cb);
        }

        @Override
        public void writeStream(InputStreaming stream) throws IOException {
            int cb;
            if (stream instanceof ReadBuffer.BufferInput) {
                cb = stream.available();
                DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, cb);
                this.m_out.writeStream(stream);
            } else {
                int of = this.m_ofWrite;
                cb = DelegatingWriteBuffer.this.copyStream(of, stream, DelegatingWriteBuffer.this.m_cbMax - of);
            }
            this.moveOffset(cb);
        }

        @Override
        public void writeStream(InputStreaming stream, int cb) throws IOException {
            DelegatingWriteBuffer.this.checkBounds(this.m_ofWrite, cb);
            this.m_out.writeStream(stream, cb);
            this.moveOffset(cb);
        }

        protected void moveOffset(int cb) {
            int of;
            this.m_ofWrite = of = this.m_ofWrite + cb;
            DelegatingWriteBuffer.this.updateLength(of);
        }
    }
}

