/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class FileHelper {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final int NOT_FOUND = -1;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    private static boolean isUnsafeChar(char ch) {
        return ch >= '\u0000' && ch <= ' ' || ch >= '!' && ch <= '\'' || ch == '*' || ch == '+' || ch == '.' || ch == '/' || ch == ':' || ch >= '<' && ch <= '@' || ch == '\\' || ch == '`' || ch >= '{' && ch <= '}';
    }

    public static String toFilename(String sName) {
        int cch;
        int REPLACEMENT = 45;
        int n = cch = sName == null ? 0 : sName.length();
        if (cch == 0) {
            return String.valueOf('-');
        }
        boolean fNew = false;
        char[] ach = new char[cch];
        for (int i = 0; i < cch; ++i) {
            int ch = sName.charAt(i);
            if (FileHelper.isUnsafeChar((char)ch)) {
                ch = 45;
                fNew = true;
            }
            ach[i] = ch;
        }
        return fNew ? new String(ach) : sName;
    }

    public static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static File ensureDir(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        return file.isDirectory() ? file : Files.createDirectories(file.toPath(), new FileAttribute[0]).toFile();
    }

    public static void validateDir(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        Path path = file.toPath();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("the specified path \"" + path + "\" is not a directory");
        }
    }

    public static void copyDir(File fileDirFrom, File fileDirTo) throws IOException {
        FileHelper.validateDir(fileDirFrom);
        if (fileDirTo == null) {
            throw new IllegalArgumentException("null file");
        }
        File fileParent = fileDirTo.getParentFile();
        if (fileParent != null) {
            FileHelper.ensureDir(fileParent);
        }
        Path pathFrom = fileDirFrom.toPath();
        Path pathTo = fileDirTo.toPath();
        Files.walkFileTree(pathFrom, new CopyDirVisitor(pathFrom, pathTo));
    }

    public static void deleteDir(File fileDir) throws IOException {
        Path pathDir = fileDir.toPath();
        if (Files.exists(pathDir, new LinkOption[0])) {
            FileHelper.validateDir(fileDir);
            Files.walkFileTree(pathDir, new DeleteDirVisitor());
        }
    }

    public static void deleteDirSilent(File fileDir) {
        try {
            FileHelper.deleteDir(fileDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void moveDir(File fileDirFrom, File fileDirTo) throws IOException {
        FileHelper.validateDir(fileDirFrom);
        if (fileDirTo == null) {
            throw new IllegalArgumentException("null file");
        }
        File fileParent = fileDirTo.getParentFile();
        if (fileParent != null) {
            FileHelper.ensureDir(fileParent);
        }
        Path pathFrom = fileDirFrom.toPath();
        Path pathTo = fileDirTo.toPath();
        try {
            Files.move(pathFrom, pathTo, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.walkFileTree(pathFrom, new CopyDirVisitor(pathFrom, pathTo));
            Files.walkFileTree(pathFrom, new DeleteDirVisitor());
        }
    }

    public static File createTempDir() throws IOException {
        File file = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        file.deleteOnExit();
        return file;
    }

    public static long sizeDir(File fileDir) {
        Path pathDir;
        Path path = pathDir = fileDir == null ? null : fileDir.toPath();
        if (pathDir == null || !Files.isDirectory(pathDir, new LinkOption[0])) {
            return 0L;
        }
        SizeDirVisitor visitor = new SizeDirVisitor();
        try {
            Files.walkFileTree(pathDir, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return visitor.getSize();
    }

    public static void copyFile(File fileFrom, File fileTo) throws IOException {
        if (fileFrom == null || fileTo == null) {
            throw new IllegalArgumentException("null file");
        }
        File fileParent = fileTo.getParentFile();
        if (fileParent != null) {
            FileHelper.ensureDir(fileParent);
        }
        Files.copy(fileFrom.toPath(), fileTo.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
    }

    public static void moveFile(File fileFrom, File fileTo) throws IOException {
        if (fileFrom == null || fileTo == null) {
            throw new IllegalArgumentException("null file");
        }
        File fileParent = fileTo.getParentFile();
        if (fileParent != null) {
            FileHelper.ensureDir(fileParent);
        }
        Files.move(fileFrom.toPath(), fileTo.toPath(), new CopyOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileLock lockFile(File file) {
        FileLock lock = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            lock = out.getChannel().tryLock();
        }
        catch (Throwable throwable) {
        }
        finally {
            if (lock == null && out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lock;
    }

    public static void unlockFile(FileLock lock) {
        try {
            lock.release();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            lock.channel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    public static String separatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    public static int getPrefixLength(String filename) {
        if (filename == null) {
            return -1;
        }
        int len = filename.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = filename.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return FileHelper.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = filename.indexOf(47, 1);
            int posWin = filename.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = filename.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !FileHelper.isSeparator(filename.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FileHelper.isSeparator(ch0) && FileHelper.isSeparator(ch1)) {
            int posUnix = filename.indexOf(47, 2);
            int posWin = filename.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        return FileHelper.isSeparator(ch0) ? 1 : 0;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileHelper.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getPathNoEndSeparator(String filename) {
        return FileHelper.doGetPath(filename, 0);
    }

    static String doGetPath(String filename, int separatorAdd) {
        if (filename == null) {
            return null;
        }
        int prefix = FileHelper.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        int index = FileHelper.indexOfLastSeparator(filename);
        int endIndex = index + separatorAdd;
        if (prefix >= filename.length() || index < 0 || prefix >= endIndex) {
            return "";
        }
        return FileHelper.filterNullBytes(filename.substring(prefix, endIndex));
    }

    public static String getName(String filename) {
        if (filename == null) {
            return null;
        }
        String cleanFileName = FileHelper.filterNullBytes(filename);
        int index = FileHelper.indexOfLastSeparator(cleanFileName);
        return cleanFileName.substring(index + 1);
    }

    static String filterNullBytes(String path) {
        return path.contains("\u0000") ? path.replace("\u0000", "") : path;
    }

    public static String getBaseName(String filename) {
        return FileHelper.removeExtension(FileHelper.getName(filename));
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileHelper.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        String cleanFileName = FileHelper.filterNullBytes(filename);
        int index = FileHelper.indexOfExtension(cleanFileName);
        if (index == -1) {
            return cleanFileName;
        }
        return cleanFileName.substring(0, index);
    }

    private static class SizeDirVisitor
    extends SimpleFileVisitor<Path> {
        private long m_cb;

        private SizeDirVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.m_cb += Files.size(file);
            return FileVisitResult.CONTINUE;
        }

        public long getSize() {
            return this.m_cb;
        }
    }

    private static class DeleteDirVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteDirVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            super.visitFile(file, attrs);
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
            super.postVisitDirectory(dir, e);
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path f_pathFrom;
        private final Path f_pathTo;
        private final CopyOption[] f_opts;

        public CopyDirVisitor(Path pathFrom, Path pathTo) {
            this(pathFrom, pathTo, StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS);
        }

        public CopyDirVisitor(Path pathFrom, Path pathTo, CopyOption ... opts) {
            this.f_pathFrom = pathFrom;
            this.f_pathTo = pathTo;
            this.f_opts = opts;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path pathTo = this.f_pathTo.resolve(this.f_pathFrom.relativize(dir));
            if (!Files.exists(pathTo, new LinkOption[0])) {
                Files.createDirectory(pathTo, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.f_pathTo.resolve(this.f_pathFrom.relativize(file)), this.f_opts);
            return FileVisitResult.CONTINUE;
        }
    }
}

