/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.OutputStreaming;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class WrapperDataOutputStream
extends OutputStream
implements DataOutput,
OutputStreaming {
    private DataOutput m_out;
    private long m_cbWritten;

    public WrapperDataOutputStream(DataOutput out) {
        this.m_out = out;
    }

    public DataOutput getDataOutput() {
        return this.m_out;
    }

    public long getBytesWritten() {
        return this.m_cbWritten;
    }

    protected void incBytesWritten(int cb) {
        long cbWritten = this.m_cbWritten;
        long cbTotal = cbWritten + (long)cb;
        if (cbTotal >= 0L) {
            this.m_cbWritten = cbTotal;
        } else if (cbWritten != Long.MAX_VALUE) {
            this.m_cbWritten = Long.MAX_VALUE;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.m_out.write(b);
        this.incBytesWritten(1);
    }

    @Override
    public void write(byte[] ab) throws IOException {
        this.m_out.write(ab);
        this.incBytesWritten(ab.length);
    }

    @Override
    public void write(byte[] ab, int of, int cb) throws IOException {
        this.m_out.write(ab, of, cb);
        this.incBytesWritten(cb);
    }

    @Override
    public void writeBoolean(boolean f) throws IOException {
        this.m_out.writeBoolean(f);
        this.incBytesWritten(1);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.m_out.writeByte(b);
        this.incBytesWritten(1);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.m_out.writeShort(n);
        this.incBytesWritten(2);
    }

    @Override
    public void writeChar(int ch) throws IOException {
        this.m_out.writeChar(ch);
        this.incBytesWritten(2);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.m_out.writeInt(n);
        this.incBytesWritten(4);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.m_out.writeLong(l);
        this.incBytesWritten(8);
    }

    @Override
    public void writeFloat(float fl) throws IOException {
        this.m_out.writeFloat(fl);
        this.incBytesWritten(4);
    }

    @Override
    public void writeDouble(double dfl) throws IOException {
        this.m_out.writeDouble(dfl);
        this.incBytesWritten(8);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.m_out.writeBytes(s);
        this.incBytesWritten(s.length());
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.m_out.writeChars(s);
        this.incBytesWritten(s.length() * 2);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.m_out.writeUTF(s);
    }

    @Override
    public void flush() throws IOException {
        DataOutput out = this.m_out;
        if (out instanceof OutputStreaming) {
            ((OutputStreaming)((Object)out)).flush();
        } else if (out instanceof OutputStream) {
            ((OutputStream)((Object)out)).flush();
        } else if (out instanceof ObjectOutput) {
            ((ObjectOutput)out).flush();
        }
    }

    @Override
    public void close() throws IOException {
        DataOutput out = this.m_out;
        if (out instanceof OutputStreaming) {
            ((OutputStreaming)((Object)out)).close();
        } else if (out instanceof OutputStream) {
            ((OutputStream)((Object)out)).close();
        } else if (out instanceof ObjectOutput) {
            ((ObjectOutput)out).close();
        }
    }
}

