/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.nio.AbstractBufferManager;
import com.tangosol.util.Base;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MappedBufferManager
extends AbstractBufferManager {
    public static final int DEFAULT_MIN_SIZE = 16384;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    private File m_fileTemp;
    private RandomAccessFile m_hfile;

    public MappedBufferManager() {
        this(16384, Integer.MAX_VALUE, null);
    }

    public MappedBufferManager(int cbInitial, int cbMaximum, File file) {
        super(cbInitial, cbMaximum);
        this.configureFile(file);
        this.allocateBuffer();
    }

    protected void configureFile(File file) {
        try {
            boolean fTemp = false;
            if (file == null || file.isDirectory()) {
                file = File.createTempFile("coherence", null, file);
                fTemp = true;
            } else if (!file.exists()) {
                file.createNewFile();
                fTemp = true;
            }
            RandomAccessFile hfile = new RandomAccessFile(file, "rw");
            this.setFile(hfile);
            if (fTemp) {
                file.deleteOnExit();
                this.m_fileTemp = file;
            }
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected RandomAccessFile getFile() {
        return this.m_hfile;
    }

    protected void setFile(RandomAccessFile file) {
        this.m_hfile = file;
    }

    @Override
    protected void allocateBuffer() {
        block4: {
            try {
                int cbNew;
                RandomAccessFile hfile;
                block5: {
                    hfile = this.getFile();
                    int cbOld = (int)hfile.length();
                    cbNew = this.getCapacity();
                    if (cbNew == cbOld) break block4;
                    this.setBuffer(null);
                    System.gc();
                    Thread.yield();
                    try {
                        hfile.setLength(cbNew);
                    }
                    catch (IOException e) {
                        if (cbNew <= cbOld) break block5;
                        throw e;
                    }
                }
                this.setBuffer(hfile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, cbNew));
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    public void close() {
        try {
            File fileTemp;
            RandomAccessFile hfile = this.m_hfile;
            if (hfile != null) {
                try {
                    ByteBuffer buffer = this.getBuffer();
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                    getCleanerMethod.setAccessible(true);
                    Object cleaner = getCleanerMethod.invoke((Object)buffer, new Object[0]);
                    Method cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                    cleanMethod.invoke(cleaner, new Object[0]);
                }
                catch (Throwable buffer) {
                    // empty catch block
                }
                hfile.close();
            }
            if ((fileTemp = this.m_fileTemp) != null) {
                if (fileTemp.delete()) {
                    this.m_fileTemp = null;
                } else {
                    MappedBufferManager.log("MappedBufferManager: failed to remove " + fileTemp);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_hfile = null;
    }

    protected void finalize() {
        this.close();
    }
}

