/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.util.OptionalLong;

public class OptionalLongSerializer
implements PofSerializer<OptionalLong> {
    @Override
    public void serialize(PofWriter out, OptionalLong value) throws IOException {
        boolean fPresent = value.isPresent();
        out.writeBoolean(0, fPresent);
        if (fPresent) {
            out.writeLong(1, value.getAsLong());
        }
        out.writeRemainder(null);
    }

    @Override
    public OptionalLong deserialize(PofReader in) throws IOException {
        boolean fPresent = in.readBoolean(0);
        OptionalLong value = fPresent ? OptionalLong.of(in.readLong(1)) : OptionalLong.empty();
        in.readRemainder();
        return value;
    }
}

