/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.Evolvable;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Binary;
import java.io.IOException;

public class PortableObjectSerializer
extends PofHelper
implements PofSerializer {
    protected final int m_nTypeId;

    public PortableObjectSerializer(int nTypeId) {
        PortableObjectSerializer.azzert(nTypeId >= 0, "user type identifier cannot be negative");
        this.m_nTypeId = nTypeId;
    }

    public void serialize(PofWriter out, Object o) throws IOException {
        PortableObject portable;
        try {
            portable = (PortableObject)o;
        }
        catch (ClassCastException e) {
            String sClass = null;
            try {
                sClass = out.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String sActual = null;
            try {
                sActual = o.getClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("An exception occurred writing a PortableObject user type to a POF stream: type-id=" + this.m_nTypeId + (sClass == null ? "" : ", class-name=" + sClass) + (sActual == null ? "" : ", actual class-name=" + sActual) + ", exception=" + e);
        }
        boolean fEvolvable = portable instanceof Evolvable;
        Evolvable evolvable = null;
        if (fEvolvable) {
            evolvable = (Evolvable)((Object)portable);
            out.setVersionId(Math.max(evolvable.getDataVersion(), evolvable.getImplVersion()));
        }
        portable.writeExternal(out);
        Binary binRemainder = null;
        if (fEvolvable) {
            binRemainder = evolvable.getFutureData();
        }
        out.writeRemainder(binRemainder);
    }

    public Object deserialize(PofReader in) throws IOException {
        PortableObject portable;
        try {
            portable = (PortableObject)in.getPofContext().getClass(this.m_nTypeId).newInstance();
            in.registerIdentity(portable);
        }
        catch (Exception e) {
            String sClass = null;
            try {
                sClass = in.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("An exception occurred instantiating a PortableObject user type from a POF stream: type-id=" + this.m_nTypeId + (sClass == null ? "" : ", class-name=" + sClass) + ", exception=\n" + e);
        }
        this.initialize(portable, in);
        return portable;
    }

    public void initialize(PortableObject portable, PofReader in) throws IOException {
        boolean fEvolvable = portable instanceof Evolvable;
        Evolvable evolvable = null;
        if (fEvolvable) {
            evolvable = (Evolvable)((Object)portable);
            evolvable.setDataVersion(in.getVersionId());
        }
        portable.readExternal(in);
        Binary binRemainder = in.readRemainder();
        if (fEvolvable) {
            evolvable.setFutureData(binRemainder);
        }
    }
}

