/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.io.Evolvable;
import com.tangosol.io.pof.EvolvableHolder;
import com.tangosol.io.pof.EvolvableObject;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class PortableTypeSerializer<T>
implements PofSerializer<T> {
    protected final int m_nTypeId;

    public PortableTypeSerializer(int nTypeId, Class<T> clazz) {
        Base.azzert(nTypeId >= 0, "user type identifier cannot be negative");
        if (!PortableObject.class.isAssignableFrom(clazz)) {
            Logger.err("Class [" + clazz + "] does not implement a PortableObject interface");
        }
        this.m_nTypeId = nTypeId;
    }

    @Override
    public void serialize(PofWriter writer, T value) throws IOException {
        if (!(value instanceof PortableObject)) {
            throw new IOException("Class [" + value.getClass() + "] does not implement a PortableObject interface");
        }
        PortableObject po = (PortableObject)value;
        boolean fEvolvable = value instanceof EvolvableObject;
        EvolvableObject et = fEvolvable ? (EvolvableObject)value : null;
        try {
            PofContext ctx = writer.getPofContext();
            SortedSet<Integer> typeIds = this.getTypeIds(value, ctx);
            Iterator iterator = typeIds.iterator();
            while (iterator.hasNext()) {
                Class<?> cls;
                int typeId = (Integer)iterator.next();
                Evolvable e = null;
                if (fEvolvable) {
                    e = et.getEvolvable(typeId);
                }
                PofWriter nestedWriter = writer.createNestedPofWriter(typeId, typeId);
                if (fEvolvable) {
                    nestedWriter.setVersionId(Math.max(e.getDataVersion(), e.getImplVersion()));
                }
                if ((cls = this.getClassForTypeId(ctx, typeId)) != null) {
                    po.writeExternal(nestedWriter);
                }
                nestedWriter.writeRemainder(fEvolvable ? e.getFutureData() : null);
            }
            writer.writeRemainder(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            String sClass = null;
            try {
                sClass = writer.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String sActual = null;
            try {
                sActual = value.getClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("An exception occurred writing a PortableObject user type to a POF stream: type-id=" + this.m_nTypeId + (sClass == null ? "" : ", class-name=" + sClass) + (sActual == null ? "" : ", actual class-name=" + sActual) + ", exception=" + e, e);
        }
    }

    @Override
    public T deserialize(PofReader reader) throws IOException {
        try {
            PortableObject po = (PortableObject)this.getClassForTypeId(reader.getPofContext(), this.m_nTypeId).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            boolean fEvolvable = po instanceof EvolvableObject;
            EvolvableObject et = fEvolvable ? (EvolvableObject)((Object)po) : null;
            PofBufferReader.UserTypeReader userTypeReader = (PofBufferReader.UserTypeReader)reader;
            int typeId = userTypeReader.getNextPropertyIndex();
            while (typeId > 0) {
                Evolvable e = null;
                PofReader nestedReader = userTypeReader.createNestedPofReader(typeId);
                if (fEvolvable) {
                    e = et.getEvolvable(typeId);
                    e.setDataVersion(nestedReader.getVersionId());
                }
                po.readExternal(nestedReader);
                Binary binRemainder = nestedReader.readRemainder();
                if (fEvolvable) {
                    e.setFutureData(binRemainder);
                }
                typeId = userTypeReader.getNextPropertyIndex();
            }
            reader.readRemainder();
            return (T)po;
        }
        catch (Exception e) {
            e.printStackTrace();
            String sClass = null;
            try {
                sClass = reader.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("An exception occurred instantiating a PortableObject user type from a POF stream: type-id=" + this.m_nTypeId + (sClass == null ? "" : ", class-name=" + sClass) + ", exception=\n" + e, e);
        }
    }

    private SortedSet<Integer> getTypeIds(Object o, PofContext pofContext) {
        EvolvableHolder evolvableHolder;
        TreeSet<Integer> typeIds = new TreeSet<Integer>();
        Class<?> clazz = o.getClass();
        while (pofContext.isUserType(clazz)) {
            typeIds.add(pofContext.getUserTypeIdentifier(clazz));
            clazz = clazz.getSuperclass();
        }
        if (o instanceof EvolvableObject && !(evolvableHolder = ((EvolvableObject)o).getEvolvableHolder()).isEmpty()) {
            typeIds.addAll(evolvableHolder.getTypeIds());
        }
        return typeIds;
    }

    protected Class<?> getClassForTypeId(PofContext ctx, int nTypeId) {
        try {
            return ctx.getClass(nTypeId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

