/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect;

import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.reflect.ComplexPofValue;
import com.tangosol.io.pof.reflect.PofReflectionHelper;
import com.tangosol.io.pof.reflect.PofValue;
import com.tangosol.io.pof.reflect.SimplePofValue;
import com.tangosol.util.Binary;
import java.io.IOException;

public class PofSparseArray
extends ComplexPofValue {
    public PofSparseArray(PofValue valueParent, ReadBuffer bufValue, PofContext ctx, int of, int nType, int ofChildren) {
        super(valueParent, bufValue, ctx, of, nType, ofChildren);
    }

    @Override
    protected PofValue findChildInternal(int nIndex, int ofStart, int iStart) {
        ReadBuffer bufValue = this.getValueBuffer();
        ReadBuffer.BufferInput in = bufValue.getBufferInput();
        in.setOffset(ofStart);
        try {
            int ofLastIndex = ofStart;
            int iProp = in.readPackedInt();
            while (iProp < nIndex && iProp >= 0) {
                this.skipChild(in);
                ofLastIndex = in.getOffset();
                iProp = in.readPackedInt();
            }
            if (iProp == nIndex) {
                int of = in.getOffset();
                this.skipChild(in);
                int cb = in.getOffset() - of;
                return this.extractChild(bufValue, of, cb);
            }
            return this.instantiateNilValue(ofLastIndex, nIndex);
        }
        catch (IOException e) {
            throw PofSparseArray.ensureRuntimeException(e);
        }
    }

    protected NilPofValue instantiateNilValue(int of, int nIndex) {
        return new NilPofValue((PofValue)this, this.getPofContext(), this.getOffset() + of, -65, nIndex);
    }

    protected static class NilPofValue
    extends SimplePofValue {
        private int m_nIndex;

        public NilPofValue(PofValue valueParent, PofContext ctx, int of, int nType, int nIndex) {
            super(valueParent, Binary.NO_BINARY, ctx, of, nType);
            this.m_oValue = null;
            this.m_nIndex = nIndex;
        }

        @Override
        public Object getValue(int nType) {
            Object oValue = this.m_oValue;
            if (oValue == null) {
                switch (nType) {
                    case -1: {
                        return (short)0;
                    }
                    case -2: {
                        return 0;
                    }
                    case -3: {
                        return 0L;
                    }
                    case -5: {
                        return Float.valueOf(0.0f);
                    }
                    case -6: {
                        return 0.0;
                    }
                    case -11: {
                        return Boolean.FALSE;
                    }
                    case -12: {
                        return (byte)0;
                    }
                    case -14: {
                        return new Character('\u0000');
                    }
                }
                return null;
            }
            return PofReflectionHelper.ensureType(oValue, nType, this.getPofContext());
        }

        @Override
        public void setValue(Object oValue) {
            super.setValue(oValue);
            if (oValue != null) {
                this.m_nType = PofHelper.getPofTypeId(oValue.getClass(), this.getPofContext());
            }
        }

        @Override
        public ReadBuffer getSerializedValue() {
            try {
                ReadBuffer bufValue = super.getSerializedValue();
                ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(5 + bufValue.length());
                WriteBuffer.BufferOutput out = buf.getBufferOutput();
                out.writePackedInt(this.m_nIndex);
                out.writeBuffer(bufValue);
                return buf.getReadBuffer();
            }
            catch (IOException e) {
                throw NilPofValue.ensureRuntimeException(e);
            }
        }
    }
}

