/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect.internal;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.io.pof.reflect.Codec;
import com.tangosol.io.pof.reflect.internal.ClassMetadata;
import com.tangosol.io.pof.reflect.internal.InvocationStrategy;
import com.tangosol.io.pof.reflect.internal.TypeMetadata;
import com.tangosol.io.pof.reflect.internal.Visitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ClassMetadataBuilder<T>
implements Visitor.Recipient<ClassMetadataBuilder<T>> {
    private ClassMetadata<T> m_cmd = new ClassMetadata();
    private ClassMetadata.ClassKey m_key = this.m_cmd.new ClassMetadata.ClassKey();

    public ClassMetadataBuilder() {
        this.m_cmd.setKey(this.m_key);
    }

    public ClassMetadataBuilder<T> setClass(Class<T> clz) {
        this.m_cmd.setClass(clz);
        return this;
    }

    public ClassMetadataBuilder<T> addAttribute(TypeMetadata.AttributeMetadata attribute) {
        this.m_cmd.addAttribute(attribute);
        return this;
    }

    public ClassAttributeBuilder newAttribute() {
        return new ClassAttributeBuilder();
    }

    public ClassMetadata<T> build() {
        ClassMetadata cmd = this.m_cmd;
        ClassMetadata.ClassKey key = (ClassMetadata.ClassKey)cmd.getKey();
        ArrayList listNonSorted = new ArrayList();
        HashSet<Integer> setReserved = new HashSet<Integer>();
        Iterator<TypeMetadata.AttributeMetadata<T>> iterAttr = cmd.getAttributes();
        while (iterAttr.hasNext()) {
            int iProp;
            ClassMetadata.ClassAttribute attr = (ClassMetadata.ClassAttribute)iterAttr.next();
            if (attr.getIndex() < 0) continue;
            int iAttr = iProp = attr.getIndex();
            while (setReserved.contains(iProp)) {
                ++iProp;
            }
            if (iProp != iAttr) {
                int nProp = iProp;
                Logger.fine(() -> String.format("The requested index %d on a PortableProperty annotation for [typeId=%d, version=%d, property-name=%s] is already allocated to an existing PortableProperty. Allocated index %d instead.", iAttr, key.getTypeId(), key.getVersionId(), attr.getName(), nProp));
                attr.setIndex(iProp);
            }
            setReserved.add(iProp);
        }
        int i = 0;
        Iterator<TypeMetadata.AttributeMetadata<T>> attributes = cmd.getAttributes();
        while (attributes.hasNext()) {
            ClassMetadata.ClassAttribute attr = (ClassMetadata.ClassAttribute)attributes.next();
            if (attr.getIndex() < 0) {
                while (setReserved.contains(i)) {
                    ++i;
                }
                attr.setIndex(i);
            }
            listNonSorted.add(attr);
            ++i;
        }
        cmd.setAttributes(listNonSorted);
        key.setHash(cmd.hashCode());
        this.m_cmd = new ClassMetadata();
        this.m_key = this.m_cmd.new ClassMetadata.ClassKey();
        this.m_cmd.setKey(this.m_key);
        return cmd;
    }

    public TypeMetadata<T> getTypeMetadata() {
        return this.m_cmd;
    }

    public ClassMetadataBuilder<T> setTypeId(int nTypeId) {
        this.m_key.setTypeId(nTypeId);
        return this;
    }

    public ClassMetadataBuilder<T> setVersionId(int nVersionId) {
        this.m_key.setVersion(nVersionId);
        return this;
    }

    public ClassMetadataBuilder<T> setHash(int nHash) {
        this.m_key.setHash(nHash);
        return this;
    }

    @Override
    public <C> void accept(Visitor<ClassMetadataBuilder<T>> visitor, Class<C> clz) {
        ArrayList<Class<C>> listHierarchy = new ArrayList<Class<C>>();
        for (Class<C> clzRecipient = clz; clzRecipient != null && !Object.class.equals(clzRecipient); clzRecipient = clzRecipient.getSuperclass()) {
            listHierarchy.add(clzRecipient);
        }
        for (int i = listHierarchy.size() - 1; i >= 0; --i) {
            visitor.visit(this, (Class)listHierarchy.get(i));
        }
    }

    public class ClassAttributeBuilder {
        private ClassMetadata.ClassAttribute m_attribute;

        public ClassAttributeBuilder() {
            this.m_attribute = ClassMetadataBuilder.this.m_cmd.new ClassMetadata.ClassAttribute();
        }

        public ClassAttributeBuilder setName(String sName) {
            this.m_attribute.setName(sName);
            return this;
        }

        public ClassAttributeBuilder setVersionId(int nVersionId) {
            this.m_attribute.setVersionId(nVersionId);
            return this;
        }

        public ClassAttributeBuilder setIndex(int nIndex) {
            this.m_attribute.setIndex(nIndex);
            return this;
        }

        public ClassAttributeBuilder setCodec(Codec codec) {
            this.m_attribute.setCodec(codec);
            return this;
        }

        public ClassAttributeBuilder setInvocationStrategy(InvocationStrategy<T, Object> strategy) {
            this.m_attribute.setInvocationStrategy(strategy);
            return this;
        }

        public ClassMetadata.ClassAttribute build() {
            ClassMetadata.ClassAttribute attribute = this.m_attribute;
            this.m_attribute = ClassMetadataBuilder.this.m_cmd.new ClassMetadata.ClassAttribute();
            return attribute;
        }
    }
}

