/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Disposable;
import com.tangosol.net.Action;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.Member;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.management.Registry;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Controllable;
import com.tangosol.util.ResourceRegistry;
import java.util.Enumeration;
import java.util.Set;

public interface Cluster
extends Controllable {
    public Enumeration<String> getServiceNames();

    public ServiceInfo getServiceInfo(String var1);

    public Service getService(String var1);

    public Service ensureService(String var1, String var2);

    public void suspendService(String var1);

    public void resumeService(String var1);

    public Set<Member> getMemberSet();

    public Member getLocalMember();

    public long getTimeMillis();

    public Member getOldestMember();

    public Registry getManagement();

    public void setManagement(Registry var1);

    public String getClusterName();

    @Deprecated
    public Disposable getResource(String var1);

    @Deprecated
    public void registerResource(String var1, Disposable var2);

    @Deprecated
    public Disposable unregisterResource(String var1);

    public ResourceRegistry getResourceRegistry();

    public ClusterDependencies getDependencies();

    public void setDependencies(ClusterDependencies var1);

    default public String getServiceBanner() {
        Cluster cluster;
        try {
            cluster = (Cluster)ClassHelper.invoke(this, "getCluster", null);
        }
        catch (Exception e) {
            cluster = this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\nServices\n  (\n  ");
        if (cluster != null) {
            Enumeration<String> e = cluster.getServiceNames();
            while (e.hasMoreElements()) {
                Service service = cluster.getService(e.nextElement());
                if (service == null) continue;
                sb.append(service).append("\n  ");
            }
        }
        sb.append(")\n");
        return sb.toString();
    }

    public static interface MemberTimeoutAction
    extends Action {
        public Set<Member> getTimedOutMemberSet();

        public Set<Member> getResponsiveMemberSet();

        public Set<Member> getAnnouncingMemberSet();

        public long getIncidentStartTime();
    }
}

