/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.internal.net.ScopedUriScopeResolver;
import com.tangosol.internal.net.SystemSessionConfiguration;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.CoherenceConfiguration;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultCacheServer;
import com.tangosol.net.ScopedCacheFactoryBuilder;
import com.tangosol.net.Session;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.SessionProvider;
import com.tangosol.net.events.CoherenceDispatcher;
import com.tangosol.net.events.CoherenceLifecycleEvent;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.internal.CoherenceEventDispatcher;
import com.tangosol.net.events.internal.Registry;
import com.tangosol.util.Base;
import com.tangosol.util.CopyOnWriteMap;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SimpleResourceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Coherence
implements AutoCloseable {
    public static final String SYS_CCF_URI = "coherence-system-config.xml";
    public static final String SYSTEM_SCOPE = "$SYS";
    public static final String SYSTEM_SESSION = "$SYS";
    public static final String DEFAULT_SCOPE = "";
    public static final String DEFAULT_NAME = "";
    private static volatile boolean s_fInitialized = false;
    private static final CopyOnWriteMap<String, Coherence> s_mapInstance = new CopyOnWriteMap(LinkedHashMap.class);
    private static Optional<Session> s_sessionSystem;
    private static DefaultCacheServer s_serverSystem;
    private final String f_sName;
    private final ResourceRegistry f_registry;
    private final CoherenceEventDispatcher f_dispatcher;
    private final CoherenceConfiguration f_config;
    private final Map<String, PriorityHolder> f_mapServer = new HashMap<String, PriorityHolder>();
    private final Map<String, Session> f_mapSession = new CopyOnWriteMap<String, Session>(new HashMap());
    private volatile boolean m_fStarted = false;
    private volatile boolean m_fClosed = false;
    private final CompletableFuture<Void> f_futureStarted = new CompletableFuture();
    private final CompletableFuture<Void> f_futureClosed = new CompletableFuture();
    private final Mode f_mode;

    private Coherence(CoherenceConfiguration config, Mode mode) {
        this.f_config = Objects.requireNonNull(config);
        this.f_mode = mode;
        this.f_sName = config.getName();
        this.f_registry = new SimpleResourceRegistry();
        this.f_dispatcher = new CoherenceEventDispatcher(this);
        Registry eventRegistry = new Registry();
        this.f_registry.registerResource(InterceptorRegistry.class, eventRegistry);
        this.f_registry.registerResource(EventDispatcherRegistry.class, eventRegistry);
        eventRegistry.registerEventDispatcher(this.f_dispatcher);
        for (EventInterceptor<?> interceptor : this.f_config.getInterceptors()) {
            eventRegistry.registerEventInterceptor(interceptor);
        }
        for (LifecycleListener listener : ServiceLoader.load(LifecycleListener.class)) {
            eventRegistry.registerEventInterceptor(listener);
        }
    }

    public static Coherence clusterMember() {
        return Coherence.clusterMemberBuilder(CoherenceConfiguration.create()).build();
    }

    public static Coherence clusterMember(CoherenceConfiguration config) {
        return Coherence.clusterMemberBuilder(config).build();
    }

    public static Coherence client() {
        return Coherence.clientBuilder(CoherenceConfiguration.create()).build();
    }

    public static Coherence client(CoherenceConfiguration config) {
        return Coherence.clientBuilder(config).build();
    }

    public static Builder clusterMemberBuilder(CoherenceConfiguration config) {
        return new Builder(config, Mode.ClusterMember);
    }

    public static Builder clientBuilder(CoherenceConfiguration config) {
        return new Builder(config, Mode.Client);
    }

    public static Collection<Coherence> getInstances() {
        return Collections.unmodifiableCollection(s_mapInstance.values());
    }

    public static Coherence getInstance(String sName) {
        return sName == null ? null : s_mapInstance.get(sName);
    }

    public static Coherence getInstance() {
        Coherence coherence = s_mapInstance.get("");
        if (coherence != null) {
            return coherence;
        }
        return s_mapInstance.entrySet().stream().findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public static Optional<Session> findSession(String sName) {
        for (Coherence coherence : s_mapInstance.values()) {
            Session session = coherence.getSession(sName);
            if (session == null) continue;
            return Optional.of(session);
        }
        return Optional.empty();
    }

    public static Collection<Session> findSessionsByScope(String sScope) {
        return s_mapInstance.values().stream().flatMap(coh -> coh.getSessionsWithScope(sScope).stream()).collect(Collectors.toList());
    }

    public static void closeAll() {
        Logger.info("Stopping all Coherence instances");
        s_mapInstance.values().forEach(Coherence::close);
        if (s_serverSystem != null) {
            s_serverSystem.stop();
        }
        Logger.info("All Coherence instances stopped");
        s_serverSystem = null;
        s_sessionSystem = null;
        s_fInitialized = false;
    }

    public String getName() {
        return this.f_sName;
    }

    public Mode getMode() {
        return this.f_mode;
    }

    public CoherenceConfiguration getConfiguration() {
        return this.f_config;
    }

    public boolean hasSession(String sName) {
        if ("$SYS".equals(sName)) {
            return s_sessionSystem != null && s_sessionSystem.isPresent();
        }
        SessionConfiguration configuration = this.f_config.getSessionConfigurations().get(sName);
        return configuration != null && configuration.isEnabled();
    }

    public Session getSession() {
        return this.getSession("");
    }

    public Session getSession(String sName) {
        this.assertNotClosed();
        if ("$SYS".equals(sName)) {
            return this.initializeSystemSession(Collections.emptyList(), this.f_mode);
        }
        String sSessionName = sName == null ? "" : sName;
        SessionConfiguration configuration = this.f_config.getSessionConfigurations().get(sSessionName);
        if (configuration == null || !configuration.isEnabled()) {
            throw new IllegalArgumentException("No Session has been configured with the name " + sSessionName);
        }
        return this.f_mapSession.get(sSessionName);
    }

    public Collection<Session> getSessionsWithScope(String sScope) {
        this.assertNotClosed();
        String sScopeName = sScope == null ? "" : sScope;
        return this.f_config.getSessionConfigurations().values().stream().filter(cfg -> sScopeName.equals(cfg.getScopeName())).map(SessionConfiguration::getName).map(this::getSession).collect(Collectors.toList());
    }

    public CompletableFuture<Void> whenStarted() {
        return this.f_futureStarted;
    }

    public CompletableFuture<Void> whenClosed() {
        return this.f_futureClosed;
    }

    public boolean isStarted() {
        return this.m_fStarted && !this.m_fClosed;
    }

    public boolean isClosed() {
        return this.m_fClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> start() {
        this.assertNotClosed();
        if (this.m_fStarted) {
            return this.f_futureStarted;
        }
        Coherence coherence = this;
        synchronized (coherence) {
            this.assertNotClosed();
            if (this.m_fStarted) {
                return this.f_futureStarted;
            }
            this.f_dispatcher.dispatchStarting();
            this.m_fStarted = true;
            try {
                Runnable runnable = () -> {
                    try {
                        if (this.f_mapServer.isEmpty()) {
                            this.startInternal();
                        }
                        this.f_mapServer.values().forEach(holder -> holder.getServer().waitForServiceStart());
                        this.f_futureStarted.complete(null);
                        this.f_dispatcher.dispatchStarted();
                    }
                    catch (Throwable thrown) {
                        Logger.err(thrown);
                        this.f_futureStarted.completeExceptionally(thrown);
                    }
                };
                Thread t = Base.makeThread(null, runnable, this.isDefaultInstance() ? "Coherence" : "Coherence:" + this.f_sName);
                t.setDaemon(true);
                t.start();
            }
            catch (Throwable thrown) {
                this.f_futureStarted.completeExceptionally(thrown);
            }
        }
        return this.f_futureStarted;
    }

    @Override
    public synchronized void close() {
        if (this.m_fClosed) {
            return;
        }
        this.f_dispatcher.dispatchStopping();
        this.m_fClosed = true;
        try {
            s_mapInstance.remove(this.f_sName);
            if (this.m_fStarted) {
                this.m_fStarted = false;
                this.f_config.getSessionConfigurations().values().stream().sorted(Comparator.reverseOrder()).map(cfg -> this.f_mapSession.get(cfg.getName())).filter(Objects::nonNull).forEach(session -> {
                    try {
                        session.close();
                    }
                    catch (Throwable t) {
                        Logger.err("Error closing session " + session.getName(), t);
                    }
                });
                this.f_mapServer.values().stream().sorted(Comparator.reverseOrder()).map(PriorityHolder::getServer).forEach(this::stopServer);
                this.f_mapServer.clear();
            }
            this.f_futureClosed.complete(null);
        }
        catch (Throwable thrown) {
            Logger.err(thrown);
            this.f_futureClosed.completeExceptionally(thrown);
        }
        this.f_dispatcher.dispatchStopped();
        this.f_registry.dispose();
    }

    public ResourceRegistry getResourceRegistry() {
        return this.f_registry;
    }

    public InterceptorRegistry getInterceptorRegistry() {
        return this.f_registry.getResource(InterceptorRegistry.class);
    }

    public Cluster getCluster() {
        return CacheFactory.getCluster();
    }

    public static void main(String[] args) {
        Coherence coherence = Coherence.clusterMember();
        coherence.start();
        coherence.whenClosed().join();
    }

    private boolean isDefaultInstance() {
        return "".equals(this.f_sName);
    }

    private void assertNotClosed() {
        if (this.m_fClosed) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " instance has been closed");
        }
    }

    private synchronized void startInternal() {
        Iterable<EventInterceptor<?>> globalInterceptors = this.f_config.getInterceptors();
        this.initializeSystemSession(globalInterceptors, this.f_mode);
        Logger.info(() -> this.isDefaultInstance() ? "Starting default Coherence instance" : "Starting Coherence instance " + this.f_sName);
        try {
            this.f_config.getSessionConfigurations().values().stream().sorted().forEach(configuration -> {
                if (this.m_fClosed) {
                    return;
                }
                if (configuration.isEnabled()) {
                    String sName = configuration.getName();
                    Iterable<? extends EventInterceptor<?>> interceptors = Coherence.join(globalInterceptors, configuration.getInterceptors());
                    Optional<Session> optional = Coherence.ensureSessionInternal(configuration, this.f_mode, interceptors);
                    if (optional.isPresent()) {
                        Session session = optional.get();
                        session.activate();
                        this.f_mapSession.put(sName, session);
                        if (session instanceof ConfigurableCacheFactorySession) {
                            ConfigurableCacheFactorySession supplier = (ConfigurableCacheFactorySession)session;
                            ConfigurableCacheFactory ccf = supplier.getConfigurableCacheFactory();
                            if (this.f_mode == Mode.ClusterMember) {
                                DefaultCacheServer dcs = this.startCCF(sName, ccf);
                                this.f_mapServer.put(sName, new PriorityHolder(configuration.getPriority(), dcs));
                            }
                        }
                    } else {
                        Logger.warn("Skipping Session " + configuration.getName() + " Session provider returned null");
                    }
                }
            });
        }
        catch (Throwable t) {
            Logger.err("Failed to start Coherence instance " + this.f_sName, t);
            this.close();
        }
        if (this.f_mode == Mode.ClusterMember) {
            Logger.info(() -> "Started Coherence server " + this.f_sName + CacheFactory.getCluster().getServiceBanner());
        } else {
            Logger.info(() -> "Started Coherence client " + this.f_sName);
        }
    }

    private static Iterable<? extends EventInterceptor<?>> join(Iterable<? extends EventInterceptor<?>> one, Iterable<? extends EventInterceptor<?>> two) {
        if (one == null && two == null) {
            return Collections.emptyList();
        }
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        Stream<? extends EventInterceptor<?>> s1 = StreamSupport.stream(one.spliterator(), false);
        Stream<? extends EventInterceptor<?>> s2 = StreamSupport.stream(two.spliterator(), false);
        return Stream.concat(s1, s2).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Optional<Session> ensureSessionInternal(SessionConfiguration configuration, Mode mode, Iterable<? extends EventInterceptor<?>> interceptors) {
        return SessionProvider.get().createSession(configuration, mode, interceptors);
    }

    private static void registerInterceptors(Session session, Iterable<? extends EventInterceptor<?>> interceptors) {
        InterceptorRegistry registry = session.getInterceptorRegistry();
        for (EventInterceptor<?> interceptor : interceptors) {
            registry.registerEventInterceptor(interceptor, RegistrationBehavior.FAIL);
        }
    }

    private DefaultCacheServer startCCF(String sName, ConfigurableCacheFactory ccf) {
        String sScopeName = ccf.getScopeName();
        boolean fHasScope = sScopeName != null && !sScopeName.isEmpty();
        Logger.info(() -> (sName == null || sName.isEmpty() ? "Starting default session" : "Starting session " + sName) + (fHasScope ? " with scope name " + sScopeName : ""));
        DefaultCacheServer dcs = new DefaultCacheServer(ccf);
        dcs.startDaemon(5000L);
        return dcs;
    }

    private void stopServer(DefaultCacheServer dcs) {
        try {
            dcs.stop();
        }
        catch (Throwable thrown) {
            Logger.err(thrown);
        }
    }

    private static synchronized void init() {
        if (s_fInitialized) {
            return;
        }
        s_fInitialized = true;
        CacheFactory.setCacheFactoryBuilder(new ScopedCacheFactoryBuilder(new ScopedUriScopeResolver(false)));
    }

    private synchronized Session initializeSystemSession(Iterable<? extends EventInterceptor<?>> interceptors, Mode mode) {
        if (s_sessionSystem == null) {
            Session session2;
            Coherence.init();
            SystemSessionConfiguration configuration = SystemSessionConfiguration.INSTANCE;
            Iterable<? extends EventInterceptor<?>> allInterceptors = Coherence.join(interceptors, configuration.getInterceptors());
            Optional<Session> optional = Coherence.ensureSessionInternal(configuration, mode, allInterceptors);
            if (optional.isPresent() && (session2 = optional.get()) instanceof ConfigurableCacheFactorySession) {
                ConfigurableCacheFactory ccfSystem = ((ConfigurableCacheFactorySession)session2).getConfigurableCacheFactory();
                s_serverSystem = this.startCCF("$SYS", ccfSystem);
            }
            s_sessionSystem = optional;
        } else {
            s_sessionSystem.ifPresent(session -> Coherence.registerInterceptors(session, interceptors));
        }
        return s_sessionSystem.orElse(null);
    }

    static void setSystemSession(Optional<Session> optional) {
        s_sessionSystem = Objects.requireNonNull(optional);
    }

    private static void validate(CoherenceConfiguration configuration) {
        for (Map.Entry<String, SessionConfiguration> entry : configuration.getSessionConfigurations().entrySet()) {
            String sName = entry.getKey();
            for (Coherence coherence : s_mapInstance.values()) {
                if (!coherence.hasSession(sName)) continue;
                throw new IllegalStateException("A Session with the name '" + sName + "' already exists in Coherence instance '" + coherence.getName() + "'");
            }
        }
    }

    public static interface LifecycleListener
    extends EventDispatcherAwareInterceptor<CoherenceLifecycleEvent> {
        @Override
        public void onEvent(CoherenceLifecycleEvent var1);

        @Override
        default public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
            if (dispatcher instanceof CoherenceDispatcher) {
                dispatcher.addEventInterceptor(sIdentifier, this);
            }
        }
    }

    public static enum Mode {
        Client,
        ClusterMember;

    }

    public static class Builder {
        private final CoherenceConfiguration f_config;
        private final Mode f_mode;

        private Builder(CoherenceConfiguration config, Mode mode) {
            this.f_config = config;
            this.f_mode = mode;
        }

        public Coherence build() {
            Coherence.init();
            Coherence.validate(this.f_config);
            Coherence coherence = new Coherence(this.f_config, this.f_mode);
            Coherence prev = s_mapInstance.putIfAbsent(this.f_config.getName(), coherence);
            if (prev != null) {
                throw new IllegalStateException("A Coherence instance with the name " + this.f_config.getName() + " already exists");
            }
            InterceptorRegistry registry = coherence.getInterceptorRegistry();
            for (LifecycleListener listener : ServiceLoader.load(LifecycleListener.class)) {
                registry.registerEventInterceptor(listener);
            }
            return coherence;
        }
    }

    private static class PriorityHolder
    implements Comparable<PriorityHolder> {
        private final int f_nPriority;
        private final DefaultCacheServer f_server;

        public PriorityHolder(int nPriority, DefaultCacheServer server) {
            this.f_nPriority = nPriority;
            this.f_server = server;
        }

        public int getPriority() {
            return this.f_nPriority;
        }

        public DefaultCacheServer getServer() {
            return this.f_server;
        }

        @Override
        public int compareTo(PriorityHolder o) {
            return Integer.compare(this.f_nPriority, o.f_nPriority);
        }
    }
}

