/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheFactoryBuilder;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.ScopeResolver;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.CopyOnWriteMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.Resources;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class ScopedCacheFactoryBuilder
implements CacheFactoryBuilder {
    protected final ScopeResolver f_scopeResolver;
    protected Map<ClassLoader, Map<String, ConfigurableCacheFactory>> m_mapByLoader = new CopyOnWriteMap<ClassLoader, Map<String, ConfigurableCacheFactory>>(WeakHashMap.class);
    protected Map<ClassLoader, Map<URI, XmlElement>> m_mapConfigByLoader = new CopyOnWriteMap<ClassLoader, Map<URI, XmlElement>>(WeakHashMap.class);

    public ScopedCacheFactoryBuilder() {
        this(null);
    }

    public ScopedCacheFactoryBuilder(ScopeResolver resolver) {
        this.f_scopeResolver = resolver == null ? this.instantiateScopeResolver() : resolver;
    }

    public ScopeResolver getScopeResolver() {
        return this.f_scopeResolver;
    }

    @Override
    public ConfigurableCacheFactory getConfigurableCacheFactory(ClassLoader loader) {
        return this.getFactory("$Default$", loader, null);
    }

    @Override
    public ConfigurableCacheFactory getConfigurableCacheFactory(String sConfigURI, ClassLoader loader) {
        return this.getFactory(sConfigURI, loader, null);
    }

    @Override
    public ConfigurableCacheFactory getConfigurableCacheFactory(String sConfigURI, ClassLoader loader, ParameterResolver resolver) {
        return this.getFactory(sConfigURI, loader, resolver);
    }

    @Override
    public void setCacheConfiguration(ClassLoader loader, XmlElement xmlConfig) {
        this.setCacheConfiguration("$Default$", loader, xmlConfig);
    }

    @Override
    public synchronized void setCacheConfiguration(String sConfigURI, ClassLoader loader, XmlElement xmlConfig) {
        ConfigurableCacheFactory ccf;
        Map<String, ConfigurableCacheFactory> mapCCF = this.m_mapByLoader.get(loader = Base.ensureClassLoader(loader));
        ConfigurableCacheFactory configurableCacheFactory = ccf = mapCCF == null ? null : mapCCF.get(sConfigURI);
        if (ccf != null) {
            this.release(ccf);
        }
        URL url = this.resolveURL(this.resolveURI(sConfigURI), loader);
        this.setXmlConfig(loader, url, xmlConfig);
    }

    @Override
    public ConfigurableCacheFactory setConfigurableCacheFactory(ConfigurableCacheFactory ccf, String sConfigURI, ClassLoader loader, boolean fReplace) {
        ConfigurableCacheFactory ccfOld;
        Map<String, ConfigurableCacheFactory> mapCCF = this.m_mapByLoader.get(loader = Base.ensureClassLoader(loader));
        ConfigurableCacheFactory configurableCacheFactory = ccfOld = mapCCF == null ? null : mapCCF.get(sConfigURI);
        if (ccfOld != null) {
            if (!fReplace) {
                return ccfOld;
            }
            this.release(ccfOld);
        }
        mapCCF = this.ensureConfigCCFMap(loader);
        mapCCF.put(sConfigURI, ccf);
        return ccfOld;
    }

    @Override
    public synchronized void releaseAll(ClassLoader loader) {
        Map<String, ConfigurableCacheFactory> map = this.m_mapByLoader.get(Base.ensureClassLoader(loader));
        if (map != null) {
            ArrayList<ConfigurableCacheFactory> list = new ArrayList<ConfigurableCacheFactory>(map.values());
            list.forEach(this::release);
            list.clear();
        }
        this.m_mapByLoader.remove(Base.ensureClassLoader(loader));
    }

    @Override
    public synchronized void release(ConfigurableCacheFactory factory) {
        HashSet<ClassLoader> setLoader = new HashSet<ClassLoader>();
        Map<ClassLoader, Map<String, ConfigurableCacheFactory>> mapByLoader = this.m_mapByLoader;
        for (Map.Entry<ClassLoader, Map<String, ConfigurableCacheFactory>> entry : mapByLoader.entrySet()) {
            Map<String, ConfigurableCacheFactory> mapCCF = entry.getValue();
            Iterator<ConfigurableCacheFactory> iterCCF = mapCCF.values().iterator();
            while (iterCCF.hasNext()) {
                if (!factory.equals(iterCCF.next())) continue;
                iterCCF.remove();
            }
            if (!mapCCF.isEmpty()) continue;
            setLoader.add(entry.getKey());
        }
        Map<ClassLoader, Map<URI, XmlElement>> mapConfigByLoader = this.m_mapConfigByLoader;
        mapByLoader.keySet().removeAll(setLoader);
        mapConfigByLoader.keySet().removeAll(setLoader);
    }

    protected ScopeResolver instantiateScopeResolver() {
        ScopeResolver scopeResolver = null;
        XmlElement xmlConfig = CacheFactory.getCacheFactoryBuilderConfig();
        XmlElement xmlResolver = xmlConfig.getElement("scope-resolver");
        if (xmlResolver != null) {
            try {
                scopeResolver = (ScopeResolver)XmlHelper.createInstance(xmlResolver, ScopedCacheFactoryBuilder.class.getClassLoader(), null);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Could not create scope resolver");
            }
        }
        if (scopeResolver == null) {
            scopeResolver = ScopeResolver.INSTANCE;
        }
        return scopeResolver;
    }

    protected ConfigurableCacheFactory getFactory(String sConfigURI, ClassLoader loader, ParameterResolver resolver) {
        return System.getSecurityManager() == null ? this.getFactoryInternal(sConfigURI, loader, resolver) : AccessController.doPrivileged(() -> this.getFactoryInternal(sConfigURI, loader, resolver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurableCacheFactory getFactoryInternal(String sConfigURI, ClassLoader loader, ParameterResolver resolver) {
        ConfigurableCacheFactory ccf;
        Map<String, ConfigurableCacheFactory> mapCCF;
        ClassLoader loaderSearch = loader = Base.ensureClassLoader(loader);
        while (!((mapCCF = this.m_mapByLoader.get(loaderSearch)) != null && mapCCF.containsKey(sConfigURI) || (loaderSearch = loaderSearch.getParent()) == null)) {
        }
        ConfigurableCacheFactory configurableCacheFactory = ccf = mapCCF == null ? null : mapCCF.get(sConfigURI);
        if (ccf == null) {
            ScopedCacheFactoryBuilder scopedCacheFactoryBuilder = this;
            synchronized (scopedCacheFactoryBuilder) {
                mapCCF = this.ensureConfigCCFMap(loader);
                ccf = mapCCF.get(sConfigURI);
                if (ccf == null) {
                    ccf = this.buildFactory(sConfigURI, loader, resolver);
                }
                mapCCF.put(sConfigURI, ccf);
            }
        }
        return ccf;
    }

    protected synchronized Map<String, ConfigurableCacheFactory> ensureConfigCCFMap(ClassLoader loader) {
        Map<ClassLoader, Map<String, ConfigurableCacheFactory>> mapByLoader = this.m_mapByLoader;
        Map<String, ConfigurableCacheFactory> mapCCF = mapByLoader.get(loader);
        if (mapCCF == null) {
            mapCCF = new LiteMap<String, ConfigurableCacheFactory>();
            mapByLoader.put(loader, mapCCF);
        }
        return mapCCF;
    }

    protected synchronized Map<URI, XmlElement> ensureConfigMap(ClassLoader loader) {
        Map<ClassLoader, Map<URI, XmlElement>> mapConfigByLoader = this.m_mapConfigByLoader;
        Map<URI, XmlElement> mapConfig = mapConfigByLoader.get(loader);
        if (mapConfig == null) {
            mapConfig = new HashMap<URI, XmlElement>();
            mapConfigByLoader.put(loader, mapConfig);
        }
        return mapConfig;
    }

    protected XmlElement getXmlConfig(ClassLoader loader, URL url) {
        Map<URI, XmlElement> mapXml = this.ensureConfigMap(loader);
        try {
            return mapXml.get(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected void setXmlConfig(ClassLoader loader, URL url, XmlElement xml) {
        Map<URI, XmlElement> mapXml = this.ensureConfigMap(loader);
        try {
            mapXml.put(url.toURI(), xml);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    protected synchronized XmlElement loadConfigFromURI(String sConfigURI, ClassLoader loader) {
        URL url = this.resolveURL(sConfigURI, loader);
        XmlElement xmlConfig = this.getXmlConfig(loader, url);
        if (xmlConfig == null) {
            try {
                xmlConfig = XmlHelper.loadResource(url, "cache configuration", loader);
                this.setXmlConfig(loader, url, xmlConfig);
            }
            catch (Exception e2) {
                IOException e2;
                Throwable eOrig;
                if (e2 instanceof RuntimeException && (eOrig = Base.getOriginalException((RuntimeException)e2)) instanceof IOException) {
                    StringBuilder sb = new StringBuilder("Could not load cache configuration resource " + url);
                    Throwable cause = eOrig.getCause();
                    if (cause != null) {
                        sb.append(", Cause:").append(cause.getMessage());
                    }
                    e2 = new IOException(sb.toString());
                }
                throw Base.ensureRuntimeException(e2);
            }
        }
        return xmlConfig;
    }

    protected XmlElement getConfigurableCacheFactoryConfig() {
        return CacheFactory.getConfigurableCacheFactoryConfig();
    }

    protected ConfigurableCacheFactory buildFactory(String sConfigURI, ClassLoader loader) {
        return this.buildFactory(sConfigURI, loader, null);
    }

    protected ConfigurableCacheFactory buildFactory(String sConfigURI, ClassLoader loader, ParameterResolver paramResolver) {
        XmlElement xmlScope;
        XmlElement xmlDefaults;
        String sScope;
        ScopeResolver resolver = this.getScopeResolver();
        String sDescopedURI = resolver == null ? sConfigURI : resolver.resolveURI(sConfigURI);
        String sResolvedURI = this.resolveURI(sDescopedURI);
        XmlElement xmlConfig = this.loadConfigFromURI(sResolvedURI, loader);
        String string = sScope = resolver == null ? null : resolver.resolveScopeName(sConfigURI, loader, null);
        if (sScope != null && !"".equals(sScope) && !resolver.useScopeInConfig() && (xmlDefaults = xmlConfig.getElement("defaults")) != null && (xmlScope = xmlDefaults.getElement("scope-name")) != null) {
            xmlScope.setString(sScope);
        }
        return this.instantiateFactory(loader, xmlConfig, this.getConfigurableCacheFactoryConfig(), null, sScope, paramResolver);
    }

    protected ConfigurableCacheFactory instantiateFactory(ClassLoader loader, XmlElement xmlConfig, XmlElement xmlFactory, String sPofConfigURI, String sScopeName, ParameterResolver resolver) {
        String sClass = xmlFactory.getSafeElement("class-name").getString();
        try {
            if (sClass.equals(ExtensibleConfigurableCacheFactory.class.getName())) {
                ExtensibleConfigurableCacheFactory.Dependencies dependencies = ExtensibleConfigurableCacheFactory.DependenciesHelper.newInstance(xmlConfig, loader, sPofConfigURI, sScopeName, resolver);
                ExtensibleConfigurableCacheFactory eccf = new ExtensibleConfigurableCacheFactory(dependencies);
                eccf.setConfigClassLoader(loader);
                return eccf;
            }
            if (sClass.equals(DefaultConfigurableCacheFactory.class.getName())) {
                DefaultConfigurableCacheFactory dccf = new DefaultConfigurableCacheFactory(xmlConfig);
                dccf.setConfigClassLoader(loader);
                sScopeName = xmlConfig.getSafeElement("scope-name").getString(sScopeName);
                if (sScopeName != null && sScopeName.length() > 0) {
                    dccf.setScopeName(sScopeName);
                }
                return dccf;
            }
            ConfigurableCacheFactory ccf = (ConfigurableCacheFactory)XmlHelper.createInstance(xmlFactory, loader, null);
            Method methSetConfig = ClassHelper.findMethod(ccf.getClass(), "setConfig", new Class[]{XmlElement.class}, false);
            if (methSetConfig != null) {
                ClassHelper.invoke(ccf, "setConfig", new Object[]{xmlConfig});
            }
            return ccf;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Failed to instantiate a class from the xmlConfiguration " + xmlConfig);
        }
    }

    protected String resolveURI(String sConfigURI) {
        if (sConfigURI.equals("$Default$")) {
            XmlElement xmlFactory = CacheFactory.getConfigurableCacheFactoryConfig();
            Object[] aoParam = XmlHelper.parseInitParams(xmlFactory.getSafeElement("init-params"));
            return aoParam.length > 0 && aoParam[0] instanceof String ? (String)aoParam[0] : "coherence-cache-config.xml";
        }
        return sConfigURI;
    }

    protected URL resolveURL(String sConfigURI, ClassLoader loader) {
        URL url = Resources.findFileOrResource(sConfigURI, loader);
        if (url == null) {
            try {
                url = new URL((sConfigURI.contains(":") ? "" : "file://") + sConfigURI);
            }
            catch (MalformedURLException e) {
                throw Base.ensureRuntimeException(e, "The configuration URI contains illegal characters for a URL " + sConfigURI);
            }
        }
        return url;
    }
}

