/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.AbstractServiceLoadBalancer;
import com.tangosol.net.Member;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceLoad;
import com.tangosol.util.Base;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SimpleServiceLoadBalancer<S extends Service, T extends ServiceLoad>
extends AbstractServiceLoadBalancer<S, T> {
    protected final Map<Member, T> m_mapLoad = new HashMap<Member, T>();
    protected final SortedMap<T, List<Member>> m_mapMember;

    public SimpleServiceLoadBalancer() {
        this(null);
    }

    public SimpleServiceLoadBalancer(Comparator<T> comparator) {
        this.m_mapMember = new TreeMap<T, List<Member>>(comparator);
    }

    @Override
    public synchronized void update(Member member, T load) {
        List listMembersOld;
        if (load == null && this.isLocalMember(member)) {
            this.m_mapLoad.clear();
            this.m_mapMember.clear();
            return;
        }
        Map<Member, T> mapLoad = this.m_mapLoad;
        SortedMap<T, List<Member>> mapMember = this.m_mapMember;
        ServiceLoad loadOld = (ServiceLoad)mapLoad.remove(member);
        if (loadOld != null && (listMembersOld = (List)mapMember.get(loadOld)) != null && listMembersOld.remove(member) && listMembersOld.isEmpty()) {
            mapMember.remove(loadOld);
        }
        if (load != null) {
            mapLoad.put(member, load);
            ArrayList<Member> listMembers = (ArrayList<Member>)mapMember.get(load);
            if (listMembers == null) {
                listMembers = new ArrayList<Member>();
                mapMember.put(load, listMembers);
            }
            listMembers.add(member);
        }
    }

    @Override
    public synchronized List<Member> getMemberList(Member client) {
        SortedMap<T, List<Member>> mapMember = this.m_mapMember;
        if (mapMember.isEmpty()) {
            return null;
        }
        ArrayList<Member> list = new ArrayList<Member>();
        for (List<Member> listMember : mapMember.values()) {
            list.addAll(Base.randomize(listMember));
        }
        return list;
    }

    @Override
    public int compare(T load1, T load2) {
        Comparator<T> comparator = this.m_mapMember.comparator();
        return comparator == null ? load1.compareTo(load2) : comparator.compare(load1, load2);
    }
}

