/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.application.ContainerHelper;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceMonitor;
import com.tangosol.net.management.Registry;
import com.tangosol.util.Base;
import com.tangosol.util.CopyOnWriteMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SimpleServiceMonitor
implements ServiceMonitor {
    protected static final Integer DEFAULT_WAIT_MILLIS = 5000;
    private static final ThreadGroup THREAD_GROUP = new ThreadGroup("ServiceMonitors");
    protected volatile boolean m_fStarted;
    protected Thread m_thread;
    protected boolean m_fDisposed;
    protected ConfigurableCacheFactory m_ccf;
    protected Map<Service, String> m_mapServices = new CopyOnWriteMap<Service, String>(HashMap.class);
    protected final long m_cWaitMillis;

    public SimpleServiceMonitor() {
        this(DEFAULT_WAIT_MILLIS.intValue());
    }

    public SimpleServiceMonitor(long cWaitMillis) {
        this.m_cWaitMillis = cWaitMillis;
    }

    @Override
    public void registerServices(Map<Service, String> mapServices) {
        Map<Service, String> mapServicesByName = this.m_mapServices;
        mapServicesByName.putAll(mapServices);
        if (!mapServicesByName.isEmpty()) {
            this.start();
        }
    }

    @Override
    public void unregisterServices(Set<Service> setServices) {
        Map<Service, String> mapServices = this.m_mapServices;
        mapServices.keySet().removeAll(setServices);
        if (mapServices.isEmpty()) {
            this.stopMonitoring();
        }
    }

    @Override
    public synchronized void stopMonitoring() {
        Thread thread = this.m_thread;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join(this.m_cWaitMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_fStarted = false;
        this.m_thread = null;
        this.m_ccf = null;
    }

    @Override
    public boolean isMonitoring() {
        return this.m_fStarted;
    }

    @Override
    public void setConfigurableCacheFactory(ConfigurableCacheFactory ccf) {
        this.m_ccf = ccf;
    }

    @Override
    public Thread getThread() {
        return this.m_thread;
    }

    @Override
    public void dispose() {
        this.m_fDisposed = true;
        this.m_ccf = null;
        this.stopMonitoring();
    }

    protected synchronized void start() {
        if (!this.m_fStarted) {
            this.assertNotDisposed();
            Thread thread = this.m_thread = Base.makeThread(THREAD_GROUP, new Runnable(){

                @Override
                public void run() {
                    SimpleServiceMonitor.this.monitorServices(SimpleServiceMonitor.this.m_cWaitMillis);
                }
            }, "ServiceMonitor");
            thread.setDaemon(true);
            thread.start();
            this.m_fStarted = true;
        }
    }

    protected void monitorServices(long cWaitMillis) {
        Thread thread = this.m_thread;
        Cluster cluster = CacheFactory.getCluster();
        Registry registry = cluster == null || !cluster.isRunning() ? null : cluster.getManagement();
        String sNodeName = registry == null ? null : registry.ensureGlobalName("type=Node");
        Base.azzert(thread == Thread.currentThread(), "monitorServices should only be called on the ServiceMonitor thread");
        while (!thread.isInterrupted()) {
            try {
                Blocking.sleep(cWaitMillis);
                ConfigurableCacheFactory ccf = this.m_ccf;
                for (Map.Entry<Service, String> entry : this.m_mapServices.entrySet()) {
                    Service service = entry.getKey();
                    if (service.isRunning()) continue;
                    ContainerHelper.initializeThreadContext(service);
                    if (ccf == null) {
                        service.start();
                        continue;
                    }
                    ccf.ensureService(entry.getValue());
                }
                if (registry == null || registry.isRegistered(sNodeName)) continue;
                sNodeName = registry.ensureGlobalName("type=Node");
            }
            catch (RuntimeException e) {
                Logger.err("Failed to restart services: ", (Throwable)e);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    protected boolean isDisposed() {
        return this.m_fDisposed;
    }

    protected void assertNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("This ServiceMonitor has been disposed and cannot be reused");
        }
    }
}

