/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.net.SocketSettings;
import com.oracle.coherence.common.net.Sockets;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;

public class SocketOptions
extends SocketSettings
implements XmlConfigurable {
    protected XmlElement m_xml;

    public boolean isConfigured() {
        return !this.f_mapOptions.isEmpty();
    }

    public void apply(ServerSocket socket) throws SocketException {
        SocketOptions.apply((java.net.SocketOptions)this, socket);
    }

    public void apply(Socket socket) throws SocketException {
        SocketOptions.apply((java.net.SocketOptions)this, socket);
    }

    public void apply(DatagramSocket socket) throws SocketException {
        SocketOptions.apply((java.net.SocketOptions)this, socket);
    }

    public void apply(MulticastSocket socket) throws SocketException {
        this.apply((DatagramSocket)socket);
    }

    @Override
    @Deprecated
    public XmlElement getConfig() {
        return this.m_xml;
    }

    @Override
    @Deprecated
    public void setConfig(XmlElement xml) {
        if (this.m_xml != null) {
            throw new IllegalStateException("already configured");
        }
        if (xml == null) {
            throw new IllegalArgumentException("Missing configuration");
        }
        Map map = this.f_mapOptions;
        XmlElement xmlSub = xml.getElement("reuse-address");
        if (xmlSub != null) {
            map.put(4, xmlSub.getBoolean(true));
        }
        if ((xmlSub = xml.getElement("receive-buffer-size")) != null) {
            map.put(4098, (int)Base.parseMemorySize(xmlSub.getString()));
        }
        if ((xmlSub = xml.getElement("send-buffer-size")) != null) {
            map.put(4097, (int)Base.parseMemorySize(xmlSub.getString()));
        }
        if ((xmlSub = xml.getElement("timeout")) != null) {
            map.put(4102, (int)Base.parseTime(xmlSub.getString()));
        }
        if ((xmlSub = xml.getElement("linger-timeout")) != null) {
            map.put(128, (int)(Base.parseTime(xmlSub.getString()) / 1000L));
        }
        if ((xmlSub = xml.getElement("keep-alive-enabled")) != null) {
            map.put(8, xmlSub.getBoolean(true));
        }
        if ((xmlSub = xml.getElement("out-of-band-inline")) != null) {
            map.put(4099, xmlSub.getBoolean(true));
        }
        if ((xmlSub = xml.getElement("tcp-delay-enabled")) != null) {
            map.put(1, !xmlSub.getBoolean(true));
        }
        if ((xmlSub = xml.getElement("traffic-class")) != null) {
            map.put(3, xmlSub.getInt());
        }
        this.m_xml = xml;
    }

    public void copyOptions(java.net.SocketOptions options) throws SocketException {
        this.setOptions(options);
    }

    @Deprecated
    public static SocketOptions load(XmlElement xml) {
        SocketOptions options = new SocketOptions();
        options.setConfig(xml);
        return options.isConfigured() ? options : null;
    }

    public static void apply(java.net.SocketOptions options, ServerSocket socket) throws SocketException {
        Sockets.configure(socket, options);
    }

    public static void apply(java.net.SocketOptions options, Socket socket) throws SocketException {
        Sockets.configure(socket, options);
    }

    public static void apply(java.net.SocketOptions options, DatagramSocket socket) throws SocketException {
        Sockets.configure(socket, options);
    }

    public void apply(java.net.SocketOptions options, MulticastSocket socket) throws SocketException {
        SocketOptions.apply(options, socket);
    }
}

