/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.BinaryStore;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.SerializationMap;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.Filter;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSerializationCache
extends SerializationMap
implements ObservableMap {
    private MapListenerSupport m_listenerSupport;

    public AbstractSerializationCache(BinaryStore store) {
        super(store);
    }

    public AbstractSerializationCache(BinaryStore store, ClassLoader loader) {
        super(store, loader);
    }

    public AbstractSerializationCache(BinaryStore store, boolean fBinaryMap) {
        super(store, fBinaryMap);
    }

    @Override
    public synchronized void clear() {
        if (this.hasListeners()) {
            Iterator iter = this.getInternalKeySet().iterator();
            while (iter.hasNext()) {
                this.dispatchPendingEvent(iter.next(), 3, null, false);
            }
        }
        super.clear();
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        boolean fListeners = this.hasListeners();
        boolean fContains = fListeners && this.getInternalKeySet().contains(oKey);
        Object oOrig = super.put(oKey, oValue);
        if (fListeners) {
            int nEvent = fContains ? 2 : 1;
            this.dispatchEvent(new CacheEvent<Object, Object>(this, nEvent, oKey, oOrig, oValue, false));
        }
        return oOrig;
    }

    @Override
    public void putAll(Map map) {
        if (this.hasListeners()) {
            Set setKeys = this.getInternalKeySet();
            for (Map.Entry entry : map.entrySet()) {
                Object oKey = entry.getKey();
                int nEvent = setKeys.contains(oKey) ? 2 : 1;
                this.dispatchPendingEvent(oKey, nEvent, entry.getValue(), false);
            }
        }
        super.putAll(map);
    }

    @Override
    public Object remove(Object oKey) {
        Object oOrig = null;
        if (this.getInternalKeySet().contains(oKey)) {
            oOrig = super.remove(oKey);
            if (this.hasListeners()) {
                this.dispatchEvent(new CacheEvent<Object, Object>(this, 3, oKey, oOrig, null, false));
            }
        }
        return oOrig;
    }

    @Override
    protected boolean removeBlind(Object oKey) {
        boolean fRemoved = false;
        if (this.getInternalKeySet().contains(oKey)) {
            if (this.hasListeners()) {
                this.dispatchPendingEvent(oKey, 3, null, false);
            }
            super.removeBlind(oKey);
            fRemoved = true;
        }
        return fRemoved;
    }

    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        AbstractSerializationCache.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, oKey, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        AbstractSerializationCache.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        AbstractSerializationCache.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        AbstractSerializationCache.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public abstract void evict();

    @Override
    protected String getDescription() {
        return super.getDescription() + ", hasListeners=" + this.hasListeners();
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchPendingEvent(final Object oKey, int nId, Object oNewValue, boolean fSynthetic) {
        AbstractKeyBasedMap.DeferredCacheEvent event = new AbstractKeyBasedMap.DeferredCacheEvent(this, nId, oKey, null, oNewValue, fSynthetic){

            protected Object readOldValue() {
                return AbstractSerializationCache.this.get(oKey);
            }
        };
        try {
            this.dispatchEvent(event);
        }
        finally {
            event.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(CacheEvent evt) {
        MapListenerSupport listenerSupport = this.getMapListenerSupport();
        if (listenerSupport != null) {
            AbstractSerializationCache abstractSerializationCache = this;
            synchronized (abstractSerializationCache) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }
}

