/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;

public class CacheEvent<K, V>
extends MapEvent<K, V> {
    protected boolean m_fSynthetic;
    protected boolean m_fPriming;
    protected TransformationState m_transformState = TransformationState.TRANSFORMABLE;

    public CacheEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew, boolean fSynthetic) {
        this(map, nId, oKey, oValueOld, oValueNew, fSynthetic, TransformationState.TRANSFORMABLE);
    }

    public CacheEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew, boolean fSynthetic, boolean fPriming) {
        this(map, nId, oKey, oValueOld, oValueNew, fSynthetic, TransformationState.TRANSFORMABLE, fPriming);
    }

    public CacheEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew, boolean fSynthetic, TransformationState transformState) {
        this(map, nId, oKey, oValueOld, oValueNew, fSynthetic, transformState, false);
    }

    public CacheEvent(ObservableMap<K, V> map, int nId, K oKey, V oValueOld, V oValueNew, boolean fSynthetic, TransformationState transformState, boolean fPriming) {
        super(map, nId, oKey, oValueOld, oValueNew);
        this.m_fSynthetic = fSynthetic;
        this.m_fPriming = fPriming;
        this.m_transformState = transformState;
    }

    @Override
    protected boolean shouldDispatch(MapListener listener) {
        return super.shouldDispatch(listener) && (!this.isPriming() || MapListenerSupport.isPrimingListener(listener));
    }

    public boolean isSynthetic() {
        return this.m_fSynthetic;
    }

    public boolean isPriming() {
        return this.m_fPriming;
    }

    public TransformationState getTransformationState() {
        return this.m_transformState;
    }

    @Override
    protected String getDescription() {
        String sDescr = super.getDescription();
        return (this.isSynthetic() ? sDescr + ", synthetic" : sDescr) + (this.isPriming() ? ", priming" : "");
    }

    public static enum TransformationState {
        NON_TRANSFORMABLE,
        TRANSFORMABLE,
        TRANSFORMED;

    }
}

