/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.CacheService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Service;
import com.tangosol.net.cache.CachingMap;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class NearCache<K, V>
extends CachingMap<K, V>
implements NamedCache<K, V>,
ClassLoaderAware {
    protected boolean m_fDestroyed = false;
    protected final String f_sName;
    protected final CacheService f_service;
    protected final MemberListener f_listenerBackService;
    private String m_sTier;
    protected final String f_sServiceName;

    public NearCache(Map<K, V> mapFront, NamedCache<K, V> mapBack) {
        this(mapFront, mapBack, 3);
    }

    public NearCache(Map<K, V> mapFront, NamedCache<K, V> mapBack, int nStrategy) {
        super(mapFront, mapBack, nStrategy);
        this.f_sName = mapBack.getCacheName();
        this.f_service = mapBack.getCacheService();
        this.f_sServiceName = this.f_service.getInfo().getServiceName();
        this.f_listenerBackService = this.registerBackServiceListener();
    }

    public NamedCache<K, V> getBackCache() {
        return (NamedCache)this.getBackMap();
    }

    public String getRegistrationContext() {
        return this.m_sTier;
    }

    public void setRegistrationContext(String sCtx) {
        this.m_sTier = sCtx;
    }

    @Override
    public String getCacheName() {
        return this.f_sName;
    }

    @Override
    public CacheService getCacheService() {
        return this.f_service;
    }

    @Override
    public boolean isActive() {
        try {
            return this.getFrontMap() != null && this.getBackCache().isActive();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public void release() {
        this.release(false);
    }

    @Override
    public void destroy() {
        this.release(true);
    }

    @Override
    public void truncate() {
        this.getBackCache().truncate();
    }

    @Override
    public boolean isDestroyed() {
        try {
            return this.m_fDestroyed || this.getBackCache().isDestroyed();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public boolean isReleased() {
        try {
            return this.getBackCache().isReleased();
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> listener) {
        this.getBackCache().addMapListener(listener);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> listener) {
        this.getBackCache().removeMapListener(listener);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> listener, K oKey, boolean fLite) {
        this.getBackCache().addMapListener(listener, (K)oKey, fLite);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> listener, K oKey) {
        this.getBackCache().removeMapListener(listener, (K)oKey);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> listener, Filter filter, boolean fLite) {
        this.getBackCache().addMapListener(listener, filter, fLite);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> listener, Filter filter) {
        this.getBackCache().removeMapListener(listener, filter);
    }

    @Override
    public V put(K oKey, V oValue, long cMillis) {
        return super.put(oKey, oValue, true, cMillis);
    }

    @Override
    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    @Override
    public boolean lock(Object oKey, long lMillis) {
        if (this.getBackCache().lock(oKey, lMillis)) {
            if (this.getInvalidationStrategy() == 0) {
                this.getFrontMap().remove(oKey);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean unlock(Object oKey) {
        return this.getBackCache().unlock(oKey);
    }

    @Override
    public Set<K> keySet(Filter filter) {
        return this.getBackCache().keySet(filter);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Filter filter) {
        return this.getBackCache().entrySet(filter);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Filter filter, Comparator comparator) {
        return this.getBackCache().entrySet(filter, comparator);
    }

    @Override
    public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> extractor, boolean fOrdered, Comparator<? super E> comparator) {
        this.getBackCache().addIndex(extractor, fOrdered, comparator);
    }

    @Override
    public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> extractor) {
        this.getBackCache().removeIndex(extractor);
    }

    @Override
    public <R> R invoke(K key, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.getBackCache().invoke(key, processor);
    }

    @Override
    public <R> Map<K, R> invokeAll(Collection<? extends K> collKeys, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.getBackCache().invokeAll(collKeys, processor);
    }

    @Override
    public <R> Map<K, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.getBackCache().invokeAll(filter, processor);
    }

    @Override
    public <R> R aggregate(Collection<? extends K> collKeys, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return this.getBackCache().aggregate(collKeys, aggregator);
    }

    @Override
    public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return this.getBackCache().aggregate(filter, aggregator);
    }

    protected void release(boolean fDestroy) {
        this.unregisterMBean();
        try {
            NamedCache<K, V> cache = this.getBackCache();
            this.unregisterBackServiceListener();
            super.release();
            if (fDestroy) {
                this.m_fDestroyed = true;
                cache.destroy();
            } else {
                cache.release();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected MemberListener registerBackServiceListener() {
        CacheService service = this.getCacheService();
        if (service != null) {
            try {
                BackServiceListener listener = new BackServiceListener();
                service.addMemberListener(listener);
                return listener;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void unregisterBackServiceListener() {
        try {
            this.getCacheService().removeMemberListener(this.f_listenerBackService);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void registerMBean() {
        MBeanHelper.registerCacheMBean(this, this.getRegistrationContext());
    }

    @Override
    protected void unregisterMBean() {
        MBeanHelper.unregisterCacheMBean(this.f_service.getCluster(), this.f_sServiceName, this.f_sName, this.getRegistrationContext());
    }

    @Override
    public ClassLoader getContextClassLoader() {
        NamedCache<K, V> cacheBack = this.getBackCache();
        return cacheBack instanceof ClassLoaderAware ? ((ClassLoaderAware)((Object)cacheBack)).getContextClassLoader() : Base.getContextClassLoader();
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    protected class BackServiceListener
    implements MemberListener {
        protected BackServiceListener() {
        }

        @Override
        public void memberJoined(MemberEvent evt) {
            if (evt.isLocal()) {
                NearCache.this.resetFrontMap();
                NearCache.this.registerMBean();
            }
        }

        @Override
        public void memberLeaving(MemberEvent evt) {
        }

        @Override
        public void memberLeft(MemberEvent evt) {
            if (NearCache.this.getInvalidationStrategy() != 0) {
                if (evt.isLocal()) {
                    NearCache.this.resetFrontMap();
                    NearCache.this.unregisterMBean();
                } else {
                    Service service = evt.getService();
                    if (service instanceof PartitionedService && ((PartitionedService)service).getPartitionOwner(0) == null && ((PartitionedService)service).getOwnershipSenior() == null) {
                        NearCache.this.resetFrontMap();
                    }
                }
            }
        }
    }
}

