/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.util.Base;
import com.tangosol.util.MapListener;
import com.tangosol.util.ObservableMap;
import java.util.Map;

public class VersionedBackingMap
extends ReadWriteBackingMap {
    public static final long MAX_LOCK_WAIT = 0L;
    private NamedCache m_mapVersionTransient;
    private NamedCache m_mapVersionPersist;
    private boolean m_fManageTransient;

    public VersionedBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheLoader loader, NamedCache mapVersionTransient, NamedCache mapVersionPersist, boolean fManageTransient) {
        super(ctxService, mapInternal, mapMisses, loader, true, 0, 0.0);
        this.init(mapVersionTransient, mapVersionPersist, fManageTransient);
    }

    public VersionedBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheStore store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, NamedCache mapVersionTransient, NamedCache mapVersionPersist, boolean fManageTransient) {
        super(ctxService, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor);
        this.init(mapVersionTransient, mapVersionPersist, fManageTransient);
    }

    private void init(NamedCache mapVersionTransient, NamedCache mapVersionPersist, boolean fManageTransient) {
        this.m_mapVersionTransient = mapVersionTransient;
        this.m_mapVersionPersist = mapVersionPersist;
        this.m_fManageTransient = fManageTransient;
    }

    @Override
    protected MapListener instantiateInternalListener() {
        return new InternalMapListener();
    }

    @Override
    protected ReadWriteBackingMap.CacheStoreWrapper instantiateCacheStoreWrapper(CacheStore store) {
        return store == null ? null : new CacheStoreWrapper(store);
    }

    public NamedCache getPersistentVersionCache() {
        return this.m_mapVersionPersist;
    }

    protected void updatePersistentVersion(Object oKey, Comparable ver) {
        NamedCache mapVerPersistent = this.getPersistentVersionCache();
        if (mapVerPersistent != null) {
            try {
                if (ver == null) {
                    mapVerPersistent.remove(oKey);
                } else {
                    mapVerPersistent.put(oKey, ver);
                }
            }
            catch (Exception e) {
                Base.err("An exception occurred updating the persistent version cache:");
                Base.err(e);
                Base.err("(The exception will be ignored. The VersionedBackingMap will continue.)");
            }
        }
    }

    public NamedCache getTransientVersionCache() {
        return this.m_mapVersionTransient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTransientVersion(Object oKey, Comparable ver) {
        NamedCache mapVerTransient = this.getTransientVersionCache();
        if (mapVerTransient != null && mapVerTransient.lock(oKey, 0L)) {
            try {
                if (ver == null) {
                    mapVerTransient.remove(oKey);
                } else {
                    mapVerTransient.put(oKey, ver);
                }
            }
            catch (Exception e) {
                Base.err("An exception occurred updating the transient version cache:");
                Base.err(e);
                Base.err("(The exception will be ignored. The VersionedBackingMap will continue.)");
            }
            finally {
                mapVerTransient.unlock(oKey);
            }
        }
    }

    public boolean isManagingTransientVersion() {
        return this.m_fManageTransient;
    }

    public class CacheStoreWrapper
    extends ReadWriteBackingMap.CacheStoreWrapper {
        public CacheStoreWrapper(CacheStore store) {
            super(store);
        }
    }

    protected class InternalMapListener
    extends ReadWriteBackingMap.InternalMapListener {
        protected InternalMapListener() {
        }
    }
}

