/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events;

import com.tangosol.net.events.partition.TransactionEvent;
import com.tangosol.net.events.partition.UnsolicitedCommitEvent;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.MapTrigger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class EventHelper {
    public static Map<EntryEvent.Type, Set<BinaryEntry>> getEntryEventsMap(TransactionEvent event) {
        return EventHelper.getEntryEventsMap(event.getEntrySet(), event.getType() == TransactionEvent.Type.COMMITTING);
    }

    public static Map<EntryEvent.Type, Set<BinaryEntry>> getEntryEventsMap(UnsolicitedCommitEvent event) {
        return EventHelper.getEntryEventsMap(event.getEntrySet(), false);
    }

    protected static Map<EntryEvent.Type, Set<BinaryEntry>> getEntryEventsMap(Set<BinaryEntry> setEntries, boolean fPreEvent) {
        HashMap<EntryEvent.Type, Set<BinaryEntry>> mapEntries = new HashMap<EntryEvent.Type, Set<BinaryEntry>>(setEntries.size());
        for (BinaryEntry binEntry : setEntries) {
            if (binEntry == null) continue;
            EntryEvent.Type eventType = binEntry.isPresent() ? (((MapTrigger.Entry)((Object)binEntry)).isOriginalPresent() ? (fPreEvent ? EntryEvent.Type.UPDATING : EntryEvent.Type.UPDATED) : (fPreEvent ? EntryEvent.Type.INSERTING : EntryEvent.Type.INSERTED)) : (fPreEvent ? EntryEvent.Type.REMOVING : EntryEvent.Type.REMOVED);
            HashSet<BinaryEntry> setTypedEntries = (HashSet<BinaryEntry>)mapEntries.get((Object)eventType);
            if (setTypedEntries == null) {
                setTypedEntries = new HashSet<BinaryEntry>();
                mapEntries.put(eventType, setTypedEntries);
            }
            setTypedEntries.add(binEntry);
        }
        return mapEntries;
    }
}

