/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.tangosol.coherence.config.CacheConfig;
import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.TopicMapping;
import com.tangosol.coherence.config.builder.NamedEventInterceptorBuilder;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.injection.SimpleInjector;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.internal.NamedEventInterceptor;
import com.tangosol.util.Base;
import com.tangosol.util.ChainedResourceResolver;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ResourceResolverHelper;
import java.util.List;

public class InterceptorManager {
    protected final CacheConfig f_cacheConfig;
    protected final ClassLoader f_loader;
    protected final ResourceRegistry f_registry;

    public InterceptorManager(CacheConfig cacheConfig, ClassLoader loader, ResourceRegistry registry) {
        Base.azzert(cacheConfig != null);
        this.f_cacheConfig = cacheConfig;
        this.f_loader = loader;
        this.f_registry = registry;
    }

    public void instantiateGlobalInterceptors() {
        this.registerEventInterceptors(this.f_cacheConfig.getEventInterceptorBuilders(), new ResolvableParameterList());
    }

    public void instantiateServiceInterceptors(String sServiceName) {
        CacheConfig config = this.f_cacheConfig;
        for (ServiceScheme scheme : config.getServiceSchemeRegistry()) {
            if (!scheme.getScopedServiceName().equals(sServiceName)) continue;
            List<NamedEventInterceptorBuilder> listBuilders = scheme.getEventInterceptorBuilders();
            ResolvableParameterList parameters = new ResolvableParameterList();
            parameters.add(new Parameter("service-name", sServiceName));
            this.registerEventInterceptors(listBuilders, parameters);
            break;
        }
    }

    public void instantiateCacheInterceptors(String sCacheName, String sServiceName) {
        CacheMapping mapping = this.f_cacheConfig.getMappingRegistry().findMapping(sCacheName, CacheMapping.class);
        if (mapping != null) {
            List<NamedEventInterceptorBuilder> listBuilders = mapping.getEventInterceptorBuilders();
            ResolvableParameterList parameters = new ResolvableParameterList();
            parameters.add(new Parameter("service-name", sServiceName));
            parameters.add(new Parameter("cache-name", sCacheName));
            this.registerEventInterceptors(listBuilders, parameters);
        }
    }

    public void instantiateDestinationInterceptors(String sDestinationName, String sServiceName) {
        TopicMapping mapping = this.f_cacheConfig.getMappingRegistry().findMapping(sDestinationName, TopicMapping.class);
        if (mapping != null) {
            List<NamedEventInterceptorBuilder> listBuilders = mapping.getEventInterceptorBuilders();
            ResolvableParameterList parameters = new ResolvableParameterList();
            parameters.add(new Parameter("service-name", sServiceName));
            parameters.add(new Parameter("topic-name", sDestinationName));
            this.registerEventInterceptors(listBuilders, parameters);
        }
    }

    public void registerEventInterceptors(List<NamedEventInterceptorBuilder> listBuilders, ResolvableParameterList parameters) {
        CacheConfig config = this.f_cacheConfig;
        ClassLoader loader = this.f_loader;
        ResourceRegistry registry = this.f_registry;
        if (listBuilders != null && !listBuilders.isEmpty()) {
            SimpleInjector injector = new SimpleInjector();
            ChainedResourceResolver resourceResolver = new ChainedResourceResolver(ResourceResolverHelper.resourceResolverFrom(parameters, config.getDefaultParameterResolver()), ResourceResolverHelper.resourceResolverFrom(ResourceRegistry.class, registry), registry);
            InterceptorRegistry registryIntcptr = registry.getResource(InterceptorRegistry.class);
            for (NamedEventInterceptorBuilder bldr : listBuilders) {
                NamedEventInterceptor interceptor = bldr.realize(parameters, loader, null);
                injector.inject(interceptor.getInterceptor(), resourceResolver);
                registryIntcptr.registerEventInterceptor(interceptor);
            }
        }
    }
}

