/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.net.Member;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.events.internal.AbstractEvent;
import com.tangosol.net.events.internal.AbstractEventDispatcher;
import com.tangosol.net.events.partition.Event;
import com.tangosol.net.events.partition.PartitionedServiceDispatcher;
import com.tangosol.net.events.partition.TransactionEvent;
import com.tangosol.net.events.partition.TransferEvent;
import com.tangosol.net.events.partition.UnsolicitedCommitEvent;
import com.tangosol.util.BinaryEntry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServiceDispatcher
extends AbstractEventDispatcher
implements PartitionedServiceDispatcher {
    protected static final Set<Enum> EVENT_TYPES = new HashSet<Enum>(){
        {
            this.addAll(Arrays.asList(TransactionEvent.Type.values()));
            this.addAll(Arrays.asList(TransferEvent.Type.values()));
            this.addAll(Arrays.asList(UnsolicitedCommitEvent.Type.values()));
        }
    };
    protected final PartitionedService m_service;

    public ServiceDispatcher(PartitionedService service) {
        super(EVENT_TYPES);
        this.m_service = service;
    }

    @Override
    public PartitionedService getService() {
        return this.m_service;
    }

    public Continuation getTransactionEventContinuation(TransactionEvent.Type eventType, Set<BinaryEntry> setEntries) {
        return this.getDispatchContinuation(new PartitionedServiceTransactionEvent(this, eventType, setEntries), null);
    }

    public Continuation getTransferEventContinuation(TransferEvent.Type eventType, int nPartition, Member memberLocal, Member memberRemote, Map<String, Set<BinaryEntry>> mapEntries, Continuation continuation) {
        PartitionedServiceTransferEvent event = new PartitionedServiceTransferEvent(this, eventType, nPartition, memberLocal, memberRemote, mapEntries);
        return this.getDispatchContinuation(event, continuation);
    }

    public Continuation getRecoveryTransferEventContinuation(int nPartition, Member memberLocal, Member memberRemote, Map<String, Set<BinaryEntry>> mapEntries, String sSnapshotName, Continuation continuation) {
        PartitionedServiceRecoveryEvent event = new PartitionedServiceRecoveryEvent((PartitionedServiceDispatcher)this, nPartition, memberLocal, memberRemote, mapEntries, sSnapshotName);
        return this.getDispatchContinuation(event, continuation);
    }

    public Continuation getUnsolicitedCommitEventContinuation(UnsolicitedCommitEvent.Type eventType, Set<BinaryEntry> setEntries) {
        return this.getDispatchContinuation(new PartitionedServiceUnsolicitedCommitEvent(this, eventType, setEntries), null);
    }

    protected static class PartitionedServiceUnsolicitedCommitEvent
    extends AbstractPartitionedServiceEvent<UnsolicitedCommitEvent.Type>
    implements UnsolicitedCommitEvent {
        protected final Set<BinaryEntry> m_setEntries;

        protected PartitionedServiceUnsolicitedCommitEvent(PartitionedServiceDispatcher dispatcher, UnsolicitedCommitEvent.Type eventType, Set<BinaryEntry> setEntries) {
            super(dispatcher, eventType);
            this.m_setEntries = setEntries;
        }

        @Override
        public Set<BinaryEntry> getEntrySet() {
            return this.m_setEntries;
        }
    }

    protected static class PartitionedServiceRecoveryEvent
    extends PartitionedServiceTransferEvent
    implements TransferEvent.RecoveryTransferEvent {
        protected final String f_sSnapshotName;

        protected PartitionedServiceRecoveryEvent(PartitionedServiceDispatcher dispatcher, int nPartition, Member memberLocal, Member memberRemote, Map<String, Set<BinaryEntry>> mapEntries, String sSnapshotName) {
            super(dispatcher, TransferEvent.Type.RECOVERED, nPartition, memberLocal, memberRemote, mapEntries);
            this.f_sSnapshotName = sSnapshotName;
        }

        @Override
        public String getSnapshotName() {
            return this.f_sSnapshotName;
        }

        @Override
        protected String getDescription() {
            return super.getDescription() + ", SnapshotName=" + this.f_sSnapshotName;
        }
    }

    protected static class PartitionedServiceTransferEvent
    extends AbstractPartitionedServiceEvent<TransferEvent.Type>
    implements TransferEvent {
        protected final int m_nPartition;
        protected final Member m_memberLocal;
        protected final Member m_memberRemote;
        protected final Map<String, Set<BinaryEntry>> m_mapEntries;

        protected PartitionedServiceTransferEvent(PartitionedServiceDispatcher dispatcher, TransferEvent.Type eventType, int nPartition, Member memberLocal, Member memberRemote, Map<String, Set<BinaryEntry>> mapEntries) {
            super(dispatcher, eventType);
            this.m_nPartition = nPartition;
            this.m_mapEntries = mapEntries;
            this.m_memberRemote = memberRemote;
            this.m_memberLocal = memberLocal;
        }

        @Override
        protected boolean isMutableEvent() {
            return false;
        }

        @Override
        protected String getDescription() {
            return super.getDescription() + ", Partition=" + this.m_nPartition;
        }

        @Override
        public int getPartitionId() {
            return this.m_nPartition;
        }

        @Override
        public Member getLocalMember() {
            return this.m_memberLocal;
        }

        @Override
        public Member getRemoteMember() {
            return this.m_memberRemote;
        }

        @Override
        public Map<String, Set<BinaryEntry>> getEntries() {
            return this.m_mapEntries;
        }
    }

    protected static class PartitionedServiceTransactionEvent
    extends AbstractPartitionedServiceEvent<TransactionEvent.Type>
    implements TransactionEvent {
        protected final Set<BinaryEntry> m_setEntries;

        protected PartitionedServiceTransactionEvent(PartitionedServiceDispatcher dispatcher, TransactionEvent.Type eventType, Set<BinaryEntry> setEntries) {
            super(dispatcher, eventType);
            this.m_setEntries = setEntries;
        }

        @Override
        protected boolean isMutableEvent() {
            return TransactionEvent.Type.COMMITTING == this.getType();
        }

        @Override
        public Set<BinaryEntry> getEntrySet() {
            return this.m_setEntries;
        }
    }

    protected static abstract class AbstractPartitionedServiceEvent<T extends Enum<T>>
    extends AbstractEvent<T>
    implements Event<T> {
        public AbstractPartitionedServiceEvent(PartitionedServiceDispatcher dispatcher, T eventType) {
            super(dispatcher, eventType);
        }

        @Override
        protected String getDescription() {
            return super.getDescription() + ", Service=" + this.getService().getInfo().getServiceName();
        }

        @Override
        public PartitionedServiceDispatcher getDispatcher() {
            return (PartitionedServiceDispatcher)this.m_dispatcher;
        }
    }
}

