/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.SegmentedConcurrentMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.Subject;

public class AbstractScopedReferenceStore {
    protected SegmentedConcurrentMap m_mapByName = new SegmentedConcurrentMap();

    public void clear() {
        this.m_mapByName.clear();
    }

    public Set getNames() {
        return this.m_mapByName.keySet();
    }

    public boolean lock(String sName) {
        return this.lock(sName, -1L);
    }

    public boolean lock(String sName, long cWait) {
        return this.m_mapByName.lock(sName, cWait);
    }

    public boolean lockAll() {
        return this.m_mapByName.lock(ConcurrentMap.LOCK_ALL, -1L);
    }

    public boolean unlock(String sName) {
        return this.m_mapByName.unlock(sName);
    }

    public boolean unlockAll() {
        return this.m_mapByName.unlock(ConcurrentMap.LOCK_ALL);
    }

    public void remove(String sName) {
        this.m_mapByName.remove(sName);
    }

    protected class SubjectScopedReference {
        private Map m_mapSubjectScope = new WeakHashMap();
        private Object m_oRef;

        protected SubjectScopedReference() {
        }

        protected synchronized Object get() {
            Subject subject = SecurityHelper.getCurrentSubject();
            return subject == null ? this.m_oRef : this.m_mapSubjectScope.get(subject);
        }

        protected synchronized boolean isEmpty() {
            Subject subject = SecurityHelper.getCurrentSubject();
            return subject == null ? this.m_oRef == null : this.m_mapSubjectScope.isEmpty();
        }

        protected synchronized void set(Object oRef) {
            Subject subject = SecurityHelper.getCurrentSubject();
            if (subject == null) {
                this.m_oRef = oRef;
            } else {
                this.m_mapSubjectScope.put(subject, oRef);
            }
        }

        protected synchronized Object putIfAbsent(Object oRef) {
            Subject subject = SecurityHelper.getCurrentSubject();
            Object oReturn = null;
            if (subject == null) {
                this.m_oRef = this.m_oRef == null ? oRef : (oReturn = this.m_oRef);
            } else {
                oReturn = this.m_mapSubjectScope.get(subject);
                if (oReturn == null) {
                    this.m_mapSubjectScope.put(subject, oRef);
                }
            }
            return oReturn;
        }

        protected synchronized Object remove() {
            Subject subject = SecurityHelper.getCurrentSubject();
            return subject == null ? (this.m_oRef = null) : (Object)this.m_mapSubjectScope.remove(subject);
        }

        protected Collection values() {
            Object oRef = this.m_oRef;
            if (oRef == null) {
                return this.m_mapSubjectScope.values();
            }
            if (this.m_mapSubjectScope.isEmpty()) {
                return Collections.singleton(oRef);
            }
            HashSet col = new HashSet(this.m_mapSubjectScope.values());
            col.add(oRef);
            return col;
        }
    }
}

