/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.net.Member;
import com.tangosol.net.PartitionedService;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class QuorumInfo
implements ExternalizableLite {
    private final int V_12_2_1_1_0 = 1;
    private int m_nVersion = 1;
    private Set<Member> m_setMembers;
    private int[] m_anOwner;
    private int[] m_anVersion;

    public QuorumInfo() {
    }

    public QuorumInfo(PartitionedService service) {
        this.m_setMembers = new HashSet<Member>(service.getOwnershipEnabledMembers());
        int cParts = service.getPartitionCount();
        int[] anOwner = new int[cParts];
        for (int iPart = 0; iPart < cParts; ++iPart) {
            Member member = service.getPartitionOwner(iPart);
            anOwner[iPart] = member == null ? 0 : member.getId();
        }
        this.m_anOwner = anOwner;
        int[] anVersion = new int[cParts];
        for (int iPart = 0; iPart < cParts; ++iPart) {
            anVersion[iPart] = service.getOwnershipVersion(iPart);
        }
        this.m_anVersion = anVersion;
    }

    public Set<Member> getMembers() {
        return this.m_setMembers;
    }

    public int[] getOwners() {
        return this.m_anOwner;
    }

    public int[] getVersions() {
        return this.m_anVersion;
    }

    public LongArray<Member> getMemberArray() {
        SparseArray<Member> laMembers = new SparseArray<Member>();
        for (Member member : this.m_setMembers) {
            laMembers.set(member.getId(), member);
        }
        return laMembers;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nVersion = ExternalizableHelper.readInt(in);
        if (this.m_nVersion >= 1) {
            this.m_setMembers = new HashSet<Member>();
            ExternalizableHelper.readCollection(in, this.m_setMembers, null);
            this.m_anOwner = this.readIntArray(in);
            this.m_anVersion = this.readIntArray(in);
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt(out, this.m_nVersion);
        ExternalizableHelper.writeCollection(out, this.m_setMembers);
        this.writeIntArray(out, this.m_anOwner);
        this.writeIntArray(out, this.m_anVersion);
    }

    private int[] readIntArray(DataInput in) throws IOException {
        int c = ExternalizableHelper.readInt(in);
        int[] ai = new int[c];
        for (int i = 0; i < c; ++i) {
            ai[i] = ExternalizableHelper.readInt(in);
        }
        return ai;
    }

    private void writeIntArray(DataOutput out, int[] ai) throws IOException {
        int c = ai.length;
        ExternalizableHelper.writeInt(out, c);
        for (int i = 0; i < c; ++i) {
            ExternalizableHelper.writeInt(out, ai[i]);
        }
    }
}

