/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.internal.SessionExpiryExtractor;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SessionOptimisticPut
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    public Binary m_binValue;
    public boolean m_fNoLock;

    public SessionOptimisticPut() {
    }

    public SessionOptimisticPut(Binary binValue, int nVersion, boolean fNoLock) {
        if (binValue == null || nVersion < 0) {
            throw new IllegalArgumentException();
        }
        this.m_binValue = binValue;
        this.m_fNoLock = fNoLock;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        int nVersionRet;
        Binary binSessionNew;
        int nVersionNew;
        BinaryEntry binentry = (BinaryEntry)entry;
        boolean fOldExists = entry.isPresent();
        Binary binSessionOld = fOldExists ? binentry.getBinaryValue() : null;
        int nVersionOld = fOldExists ? SessionOptimisticPut.extractVersion(binSessionOld) : 0;
        if (nVersionOld + 1 == (nVersionNew = SessionOptimisticPut.extractVersion(binSessionNew = this.m_binValue))) {
            binentry.updateBinaryValue(binSessionNew);
            nVersionRet = nVersionNew;
        } else if (!fOldExists) {
            nVersionRet = 0;
        } else {
            int ofOld = SessionExpiryExtractor.validateBinarySession(binSessionOld);
            int ofNew = SessionExpiryExtractor.validateBinarySession(binSessionNew);
            int cbOld = binSessionOld.length();
            int cbNew = binSessionNew.length();
            if (this.isNoLock() || ofOld == ofNew && cbOld == cbNew && this.getBinaryData(binSessionOld, ofOld, cbOld).equals(this.getBinaryData(binSessionNew, ofNew, cbNew))) {
                int nVersionMax = Math.max(nVersionNew, nVersionOld);
                BinaryWriteBuffer bufNew = new BinaryWriteBuffer(cbNew, cbNew);
                try {
                    bufNew.write(0, binSessionNew);
                    bufNew.getBufferOutput(ofNew + 4).writeLong(this.getMaxTimestamp(4, binSessionOld, binSessionNew));
                    bufNew.getBufferOutput(ofNew + 12).writeInt(nVersionMax);
                    bufNew.getBufferOutput(ofNew + 16).writeLong(this.getMaxTimestamp(16, binSessionOld, binSessionNew));
                }
                catch (IOException e) {
                    throw SessionOptimisticPut.ensureRuntimeException(e);
                }
                binentry.updateBinaryValue(bufNew.toBinary());
                nVersionRet = nVersionMax;
            } else {
                nVersionRet = -nVersionOld;
            }
        }
        return nVersionRet;
    }

    private long getMaxTimestamp(int offset, Binary binSession1, Binary binSession2) {
        return Math.max(SessionOptimisticPut.extractTimestamp(binSession1, offset), SessionOptimisticPut.extractTimestamp(binSession2, offset));
    }

    private Binary getBinaryData(Binary binSession, int of, int cb) {
        return binSession.toBinary(of + 24, cb - (of + 24));
    }

    protected static int extractVersion(Binary binSession) {
        try {
            int of = SessionExpiryExtractor.validateBinarySession(binSession);
            ReadBuffer.BufferInput in = binSession.getBufferInput();
            in.setOffset(of + 12);
            return in.readInt();
        }
        catch (IOException e) {
            throw SessionOptimisticPut.ensureRuntimeException(e);
        }
    }

    private static long extractTimestamp(Binary binSession, int of) {
        try {
            ReadBuffer.BufferInput in = binSession.getBufferInput();
            in.setOffset(of += SessionExpiryExtractor.validateBinarySession(binSession));
            return in.readLong();
        }
        catch (IOException e) {
            throw SessionOptimisticPut.ensureRuntimeException(e);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_binValue = (Binary)ExternalizableHelper.readObject(in);
        this.m_fNoLock = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_binValue);
        out.writeBoolean(this.m_fNoLock);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_binValue = in.readBinary(0);
        this.m_fNoLock = in.readBoolean(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBinary(0, this.m_binValue);
        out.writeBoolean(1, this.m_fNoLock);
    }

    protected boolean isNoLock() {
        return this.m_fNoLock;
    }
}

