/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.CopyOnWriteLongArray;
import com.tangosol.util.LongArray;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

public class StorageVersion {
    protected final AtomicLong m_atomicSubmittedVersion;
    protected final AtomicLong m_atomicCommittedVersion;
    protected final LongArray m_laPartitionVersion = new CopyOnWriteLongArray();
    protected volatile int m_cWaitingThreads = 0;

    public StorageVersion() {
        this.m_atomicCommittedVersion = new AtomicLong(0L);
        this.m_atomicSubmittedVersion = new AtomicLong(0L);
    }

    public long getCommittedVersion() {
        return this.m_atomicCommittedVersion.get();
    }

    public String toString() {
        StringBuilder sbMap = new StringBuilder();
        Iterator iter = this.m_laPartitionVersion.iterator();
        while (iter.hasNext()) {
            PartitionVersion version = (PartitionVersion)iter.next();
            if (version.submissionCounter.get() <= 0L) continue;
            sbMap.append("\n{Partition ").append(iter.getIndex()).append(' ').append(version).append('}');
        }
        return "StorageVersion{SubmittedVersion=" + this.m_atomicSubmittedVersion.get() + ", CommittedVersion=" + this.m_atomicCommittedVersion.get() + ", WaitingThreads=" + this.m_cWaitingThreads + ", PartitionVersions={" + sbMap + "\n}}";
    }

    public long getSubmittedVersion() {
        return this.m_atomicSubmittedVersion.get();
    }

    public boolean isPartitionModified(long lCommittedVersion, int nPart) {
        PartitionVersion version = (PartitionVersion)this.m_laPartitionVersion.get(nPart);
        return version != null && version.isNewerThan(lCommittedVersion);
    }

    public PartitionSet getModifiedPartitions(long lCommittedVersion, PartitionSet partsCheck) {
        LongArray laPartitionVersion = this.m_laPartitionVersion;
        PartitionSet partsSuspect = new PartitionSet(partsCheck.getPartitionCount());
        int nPart = partsCheck.next(0);
        while (nPart >= 0) {
            PartitionVersion version = (PartitionVersion)laPartitionVersion.get(nPart);
            if (version != null && version.isNewerThan(lCommittedVersion)) {
                partsSuspect.add(nPart);
            }
            nPart = partsCheck.next(nPart + 1);
        }
        return partsSuspect;
    }

    public void submit(int nPartition) {
        LongArray laPartitionVersion = this.m_laPartitionVersion;
        PartitionVersion version = (PartitionVersion)laPartitionVersion.get(nPartition);
        if (version == null) {
            version = new PartitionVersion();
            laPartitionVersion.set(nPartition, version);
        }
        version.submissionCounter.incrementAndGet();
        this.m_atomicSubmittedVersion.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(int nPartition) {
        boolean fNotify;
        PartitionVersion version = (PartitionVersion)this.m_laPartitionVersion.get(nPartition);
        Object object = version;
        synchronized (object) {
            long lVersion = this.m_atomicCommittedVersion.incrementAndGet();
            version.committedVersion.set(lVersion);
            long cPendingUpdates = version.submissionCounter.decrementAndGet();
            assert (cPendingUpdates >= 0L);
            fNotify = cPendingUpdates == 0L && this.m_cWaitingThreads > 0;
        }
        if (fNotify) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    public void waitForPendingCommit() {
        long lCommitted;
        long lSubmitted = this.m_atomicSubmittedVersion.get();
        if (lSubmitted == (lCommitted = this.m_atomicCommittedVersion.get())) {
            return;
        }
        this.waitForNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNotify() {
        StorageVersion storageVersion = this;
        synchronized (storageVersion) {
            ++this.m_cWaitingThreads;
            try {
                Blocking.wait(this, 50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                --this.m_cWaitingThreads;
            }
        }
    }

    public long waitForPendingCommit(int nPartition) {
        PartitionVersion version = (PartitionVersion)this.m_laPartitionVersion.get(nPartition);
        if (version == null) {
            return 0L;
        }
        while (version.submissionCounter.get() > 0L) {
            this.waitForNotify();
        }
        return version.committedVersion.get();
    }

    public void dropCommittedVersion(int nPartition) {
        this.m_laPartitionVersion.remove(nPartition);
    }

    private static class PartitionVersion {
        public final AtomicLong committedVersion = new AtomicLong(0L);
        public final AtomicLong submissionCounter = new AtomicLong(0L);

        private PartitionVersion() {
        }

        public boolean isNewerThan(long lCommittedVersion) {
            return this.submissionCounter.get() > 0L || this.committedVersion.get() > lCommittedVersion;
        }

        public String toString() {
            return "PartitionVersion{CommittedVersion=" + this.committedVersion.get() + ", SubmissionCounter=" + this.submissionCounter.get() + "}";
        }
    }
}

