/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.SocketAddressProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class SubstitutionSocketAddressProvider
implements SocketAddressProvider {
    private final SocketAddressProvider f_delegate;
    private final InetAddress f_addr;
    private final int f_nBasePort;
    private final int f_nSubPort;

    public SubstitutionSocketAddressProvider(SocketAddressProvider delegate, InetAddress addr, int nBasePort, int nSubPort) {
        this.f_delegate = delegate;
        this.f_addr = addr;
        this.f_nBasePort = nBasePort;
        this.f_nSubPort = nSubPort;
    }

    @Override
    public SocketAddress getNextAddress() {
        SocketAddress address = this.f_delegate.getNextAddress();
        if (address != null) {
            InetAddress addrInet = InetAddresses.getAddress(address);
            int nPort = InetAddresses.getPort(address);
            int nPortBase = MultiplexedSocketProvider.getBasePort(nPort);
            int nPortSub = MultiplexedSocketProvider.getSubPort(nPort);
            if (addrInet.isAnyLocalAddress()) {
                addrInet = this.f_addr;
            }
            if (nPortBase == 0) {
                nPortBase = this.f_nBasePort;
            }
            if (nPortSub == 0) {
                nPortSub = this.f_nSubPort;
            }
            address = address instanceof InetSocketAddress ? new InetSocketAddress(addrInet, nPort) : new InetSocketAddress32(addrInet, MultiplexedSocketProvider.getPort(nPortBase, nPortSub));
        }
        return address;
    }

    @Override
    public void accept() {
        this.f_delegate.accept();
    }

    @Override
    public void reject(Throwable eCause) {
        this.f_delegate.reject(eCause);
    }

    public String toString() {
        return this.f_delegate.toString();
    }

    @Override
    public int hashCode() {
        return this.f_delegate.hashCode();
    }

    public static ParameterizedBuilder<SocketAddressProvider> createBuilder(final ParameterizedBuilder<SocketAddressProvider> delegate, final InetAddress address, final int nPortBase, final int nPortSub) {
        return new ParameterizedBuilder<SocketAddressProvider>(){

            @Override
            public SocketAddressProvider realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
                return new SubstitutionSocketAddressProvider((SocketAddressProvider)delegate.realize(resolver, loader, listParameters), address, nPortBase, nPortSub);
            }
        };
    }
}

