/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.util.Base;

public abstract class Trint {
    public static final int TRINT14_PRESENT = 8192;
    public static final int TRINT14_MASK = 8191;
    public static final int TRINT14_DOMAIN_SPAN = 8192;
    public static final int TRINT14_MAX_VALUE = 8191;
    public static final int TRINT14_MAX_VARIANCE = 8191;
    public static final int TRINT24_MASK = 0xFFFFFF;
    public static final int TRINT24_DOMAIN_SPAN = 0x1000000;
    public static final int TRINT24_MAX_VALUE = 0xFFFFFF;
    public static final int TRINT24_MAX_VARIANCE = 0x800000;

    public static int makeTrint14(long l) {
        return 0x2000 | (int)l & 0x1FFF;
    }

    public static long translateTrint14(int nTrint, long lCurrent) {
        if (lCurrent < 0L) {
            throw new IllegalArgumentException("Negative current value");
        }
        if ((nTrint & 0x2000) == 0) {
            return -1L;
        }
        long lLo = Math.max(0L, lCurrent - 8191L);
        long lHi = lCurrent;
        nTrint &= 0x1FFF;
        long lBase = lCurrent >>> 13;
        for (int i = -1; i <= 0; ++i) {
            long lGuess = lBase + (long)i << 13 | (long)nTrint;
            if (lGuess < lLo || lGuess > lHi) continue;
            return lGuess;
        }
        return -1L;
    }

    public static void main(String[] asArg) {
        if (0L != Trint.translateTrint14(Trint.makeTrint14(0L), 0L) || 0L != Trint.translateTrint14(Trint.makeTrint14(0L), 1000L)) {
            throw new RuntimeException("Invalid trint for zero");
        }
        long lCurrent = 0L;
        long lIter = 1L;
        while (lCurrent < 2199023254528L) {
            long lTest = lCurrent;
            int nTrint = Trint.makeTrint14(lTest);
            if (lTest != Trint.translateTrint14(nTrint, lCurrent += (long)Base.getRandom().nextInt(8191))) {
                throw new RuntimeException("Invalid trint=" + nTrint + "; lTest=" + lTest + "; lCurrent=" + lCurrent);
            }
            if (lIter % 1000000L == 0L) {
                Base.out(Long.toHexString(lCurrent));
            }
            ++lIter;
        }
    }

    public static int makeTrint24(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public static long translateTrint24(int nTrint, long lCurrent) {
        long lLo = lCurrent - 0x800000L;
        long lHi = lCurrent + 0x800000L;
        nTrint &= 0xFFFFFF;
        long lBase = lCurrent >>> 24;
        for (int i = -1; i <= 1; ++i) {
            long lGuess = lBase + (long)i << 24 | (long)nTrint;
            if (lGuess < lLo || lGuess > lHi) continue;
            if (lGuess < 1L) {
                if (lCurrent > 2048L) {
                    Base.log("Large gap while initializing packet translation; current=" + lCurrent + " packet=" + nTrint + " value=" + lGuess);
                }
                Base.azzert((lGuess += 0x1000000L) >= 1L);
            }
            return lGuess;
        }
        throw new IllegalStateException("translateTrint failed: nTrint=" + nTrint + ", lCurrent=" + lCurrent);
    }
}

