/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.service.DefaultViewDependencies;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ViewBuilder;
import com.tangosol.net.WrapperCacheService;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.partition.PartitionedServiceDispatcher;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.MapListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.ValueExtractor;
import java.util.Enumeration;
import java.util.function.Supplier;

public class ViewCacheService
extends WrapperCacheService {
    public static final String TYPE_VIEW = "ViewCache";
    public static final String KEY_CLUSTER_REGISTRY = "$ViewCacheServiceHandlers";
    public static final String EVENT_INTERCEPTOR_PREFIX = "__CQCInit_";
    protected volatile boolean m_fInitialized;
    protected SegmentedConcurrentMap f_mapCaches = new SegmentedConcurrentMap();
    protected DefaultViewDependencies m_dependencies;

    public ViewCacheService(CacheService service) {
        super(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedCache ensureCache(String sName, ClassLoader loader) {
        this.checkInitialized();
        NamedCache cache = (NamedCache)this.f_mapCaches.get(sName);
        if (cache == null || cache.isReleased() || cache.isDestroyed()) {
            this.f_mapCaches.lock(sName);
            try {
                cache = (NamedCache)this.f_mapCaches.get(sName);
                if (cache == null || cache.isReleased() || cache.isDestroyed()) {
                    ClassLoader loaderBack = NullImplementation.getClassLoader();
                    cache = this.instantiateView(sName, loader, () -> super.ensureCache(sName, loaderBack));
                    this.f_mapCaches.put(sName, cache);
                }
            }
            finally {
                this.f_mapCaches.unlock(sName);
            }
        }
        return cache;
    }

    @Override
    public void releaseCache(NamedCache cache) {
        this.removeCache(cache);
    }

    @Override
    public void destroyCache(NamedCache cache) {
        NamedCache cacheRemoved = this.removeCache(cache);
        if (cacheRemoved != null) {
            cacheRemoved.destroy();
        }
    }

    @Override
    public void setBackingMapManager(BackingMapManager manager) {
        try {
            super.setBackingMapManager(manager);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Enumeration getCacheNames() {
        return new FilterEnumerator(super.getCacheNames(), oCacheName -> this.f_mapCaches.containsKey(oCacheName));
    }

    @Override
    public void start() {
        super.start();
        this.ensureInitialized();
    }

    @Override
    public void stop() {
        this.deregister();
        super.stop();
    }

    @Override
    public void shutdown() {
        this.deregister();
        super.shutdown();
    }

    @Override
    public boolean isRunning() {
        return this.m_fInitialized && super.isRunning();
    }

    @Override
    public DefaultViewDependencies getDependencies() {
        return this.m_dependencies;
    }

    @Override
    public void setDependencies(ServiceDependencies deps) {
        this.m_dependencies = (DefaultViewDependencies)deps;
    }

    @Override
    public String toString() {
        DefaultViewDependencies deps = this.m_dependencies;
        return "ViewCacheService{filter=" + deps.getFilterBuilder() + ", transformer=" + deps.getTransformerBuilder() + ", backService=" + this.getCacheService() + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInitialized() {
        Service service = this.getService();
        if (!this.m_fInitialized || !service.isRunning()) {
            ViewCacheService viewCacheService = this;
            synchronized (viewCacheService) {
                if (!this.m_fInitialized || !service.isRunning()) {
                    throw new IllegalStateException("Service backing the ViewScheme is not running: " + service);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureInitialized() {
        CacheService service = (CacheService)this.getService();
        Enumeration enumer = null;
        if (!this.m_fInitialized && service.isRunning()) {
            ViewCacheService viewCacheService = this;
            synchronized (viewCacheService) {
                if (!this.m_fInitialized && service.isRunning()) {
                    String sServiceName = service.getInfo().getServiceName();
                    this.getInterceptorRegistry().registerEventInterceptor(EVENT_INTERCEPTOR_PREFIX + sServiceName, new CacheSyncEventInterceptor(sServiceName), RegistrationBehavior.IGNORE);
                    enumer = service.getCacheNames();
                    this.m_fInitialized = true;
                }
            }
        }
        while (enumer != null && enumer.hasMoreElements()) {
            String sCacheName = (String)enumer.nextElement();
            if (!this.isViewCache(sCacheName)) continue;
            this.ensureCache(sCacheName, service.getContextClassLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister() {
        if (this.m_fInitialized) {
            ViewCacheService viewCacheService = this;
            synchronized (viewCacheService) {
                if (this.m_fInitialized) {
                    this.getInterceptorRegistry().unregisterEventInterceptor(EVENT_INTERCEPTOR_PREFIX + this.getService().getInfo().getServiceName());
                    this.f_mapCaches.clear();
                    this.m_fInitialized = false;
                }
            }
        }
    }

    protected NamedCache instantiateView(String sCacheName, ClassLoader loader, Supplier<NamedCache> supplierCache) {
        NamedMap cacheView;
        DefaultViewDependencies deps = this.m_dependencies;
        ViewBuilder bldrView = new ViewBuilder(supplierCache);
        boolean fReadOnly = false;
        if (deps != null) {
            Filter filter = null;
            MapListener listener = null;
            ValueExtractor transformer = null;
            ParameterResolver resolver = this.getParameterResolver(sCacheName, loader);
            ParameterizedBuilder<Filter> bldrFilter = deps.getFilterBuilder();
            ParameterizedBuilder<ValueExtractor> bldrTransformer = deps.getTransformerBuilder();
            ParameterizedBuilder<MapListener> bldrListener = deps.getListenerBuilder();
            if (bldrFilter != null) {
                filter = bldrFilter.realize(resolver, loader, null);
            }
            if (bldrListener != null) {
                listener = bldrListener.realize(resolver, loader, null);
            }
            if (bldrTransformer != null) {
                transformer = bldrTransformer.realize(resolver, loader, null);
            }
            fReadOnly = transformer != null || deps.isReadOnly();
            ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)bldrView.filter(filter)).map(transformer)).listener(listener)).withClassLoader(this.getService().getContextClassLoader())).values();
        }
        if ((cacheView = bldrView.build()) instanceof ContinuousQueryCache) {
            ContinuousQueryCache cacheCQC = (ContinuousQueryCache)cacheView;
            cacheCQC.setCacheName(cacheCQC.getCache().getCacheName());
            cacheCQC.setReconnectInterval(deps.getReconnectInterval());
            cacheCQC.setReadOnly(fReadOnly);
        }
        return cacheView;
    }

    protected ParameterResolver getParameterResolver(String sCacheName, ClassLoader loader) {
        ConfigurableCacheFactory ccf = this.getBackingMapManager().getCacheFactory();
        if (ccf instanceof ExtensibleConfigurableCacheFactory) {
            ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)ccf;
            return eccf.getParameterResolver(sCacheName, CacheMapping.class, loader, null);
        }
        ResolvableParameterList resolver = new ResolvableParameterList();
        resolver.add(new Parameter("cache-name", sCacheName));
        resolver.add(new Parameter("class-loader", loader));
        return resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedCache removeCache(NamedCache cache) {
        this.checkInitialized();
        String sCache = cache.getCacheName();
        this.f_mapCaches.lock(sCache);
        try {
            if (this.f_mapCaches.get(sCache) == cache) {
                NamedCache namedCache = (NamedCache)this.f_mapCaches.remove(sCache);
                return namedCache;
            }
        }
        finally {
            this.f_mapCaches.remove(sCache);
        }
        return null;
    }

    protected boolean isViewCache(String sCacheName) {
        ConfigurableCacheFactory ccf = this.getBackingMapManager().getCacheFactory();
        if (ccf instanceof ExtensibleConfigurableCacheFactory) {
            CachingScheme scheme = ((ExtensibleConfigurableCacheFactory)ccf).getCacheConfig().findSchemeByCacheName(sCacheName);
            return scheme != null && TYPE_VIEW.equals(scheme.getServiceType());
        }
        return false;
    }

    protected InterceptorRegistry getInterceptorRegistry() {
        return this.getCacheService().getBackingMapManager().getCacheFactory().getInterceptorRegistry();
    }

    public class CacheSyncEventInterceptor
    implements EventDispatcherAwareInterceptor<CacheLifecycleEvent> {
        protected final String f_sServiceName;

        public CacheSyncEventInterceptor(String sServiceName) {
            this.f_sServiceName = sServiceName;
        }

        @Override
        public void onEvent(CacheLifecycleEvent event) {
            String sCacheName = event.getCacheName();
            if (!ViewCacheService.this.isViewCache(sCacheName)) {
                return;
            }
            ViewCacheService service = ViewCacheService.this;
            switch ((CacheLifecycleEvent.Type)((Object)event.getType())) {
                case CREATED: {
                    service.ensureCache(sCacheName, service.getContextClassLoader());
                    break;
                }
            }
        }

        @Override
        public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
            String sServiceNameThat;
            if (dispatcher instanceof PartitionedServiceDispatcher && Base.equals(this.f_sServiceName, sServiceNameThat = ((PartitionedServiceDispatcher)dispatcher).getService().getInfo().getServiceName())) {
                dispatcher.addEventInterceptor(sIdentifier, this);
            }
        }
    }
}

