/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.net.BackingMapManager;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.partition.ObservableSplittingBackingMap;
import com.tangosol.net.partition.PartitionSplittingBackingMap;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.AbstractKeySetBasedMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObservableSplittingBackingCache
extends ObservableSplittingBackingMap
implements ConfigurableCacheMap {
    protected static final int MAX_PARTITION_MAP_UNIT_FACTOR = 1024;
    protected int m_cHighUnits = -1;
    protected int m_cLowUnits = -1;
    protected int m_cHighUnitsCalibrated = -1;
    protected int m_cLowUnitsCalibrated = -1;
    protected int m_nUnitFactor = -1;
    protected int m_cExpiryDelayMillis = -1;
    protected int m_cHighUnitFairShare;
    protected int m_cLowUnitFairShare;
    protected ConfigurableCacheMap.EvictionPolicy m_policy;
    protected ConfigurableCacheMap.UnitCalculator m_calculator;
    protected ConfigurableCacheMap[] m_acache;
    protected ConfigurableCacheMap.EvictionApprover m_apprvrEvict;
    protected Class m_clzPartitionMap;

    public ObservableSplittingBackingCache(BackingMapManager bmm, String sName) {
        super(new CapacityAwareMap(bmm, sName));
        ((CapacityAwareMap)this.getPartitionSplittingBackingMap()).bind(this);
        this.initializeConfiguredProperties();
    }

    @Override
    public void createPartition(int nPid) {
        ConfigurableCacheMap cache;
        super.createPartition(nPid);
        Map map = super.getPartitionMap(nPid);
        if (map instanceof ConfigurableCacheMap) {
            ConfigurableCacheMap.EvictionApprover approver;
            ConfigurableCacheMap.UnitCalculator calculator;
            ConfigurableCacheMap.EvictionPolicy policy;
            int cExpiryDelayMillis;
            cache = (ConfigurableCacheMap)map;
            int nUnitFactor = this.getPartitionUnitFactor();
            if (nUnitFactor != -1) {
                cache.setUnitFactor(nUnitFactor);
            }
            if ((cExpiryDelayMillis = this.m_cExpiryDelayMillis) != -1) {
                cache.setExpiryDelay(cExpiryDelayMillis);
            }
            if ((policy = this.m_policy) != null) {
                cache.setEvictionPolicy(policy);
            }
            if ((calculator = this.m_calculator) != null) {
                cache.setUnitCalculator(calculator);
            }
            if ((approver = this.m_apprvrEvict) != null) {
                cache.setEvictionApprover(approver);
            }
        } else {
            super.destroyPartition(nPid);
            throw new IllegalStateException("Partition backing map " + (map == null ? "is null" : map.getClass().getName() + " does not implement ConfigurableCacheMap"));
        }
        this.m_cHighUnitFairShare = this.calcUnitFairShare(this.getCalibratedHighUnits());
        this.m_cLowUnitFairShare = this.calcUnitFairShare(this.getCalibratedLowUnits());
        this.claimUnused(cache);
        this.m_acache = null;
    }

    @Override
    public void destroyPartition(int nPid) {
        ConfigurableCacheMap mapInner = (ConfigurableCacheMap)this.getPartitionSplittingBackingMap().getPartitionMap(nPid);
        int cHighUnits = mapInner == null ? 0 : mapInner.getHighUnits();
        super.destroyPartition(nPid);
        this.m_cHighUnitFairShare = this.calcUnitFairShare(this.getCalibratedHighUnits());
        this.m_cLowUnitFairShare = this.calcUnitFairShare(this.getCalibratedLowUnits());
        if (cHighUnits > 0) {
            this.adjustUnits(cHighUnits);
        }
        this.m_acache = null;
    }

    @Override
    public int getUnits() {
        ConfigurableCacheMap[] acache = this.getPartitionCacheArray();
        int cUnits = 0;
        for (ConfigurableCacheMap cache : acache) {
            int cPartitionUnits = cache.getUnits();
            if (cPartitionUnits < 0) continue;
            cUnits = Math.max(0, cUnits) + (int)((long)cPartitionUnits * (long)this.getPartitionUnitFactor() / (long)this.m_nUnitFactor);
        }
        return cUnits;
    }

    @Override
    public int getHighUnits() {
        return this.m_cHighUnits;
    }

    @Override
    public void setHighUnits(int cMax) {
        if (cMax >= 0) {
            if (cMax == this.m_cHighUnits) {
                for (Map map : this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps()) {
                    ConfigurableCacheMap mapPart = (ConfigurableCacheMap)map;
                    mapPart.setHighUnits(mapPart.getHighUnits());
                }
            } else {
                int cPrevHighUnits = this.getCalibratedHighUnits();
                if (this.m_cHighUnits >= 0) {
                    this.m_cHighUnitsCalibrated = -1;
                }
                this.m_cHighUnits = cMax;
                this.m_cHighUnitFairShare = this.calcUnitFairShare(this.getCalibratedHighUnits());
                this.adjustUnits(this.getCalibratedHighUnits() - cPrevHighUnits);
            }
        }
    }

    @Override
    public int getLowUnits() {
        return this.m_cLowUnits;
    }

    @Override
    public void setLowUnits(int cUnits) {
        if (cUnits != this.m_cLowUnits && cUnits >= 0) {
            if (this.m_cLowUnits >= 0) {
                this.m_cLowUnitsCalibrated = -1;
            }
            this.m_cLowUnits = cUnits;
            this.m_cLowUnitFairShare = this.calcUnitFairShare(this.getCalibratedLowUnits());
            this.adjustUnits(0);
        }
    }

    @Override
    public int getUnitFactor() {
        return this.m_nUnitFactor;
    }

    @Override
    public void setUnitFactor(int nFactor) {
        if (nFactor != this.m_nUnitFactor && nFactor > 0) {
            if (nFactor < 1024) {
                ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
                int c = amap.length;
                for (int i = 0; i < c; ++i) {
                    amap[i].setUnitFactor(nFactor);
                }
            }
            this.m_cHighUnits = this.m_cHighUnits * this.m_nUnitFactor / nFactor;
            this.m_cLowUnits = this.m_cLowUnits * this.m_nUnitFactor / nFactor;
            this.m_nUnitFactor = nFactor;
        }
    }

    @Override
    public ConfigurableCacheMap.EvictionPolicy getEvictionPolicy() {
        return this.m_policy;
    }

    @Override
    public void setEvictionPolicy(ConfigurableCacheMap.EvictionPolicy policy) {
        if (policy != this.m_policy) {
            ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
            int c = amap.length;
            for (int i = 0; i < c; ++i) {
                amap[i].setEvictionPolicy(policy);
            }
            this.m_policy = policy;
        }
    }

    @Override
    public boolean evict(Object oKey) {
        return this.getPartitionCache(oKey).evict(oKey);
    }

    @Override
    public void evictAll(Collection colKeys) {
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    @Override
    public void evict() {
        ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
        int c = amap.length;
        for (int i = 0; i < c; ++i) {
            amap[i].evict();
        }
    }

    @Override
    public ConfigurableCacheMap.EvictionApprover getEvictionApprover() {
        return this.m_apprvrEvict;
    }

    @Override
    public void setEvictionApprover(ConfigurableCacheMap.EvictionApprover approver) {
        if (approver != this.m_apprvrEvict) {
            ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
            int c = amap.length;
            for (int i = 0; i < c; ++i) {
                amap[i].setEvictionApprover(approver);
            }
            this.m_apprvrEvict = approver;
        }
    }

    @Override
    public int getExpiryDelay() {
        return this.m_cExpiryDelayMillis;
    }

    @Override
    public synchronized void setExpiryDelay(int cMillis) {
        if (cMillis != this.m_cExpiryDelayMillis) {
            ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
            int c = amap.length;
            for (int i = 0; i < c; ++i) {
                amap[i].setExpiryDelay(cMillis);
                if (i != 0 || amap[i].getExpiryDelay() == cMillis) continue;
                return;
            }
            this.m_cExpiryDelayMillis = cMillis;
        }
    }

    @Override
    public long getNextExpiryTime() {
        ConfigurableCacheMap[] amap;
        long ldtNext = Long.MAX_VALUE;
        for (ConfigurableCacheMap map : amap = this.getPartitionCacheArray()) {
            long ldt = map.getNextExpiryTime();
            if (ldt <= 0L) continue;
            ldtNext = Math.min(ldtNext, ldt);
        }
        return ldtNext == Long.MAX_VALUE ? 0L : ldtNext;
    }

    @Override
    public ConfigurableCacheMap.Entry getCacheEntry(Object oKey) {
        EntrySet.Entry entry = null;
        ConfigurableCacheMap cache = this.getPartitionCache(oKey);
        ConfigurableCacheMap.Entry entryReal = cache.getCacheEntry(oKey);
        if (entryReal != null) {
            entry = (EntrySet.Entry)((EntrySet)this.entrySet()).instantiateEntry(oKey, (Object)null);
            entry.setCacheEntry(entryReal);
        }
        return entry;
    }

    @Override
    public ConfigurableCacheMap.UnitCalculator getUnitCalculator() {
        return this.m_calculator;
    }

    @Override
    public synchronized void setUnitCalculator(ConfigurableCacheMap.UnitCalculator calculator) {
        if (calculator != this.m_calculator) {
            ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
            int c = amap.length;
            for (int i = 0; i < c; ++i) {
                amap[i].setUnitCalculator(calculator);
            }
            this.m_calculator = calculator;
        }
    }

    public Class getPartitionMapType() {
        return this.m_clzPartitionMap;
    }

    @Override
    protected void prepareUpdate(Map mapPartition, Map mapUpdate) {
        ConfigurableCacheMap mapPart = (ConfigurableCacheMap)mapPartition;
        int cHighUnits = mapPart.getHighUnits();
        ConfigurableCacheMap.UnitCalculator unitCalc = mapPart.getUnitCalculator();
        if (unitCalc != null && cHighUnits < this.getHighUnitFairShare()) {
            int cUnits = mapPart.getUnits();
            int cUnitsNew = 0;
            for (Map.Entry entry : mapUpdate.entrySet()) {
                if ((cUnitsNew += unitCalc.calculateUnits(entry.getKey(), entry.getValue())) + cUnits <= cHighUnits) continue;
                this.claimAll(mapPart);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void claimUnused(ConfigurableCacheMap mapRequestor) {
        Map[] aMaps = this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps();
        int cFairHigh = this.getHighUnitFairShare();
        int cFairLow = this.getLowUnitFairShare();
        int cUnits = aMaps.length > 1 ? 0 : cFairHigh;
        boolean fSetLowUnits = cFairLow >= 0;
        int c = aMaps.length;
        for (int i = 0; i < c; ++i) {
            ConfigurableCacheMap mapPart = (ConfigurableCacheMap)aMaps[i];
            if (mapPart == mapRequestor) continue;
            int cUnitsCurr = mapPart.getUnits();
            int cUnitsMax = mapPart.getHighUnits();
            int cUnitsOver = Math.min(cUnitsMax - cUnitsCurr, cUnitsMax - cFairHigh);
            if (cUnitsOver > 0) {
                ConfigurableCacheMap configurableCacheMap = mapPart;
                synchronized (configurableCacheMap) {
                    cUnitsCurr = mapPart.getUnits();
                    cUnitsMax = mapPart.getHighUnits();
                    cUnitsOver = Math.min(cUnitsMax - cUnitsCurr, cUnitsMax - cFairHigh);
                    if (cUnitsOver > 0) {
                        mapPart.setHighUnits(cUnitsMax - cUnitsOver);
                        cUnits += cUnitsOver;
                    }
                }
            }
            if (!fSetLowUnits) continue;
            mapPart.setLowUnits(cFairLow);
        }
        mapRequestor.setHighUnits(cUnits);
        if (fSetLowUnits) {
            mapRequestor.setLowUnits(cFairLow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void claimAll(ConfigurableCacheMap mapRequestor) {
        int cFairHigh = this.getHighUnitFairShare();
        int cUnitsMax = mapRequestor.getHighUnits();
        int cUnitsEntitled = cFairHigh - cUnitsMax;
        int cUnitsClaimed = 0;
        Map[] aMaps = this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps();
        int c = aMaps.length;
        for (int i = 0; cUnitsClaimed < cUnitsEntitled && i < c; ++i) {
            int cUnitsDebit;
            ConfigurableCacheMap mapPart = (ConfigurableCacheMap)aMaps[i];
            if (mapPart == mapRequestor || (cUnitsDebit = mapPart.getHighUnits() - cFairHigh) <= 0) continue;
            ConfigurableCacheMap configurableCacheMap = mapPart;
            synchronized (configurableCacheMap) {
                cUnitsDebit = mapPart.getHighUnits() - cFairHigh;
                if (cUnitsDebit > 0) {
                    mapPart.setHighUnits(cFairHigh);
                }
            }
            cUnitsClaimed += cUnitsDebit;
        }
        if (cUnitsClaimed > 0) {
            mapRequestor.setHighUnits(cUnitsMax + cUnitsClaimed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustUnits(int cUnits) {
        int cFairHigh = this.getHighUnitFairShare();
        int cFairLow = this.getLowUnitFairShare();
        int nSign = cUnits < 0 ? -1 : 1;
        Map[] aMaps = this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps();
        int c = aMaps.length;
        for (int i = 0; i < c; ++i) {
            ConfigurableCacheMap mapPart = (ConfigurableCacheMap)aMaps[i];
            int cMaxUnits = mapPart.getHighUnits();
            int cUnitsDelta = cFairHigh - cMaxUnits;
            if (nSign == 1 && cUnits > 0 && cUnitsDelta >= 0 || nSign == -1 && cUnits < 0 && cUnitsDelta < 0) {
                ConfigurableCacheMap configurableCacheMap = mapPart;
                synchronized (configurableCacheMap) {
                    cMaxUnits = mapPart.getHighUnits();
                    cUnitsDelta = cFairHigh - cMaxUnits;
                    if (nSign == 1 && cUnits > 0 && cUnitsDelta >= 0 || nSign == -1 && cUnits < 0 && cUnitsDelta < 0) {
                        int cUnitsAdjust = Math.min(Math.abs(cUnitsDelta), Math.abs(cUnits)) * nSign;
                        mapPart.setHighUnits(cMaxUnits + cUnitsAdjust);
                        cUnits -= cUnitsAdjust;
                    }
                }
            }
            if (cFairLow < 0) continue;
            mapPart.setLowUnits(cFairLow);
        }
    }

    protected void initializeConfiguredProperties() {
        String sName;
        BackingMapManager bmm = this.getBackingMapManager();
        Map map = bmm.instantiateBackingMap(sName = this.getName() + "$synthetic");
        if (!(map instanceof ConfigurableCacheMap)) {
            throw new IllegalStateException("Partition backing map " + (map == null ? "is null" : map.getClass().getName() + " does not implement ConfigurableCacheMap"));
        }
        ConfigurableCacheMap ccm = (ConfigurableCacheMap)map;
        this.setEvictionPolicy(ccm.getEvictionPolicy());
        this.setExpiryDelay(ccm.getExpiryDelay());
        this.setUnitCalculator(ccm.getUnitCalculator());
        this.setUnitFactor(ccm.getUnitFactor());
        this.setHighUnits(ccm.getHighUnits());
        this.setLowUnits(ccm.getLowUnits());
        this.m_clzPartitionMap = map.getClass();
        bmm.releaseBackingMap(sName, map);
    }

    protected ConfigurableCacheMap getPartitionCache(Object oKey) {
        return (ConfigurableCacheMap)this.getPartitionSplittingBackingMap().getBackingMap(oKey);
    }

    protected ConfigurableCacheMap[] getPartitionCacheArray() {
        ConfigurableCacheMap[] acache = this.m_acache;
        if (acache == null) {
            Map[] amap = this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps();
            int cMaps = amap.length;
            acache = new ConfigurableCacheMap[cMaps];
            for (int i = 0; i < cMaps; ++i) {
                acache[i] = (ConfigurableCacheMap)amap[i];
            }
            this.m_acache = acache;
        }
        return acache;
    }

    protected int getCalibratedHighUnits() {
        int cUnits = this.m_cHighUnitsCalibrated;
        if (cUnits > 0) {
            return cUnits;
        }
        cUnits = this.m_cHighUnits;
        if (cUnits < 0) {
            return -1;
        }
        this.m_cHighUnitsCalibrated = (int)((long)cUnits * (long)this.m_nUnitFactor / (long)this.getPartitionUnitFactor());
        return this.m_cHighUnitsCalibrated;
    }

    protected int getCalibratedLowUnits() {
        int cUnits = this.m_cLowUnitsCalibrated;
        if (cUnits > 0) {
            return cUnits;
        }
        cUnits = this.m_cLowUnits;
        if (cUnits < 0) {
            return -1;
        }
        this.m_cLowUnitsCalibrated = (int)((long)cUnits * (long)this.m_nUnitFactor / (long)this.getPartitionUnitFactor());
        return this.m_cLowUnitsCalibrated;
    }

    protected int getPartitionUnitFactor() {
        return Math.min(1024, this.m_nUnitFactor);
    }

    protected int getLowUnitFairShare() {
        return this.m_cLowUnitFairShare;
    }

    protected int getHighUnitFairShare() {
        return this.m_cHighUnitFairShare;
    }

    protected int calcUnitFairShare(int cUnits) {
        int cConsumers = Math.max(this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps().length, 1);
        return cUnits < 0 ? -1 : cUnits / cConsumers;
    }

    @Override
    protected Set instantiateEntrySet() {
        return new EntrySet();
    }

    protected static class CapacityAwareMap
    extends PartitionSplittingBackingMap {
        protected ObservableSplittingBackingCache m_mapOuter;

        protected CapacityAwareMap(BackingMapManager bmm, String sName) {
            super(bmm, sName);
        }

        @Override
        protected Object putInternal(Map mapPart, Object oKey, Object oValue) {
            this.m_mapOuter.prepareUpdate(mapPart, Collections.singletonMap(oKey, oValue));
            return super.putInternal(mapPart, oKey, oValue);
        }

        @Override
        protected void putAllInternal(Map mapPart, Map map) {
            this.m_mapOuter.prepareUpdate(mapPart, map);
            super.putAllInternal(mapPart, map);
        }

        protected void bind(ObservableSplittingBackingCache mapOuter) {
            this.m_mapOuter = mapOuter;
        }
    }

    public class EntrySet
    extends AbstractKeySetBasedMap.EntrySet {
        public EntrySet() {
            super(ObservableSplittingBackingCache.this);
        }

        protected Map.Entry instantiateEntry(Object oKey, Object oValue) {
            return new Entry(oKey, oValue);
        }

        public class Entry
        extends AbstractKeyBasedMap.EntrySet.Entry
        implements ConfigurableCacheMap.Entry {
            ConfigurableCacheMap.Entry m_entryBacking;

            public Entry(Object oKey, Object oValue) {
                super(EntrySet.this, oKey, oValue);
            }

            @Override
            public Object getValue() {
                return this.getCacheEntry().getValue();
            }

            @Override
            public void touch() {
                this.getCacheEntry().touch();
            }

            @Override
            public int getTouchCount() {
                return this.getCacheEntry().getTouchCount();
            }

            @Override
            public long getLastTouchMillis() {
                return this.getCacheEntry().getLastTouchMillis();
            }

            @Override
            public long getExpiryMillis() {
                return this.getCacheEntry().getExpiryMillis();
            }

            @Override
            public void setExpiryMillis(long lMillis) {
                this.getCacheEntry().setExpiryMillis(lMillis);
            }

            @Override
            public int getUnits() {
                return this.getCacheEntry().getUnits();
            }

            @Override
            public void setUnits(int cUnits) {
                this.getCacheEntry().setUnits(cUnits);
            }

            protected void setCacheEntry(ConfigurableCacheMap.Entry entryBacking) {
                this.m_entryBacking = entryBacking;
            }

            protected ConfigurableCacheMap.Entry getCacheEntry() {
                ConfigurableCacheMap.Entry entry = this.m_entryBacking;
                if (entry == null) {
                    Object oKey = this.getKey();
                    this.m_entryBacking = entry = ObservableSplittingBackingCache.this.getPartitionCache(oKey).getCacheEntry(oKey);
                }
                return entry;
            }
        }
    }
}

