/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.security.StorageAccessAuthorizer;
import com.tangosol.util.BinaryEntry;
import javax.security.auth.Subject;

public class AuditingAuthorizer
implements StorageAccessAuthorizer {
    private final boolean f_fStrict;

    public AuditingAuthorizer() {
        this(false);
    }

    public AuditingAuthorizer(boolean fStrict) {
        this.f_fStrict = fStrict;
    }

    @Override
    public void checkRead(BinaryEntry entry, Subject subject, int nReason) {
        this.logEntryRequest(entry, subject, false, nReason);
        if (subject == null && this.f_fStrict) {
            throw new SecurityException("subject is not provided");
        }
    }

    @Override
    public void checkWrite(BinaryEntry entry, Subject subject, int nReason) {
        this.logEntryRequest(entry, subject, true, nReason);
        if (subject == null && this.f_fStrict) {
            throw new SecurityException("subject is not provided");
        }
    }

    @Override
    public void checkReadAny(BackingMapContext context, Subject subject, int nReason) {
        this.logMapRequest(context, subject, false, nReason);
        if (subject == null && this.f_fStrict) {
            throw new SecurityException("subject is not provided");
        }
    }

    @Override
    public void checkWriteAny(BackingMapContext context, Subject subject, int nReason) {
        this.logMapRequest(context, subject, true, nReason);
        if (subject == null && this.f_fStrict) {
            throw new SecurityException("subject is not provided");
        }
    }

    protected void logEntryRequest(BinaryEntry entry, Subject subject, boolean fWrite, int nReason) {
        Logger.info('\"' + (fWrite ? "Write" : "Read") + "\" request for key=\"" + entry.getKey() + (subject == null ? "\" from unidentified user" : "\" on behalf of " + subject.getPrincipals()) + " caused by \"" + StorageAccessAuthorizer.reasonToString(nReason) + "\"");
    }

    protected void logMapRequest(BackingMapContext context, Subject subject, boolean fWrite, int nReason) {
        Logger.info('\"' + (fWrite ? "Write-any" : "Read-any") + "\" request for cache \"" + context.getCacheName() + '\"' + (subject == null ? " from unidentified user" : " on behalf of " + subject.getPrincipals()) + " caused by \"" + StorageAccessAuthorizer.reasonToString(nReason) + "\"");
    }
}

