/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.net.Service;
import com.tangosol.net.security.IdentityAsserter;
import com.tangosol.net.security.SimpleHandler;
import com.tangosol.net.security.UsernameAndPassword;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class JAASIdentityAsserter
implements IdentityAsserter {
    private String m_sConfigName;

    public JAASIdentityAsserter(String sConfigName) {
        this.m_sConfigName = sConfigName;
    }

    @Override
    public Subject assertIdentity(Object oToken, Service service) throws SecurityException {
        if (oToken instanceof UsernameAndPassword) {
            UsernameAndPassword token = (UsernameAndPassword)oToken;
            SimpleHandler handler = new SimpleHandler(token.getUsername(), token.getPassword());
            try {
                LoginContext ctx = new LoginContext(this.m_sConfigName, handler);
                ctx.login();
                return ctx.getSubject();
            }
            catch (LoginException e) {
                throw new SecurityException(e);
            }
        }
        throw new SecurityException("identity token is unsupported type");
    }
}

