/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.Member;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.NullImplementation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class GUIDHelper {
    public static String generateGUID(int nPartition, long lVersion, long ldt, Member member) {
        return String.format("%d-%x-%x-%d", nPartition, lVersion, ldt, member.getId());
    }

    public static boolean validateGUID(String sGUID) {
        return sGUID != null && sGUID.matches("\\d+-[0-9a-f]+-[0-9a-f]+-\\d+");
    }

    public static int getPartition(String sGUID) {
        return Integer.parseInt(GUIDHelper.parseAttribute(sGUID, 0));
    }

    public static long getVersion(String sGUID) {
        return Long.parseLong(GUIDHelper.parseAttribute(sGUID, 1), 16);
    }

    public static long getServiceJoinTime(String sGUID) {
        return Long.parseLong(GUIDHelper.parseAttribute(sGUID, 2), 16);
    }

    public static int getMemberId(String sGUID) {
        return Integer.parseInt(GUIDHelper.parseAttribute(sGUID, 3));
    }

    public static String getGUID(List<String> listGUID, int nPartition) {
        for (String s : listGUID) {
            if (GUIDHelper.getPartition(s) != nPartition) continue;
            return s;
        }
        return null;
    }

    @Deprecated
    public static String[] resolveNewest(Collection<String> colGUID, int cPartitions) {
        String[] asGUIDNewest = new String[cPartitions];
        for (String sGUID : colGUID) {
            GUIDHelper.evaluateGUID(sGUID, asGUIDNewest, new HashSet<String>(), cPartitions);
        }
        return asGUIDNewest;
    }

    protected static String[] resolveNewest(Map<Member, String[]> mapGUID, Set<String> setPrevGUIDs, int cPartitions) {
        String[] asGUIDNewest = new String[cPartitions];
        for (Map.Entry<Member, String[]> entry : mapGUID.entrySet()) {
            String[] asGUIDThis = entry.getValue();
            int c = asGUIDThis.length;
            for (int i = 0; i < c; ++i) {
                GUIDHelper.evaluateGUID(asGUIDThis[i], asGUIDNewest, setPrevGUIDs, cPartitions);
            }
        }
        return asGUIDNewest;
    }

    protected static void evaluateGUID(String sGUID, String[] asGUIDNewest, Set<String> setPrevGUIDs, int cPartitions) {
        int iPartition = GUIDHelper.getPartition(sGUID);
        if (iPartition >= cPartitions) {
            setPrevGUIDs.add(sGUID);
            return;
        }
        String sGUIDNewest = asGUIDNewest[iPartition];
        if (sGUIDNewest == null || GUIDHelper.getVersion(sGUID) > GUIDHelper.getVersion(sGUIDNewest)) {
            asGUIDNewest[iPartition] = sGUID;
            if (sGUIDNewest != null) {
                setPrevGUIDs.add(sGUIDNewest);
            }
        } else if (GUIDHelper.getVersion(sGUID) < GUIDHelper.getVersion(sGUIDNewest) || GUIDHelper.getMemberId(sGUID) != GUIDHelper.getMemberId(sGUIDNewest)) {
            setPrevGUIDs.add(sGUID);
        }
    }

    public static Map<Integer, String[]> assignStores(Map<Integer, Object[]> mapConstraints, int cDistinctStores) {
        if (mapConstraints == null || mapConstraints.size() == 0) {
            throw new IllegalArgumentException("Unexpected empty map of member to persistent stores");
        }
        HashMap<List<Object>, Integer[]> mapGUIDMembers = new HashMap<List<Object>, Integer[]>();
        HashSet<String> setSharedGUIDs = new HashSet<String>();
        HashSet<String> setAssignedGUIDs = new HashSet<String>();
        Map.Entry<Integer, Object[]>[] aEntry = GUIDHelper.createSortedEntries(mapConstraints);
        int c = aEntry.length;
        for (int i = 0; i < c; ++i) {
            List[] NMemberCurrent = aEntry[i].getKey();
            Object[] aoGUIDs = aEntry[i].getValue();
            List<Object> listGUIDs2 = Arrays.asList(aoGUIDs);
            if (mapGUIDMembers.containsKey(listGUIDs2)) continue;
            ArrayList<Object> listMembers = new ArrayList<Object>();
            listMembers.add(NMemberCurrent);
            for (int j = i + 1; j < c; ++j) {
                int cIntersection;
                Object[] aoGUIDThat = aEntry[j].getValue();
                List<String> listIntersection = GUIDHelper.intersects(aoGUIDs, aoGUIDThat);
                int n = cIntersection = listIntersection == null ? 0 : listIntersection.size();
                if (cIntersection == aoGUIDs.length && cIntersection == aoGUIDThat.length) {
                    listMembers.add(aEntry[j].getKey());
                    if (j != i + 1) continue;
                    ++i;
                    continue;
                }
                if (cIntersection <= 0) continue;
                setSharedGUIDs.addAll(listIntersection);
            }
            mapGUIDMembers.put(listGUIDs2, listMembers.toArray(new Integer[listMembers.size()]));
        }
        List[] alistGUIDs = mapGUIDMembers.keySet().toArray(new List[mapGUIDMembers.size()]);
        Arrays.sort(alistGUIDs, (listThis, listThat) -> listThis.size() - listThat.size());
        HashMap<Integer, List> mapMemberGUID = new HashMap<Integer, List>();
        for (List listGUIDs3 : alistGUIDs) {
            Integer[] aNMembers = (Integer[])mapGUIDMembers.get(listGUIDs3);
            int c2 = listGUIDs3.size();
            int cMembers = aNMembers.length;
            for (int i = 0; i < c2; ++i) {
                String sGUID = (String)listGUIDs3.get(i);
                if (setSharedGUIDs.contains(sGUID) && setAssignedGUIDs.contains(sGUID)) continue;
                Integer NMember = aNMembers[i % cMembers];
                mapMemberGUID.computeIfAbsent(NMember, key -> new ArrayList());
                ((List)mapMemberGUID.get(NMember)).add(sGUID);
                boolean fAdded = setAssignedGUIDs.add(sGUID);
                assert (fAdded) : sGUID + " was assigned twice; 2nd assignment to member " + NMember;
            }
        }
        if (setAssignedGUIDs.size() != cDistinctStores) {
            HashSet setDistinctStores = new HashSet(setAssignedGUIDs.size());
            String sMsg = "Unexpected number of distinct stores; expected " + cDistinctStores + " but found " + setAssignedGUIDs.size();
            StringBuilder sb = new StringBuilder("[");
            mapConstraints.forEach((NMemberId, aoStore) -> {
                sb.append(NMemberId).append("->").append(Arrays.toString(aoStore));
                setDistinctStores.addAll(Arrays.asList(aoStore));
            });
            sb.append(']');
            if (setDistinctStores.size() != setAssignedGUIDs.size()) {
                Logger.err("Unexpected number of distinct stores\nassigned: " + setAssignedGUIDs + "\npassed: " + sb.toString());
                throw new IllegalStateException(sMsg);
            }
            throw new IllegalArgumentException(sMsg);
        }
        return ConverterCollections.getMap(mapMemberGUID, NullImplementation.getConverter(), NullImplementation.getConverter(), listGUIDs -> listGUIDs == null ? null : listGUIDs.toArray(new String[listGUIDs.size()]), NullImplementation.getConverter());
    }

    public static PartitionSet getPartitions(Map<Integer, Object[]> mapStores, int cParts) {
        PartitionSet parts = new PartitionSet(cParts);
        for (Object[] aoStore : mapStores.values()) {
            for (Object oStore : aoStore) {
                parts.add(GUIDHelper.getPartition((String)oStore));
            }
        }
        return parts;
    }

    protected static String parseAttribute(String sGUID, int id) {
        StringTokenizer tokenizer = new StringTokenizer(sGUID, "-");
        for (int i = 0; i < id; ++i) {
            tokenizer.nextToken();
        }
        return tokenizer.nextToken();
    }

    protected static List<String> intersects(Object[] aoLHS, Object[] aoRHS) {
        assert (aoLHS != null && aoRHS != null);
        if (((String)aoLHS[aoLHS.length - 1]).compareTo((String)aoRHS[0]) < 0 || ((String)aoRHS[aoRHS.length - 1]).compareTo((String)aoLHS[0]) < 0) {
            return null;
        }
        ArrayList<String> listIntersect = null;
        int nCompare = aoLHS.length - aoRHS.length;
        Object[] aoLarger = nCompare == 0 || nCompare < 0 ? aoRHS : aoLHS;
        Object[] aoSmaller = nCompare == 0 || nCompare < 0 ? aoLHS : aoRHS;
        int i = 0;
        int j = 0;
        int cMax = aoLarger.length;
        int cMin = aoSmaller.length;
        while (i < cMax) {
            int n = nCompare = j < cMin ? ((Comparable)aoLarger[i]).compareTo(aoSmaller[j]) : -1;
            if (nCompare == 0) {
                if (listIntersect != null) {
                    listIntersect.add((String)aoLarger[i]);
                }
            } else if (listIntersect == null) {
                listIntersect = new ArrayList<String>();
                if (i > 0) {
                    listIntersect.addAll(Arrays.asList(Arrays.copyOfRange(aoLarger, 0, i)));
                }
            }
            if (nCompare <= 0) {
                ++i;
            }
            if (nCompare < 0) continue;
            ++j;
        }
        return listIntersect == null ? Arrays.asList(aoLHS) : (listIntersect.isEmpty() ? null : listIntersect);
    }

    protected static <K> Map.Entry<K, Object[]>[] createSortedEntries(Map<K, Object[]> map) {
        Map.Entry[] aEntry = new Map.Entry[map.size()];
        int i = 0;
        int cArray = aEntry.length;
        for (Map.Entry<K, Object[]> entry : map.entrySet()) {
            Arrays.sort(entry.getValue());
            if (i >= cArray) {
                Map.Entry[] aOld = aEntry;
                aEntry = new Map.Entry[cArray + (cArray >> 3)];
                System.arraycopy(aOld, 0, aEntry, 0, cArray);
                cArray = aEntry.length;
            }
            aEntry[i++] = entry;
        }
        if (i < cArray) {
            Map.Entry[] aOld = aEntry;
            aEntry = new Map.Entry[i];
            System.arraycopy(aOld, 0, aEntry, 0, i);
        }
        return aEntry;
    }

    public static void main(String[] asArg) {
        if (asArg.length > 0) {
            String sGUID = asArg[0];
            Base.out("Partition:  " + GUIDHelper.getPartition(sGUID));
            Base.out("Version:    " + GUIDHelper.getVersion(sGUID));
            Base.out("Timestamp:  " + new Date(GUIDHelper.getServiceJoinTime(sGUID)));
            Base.out("Member ID:  " + GUIDHelper.getMemberId(sGUID));
        } else {
            Base.out("Usage: com.tangosol.persistence.GUIDHelper <GUID>");
        }
    }

    public static class GUIDResolver
    extends Base {
        protected final Map<Member, String[]> f_mapGUID;
        protected int m_cPartitions;
        protected String[] m_asGUIDNewest;
        protected Map<Member, PartitionSet> m_mapResolved;
        protected PartitionSet m_partsUnresolved;
        protected boolean m_fSharedStorage;

        public GUIDResolver(int cPartitions) {
            this.m_cPartitions = cPartitions;
            this.f_mapGUID = new HashMap<Member, String[]>();
        }

        public void registerGUIDs(Member member, String[] asGUID) {
            this.f_mapGUID.put(member, asGUID);
            this.m_mapResolved = null;
        }

        public String getNewestGUID(int nPartition) {
            this.resolve();
            return this.m_asGUIDNewest[nPartition];
        }

        public String[] getNewestGUIDs(PartitionSet parts) {
            this.resolve();
            int cPartitions = parts.cardinality();
            String[] asGUIDNewest = this.m_asGUIDNewest;
            String[] asGUIDResult = new String[cPartitions];
            int cResults = 0;
            int iPart = parts.next(0);
            while (iPart >= 0) {
                String sGUID = asGUIDNewest[iPart];
                if (sGUID != null) {
                    asGUIDResult[cResults++] = sGUID;
                }
                iPart = parts.next(iPart + 1);
            }
            if (cResults < cPartitions) {
                String[] asNew = new String[cResults];
                System.arraycopy(asGUIDResult, 0, asNew, 0, cResults);
                asGUIDResult = asNew;
            }
            return asGUIDResult;
        }

        public PartitionSet getUnresolvedPartitions() {
            this.resolve();
            return this.m_partsUnresolved;
        }

        public Map<Integer, String[]> getMemberGUIDs() {
            return ConverterCollections.getMap(this.f_mapGUID, Member::getId, NullImplementation.getConverter(), NullImplementation.getConverter(), NullImplementation.getConverter());
        }

        public boolean isSharedStorage() {
            this.resolve();
            return this.m_fSharedStorage;
        }

        public Map<Member, PartitionSet> resolve() {
            Map<Member, PartitionSet> mapResolved = this.m_mapResolved;
            if (mapResolved != null) {
                return mapResolved;
            }
            int cPartitions = this.m_cPartitions;
            PartitionSet partsResolved = new PartitionSet(cPartitions);
            HashSet<String> setPrevGUIDs = new HashSet<String>();
            String[] asGUIDNewest = GUIDHelper.resolveNewest(this.f_mapGUID, setPrevGUIDs, cPartitions);
            HashMap<Member, PartitionSet> mapOwnership = new HashMap<Member, PartitionSet>();
            for (Map.Entry<Member, String[]> entry : this.f_mapGUID.entrySet()) {
                Member member = entry.getKey();
                String[] asGUID = entry.getValue();
                PartitionSet parts = new PartitionSet(cPartitions);
                for (String sGUID : asGUID) {
                    if (setPrevGUIDs.contains(sGUID)) continue;
                    parts.add(GUIDHelper.getPartition(sGUID));
                }
                mapOwnership.put(member, parts);
                partsResolved.add(parts);
            }
            boolean fSharedStorage = true;
            for (PartitionSet partsMember : mapOwnership.values()) {
                if (partsMember.equals(partsResolved)) continue;
                fSharedStorage = false;
                break;
            }
            this.m_mapResolved = mapOwnership;
            this.m_partsUnresolved = partsResolved.invert();
            this.m_asGUIDNewest = asGUIDNewest;
            this.m_fSharedStorage = fSharedStorage;
            return mapOwnership;
        }
    }
}

