/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.SimpleAdapter;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.LiteMap;
import java.util.Iterator;
import java.util.Map;

public class QNameAdapter
extends SimpleAdapter.StringAdapter {
    private Map m_mapNms = new LiteMap();

    public QNameAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
        XmlElement xmlVS = xml.getElement("value-space");
        if (xmlVS != null) {
            Map mapNms = this.m_mapNms;
            Iterator iter = xmlVS.getElements("xmlns");
            while (iter.hasNext()) {
                XmlElement xmlNms = (XmlElement)iter.next();
                String sNmsPrefix = xmlNms.getSafeElement("prefix").getString(null);
                String sNmsUri = xmlNms.getSafeElement("uri").getString(null);
                mapNms.put(sNmsPrefix, sNmsUri);
            }
        }
    }

    @Override
    public Object fromXml(XmlElement xml) {
        String sPrefix;
        String sUri;
        String sValue = (String)super.fromXml(xml);
        int of = sValue.indexOf(58);
        if (of > 0 && (sUri = XmlHelper.getNamespaceUri(xml, sPrefix = sValue.substring(0, of))) != null) {
            this.m_mapNms.put(sPrefix, sUri);
        }
        return sValue;
    }

    @Override
    public XmlElement toXml(Object o) {
        String sPrefix;
        String sUri;
        XmlElement xml = super.toXml(o);
        String sValue = xml.getString();
        int of = sValue.indexOf(58);
        if (of > 0 && (sUri = (String)this.m_mapNms.get(sPrefix = sValue.substring(0, of))) != null) {
            XmlHelper.ensureNamespace(xml, sPrefix, sUri);
        }
        return xml;
    }

    public boolean isValidQName(String sValue) {
        int of = sValue.indexOf(58);
        if (of > 0) {
            String sPrefix = sValue.substring(0, of);
            return this.m_mapNms.containsKey(sPrefix);
        }
        return true;
    }
}

