/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.io.Base64OutputStream;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class SimpleValue
extends ExternalizableHelper
implements XmlValue,
Cloneable,
ExternalizableLite,
PortableObject {
    private static final Binary NO_BYTES = Binary.NO_BINARY;
    private static final BigDecimal DEC_ZERO = new BigDecimal("0");
    private static final Date DFT_DATE = new Date(0L);
    private static final Time DFT_TIME = new Time(0L);
    private static final Timestamp DFT_DATETIME = new Timestamp(0L);
    private XmlElement m_parent;
    private Object m_oValue;
    private boolean m_fAttribute;
    private boolean m_fMutable = true;

    public SimpleValue() {
        this(null, false, false);
    }

    public SimpleValue(Object oValue) {
        this(oValue, false, false);
    }

    public SimpleValue(Object oValue, boolean fAttribute) {
        this(oValue, fAttribute, false);
    }

    public SimpleValue(Object oValue, boolean fAttribute, boolean fReadOnly) {
        if (!(oValue == null || oValue instanceof Boolean || oValue instanceof Integer || oValue instanceof Long || oValue instanceof Double || oValue instanceof BigDecimal || oValue instanceof String || oValue instanceof Binary || oValue instanceof Date || oValue instanceof Time || oValue instanceof Timestamp)) {
            throw new IllegalArgumentException("Unsupported type: " + oValue.getClass().getName());
        }
        if (fAttribute && oValue == null) {
            oValue = "";
        }
        this.setAttribute(fAttribute);
        this.setInternalValue(oValue);
        this.setMutable(!fReadOnly);
    }

    @Override
    public boolean getBoolean() {
        return this.getBoolean(false);
    }

    @Override
    public boolean getBoolean(boolean fDefault) {
        Boolean bool = (Boolean)this.ensureType(1);
        return bool == null ? fDefault : bool;
    }

    @Override
    public void setBoolean(boolean fVal) {
        this.setInternalValue(fVal ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public int getInt() {
        return this.getInt(0);
    }

    @Override
    public int getInt(int nDefault) {
        Integer I = (Integer)this.ensureType(2);
        return I == null ? nDefault : I;
    }

    @Override
    public void setInt(int nVal) {
        this.setInternalValue(nVal);
    }

    @Override
    public long getLong() {
        return this.getLong(0L);
    }

    @Override
    public long getLong(long lDefault) {
        Long L = (Long)this.ensureType(3);
        return L == null ? lDefault : L;
    }

    @Override
    public void setLong(long lVal) {
        this.setInternalValue(lVal);
    }

    @Override
    public double getDouble() {
        return this.getDouble(0.0);
    }

    @Override
    public double getDouble(double dflDefault) {
        Double D = (Double)this.ensureType(4);
        return D == null ? dflDefault : D;
    }

    @Override
    public void setDouble(double dflVal) {
        this.setInternalValue(new Double(dflVal));
    }

    @Override
    public BigDecimal getDecimal() {
        return this.getDecimal(DEC_ZERO);
    }

    @Override
    public BigDecimal getDecimal(BigDecimal decDefault) {
        BigDecimal dec = (BigDecimal)this.ensureType(5);
        return dec == null ? decDefault : dec;
    }

    @Override
    public void setDecimal(BigDecimal decVal) {
        this.setInternalValue(decVal);
    }

    @Override
    public String getString() {
        return this.getString("");
    }

    @Override
    public String getString(String sDefault) {
        String s = (String)this.ensureType(6);
        return s == null ? sDefault : s;
    }

    @Override
    public void setString(String sVal) {
        this.setInternalValue(sVal);
    }

    @Override
    public Binary getBinary() {
        return this.getBinary(NO_BYTES);
    }

    @Override
    public Binary getBinary(Binary binDefault) {
        Binary bin = (Binary)this.ensureType(7);
        return bin == null ? binDefault : bin;
    }

    @Override
    public void setBinary(Binary binVal) {
        this.setInternalValue(binVal);
    }

    @Override
    public Date getDate() {
        return this.getDate(DFT_DATE);
    }

    @Override
    public Date getDate(Date dtDefault) {
        Date dt = (Date)this.ensureType(8);
        return dt == null ? dtDefault : dt;
    }

    @Override
    public void setDate(Date dtVal) {
        this.setInternalValue(dtVal);
    }

    @Override
    public Time getTime() {
        return this.getTime(DFT_TIME);
    }

    @Override
    public Time getTime(Time dtDefault) {
        Time dt = (Time)this.ensureType(9);
        return dt == null ? dtDefault : dt;
    }

    @Override
    public void setTime(Time dtVal) {
        this.setInternalValue(dtVal);
    }

    @Override
    public Timestamp getDateTime() {
        return this.getDateTime(DFT_DATETIME);
    }

    @Override
    public Timestamp getDateTime(Timestamp dtDefault) {
        Timestamp dt = (Timestamp)this.ensureType(10);
        return dt == null ? dtDefault : dt;
    }

    @Override
    public void setDateTime(Timestamp dtVal) {
        this.setInternalValue(dtVal);
    }

    @Override
    public Object getValue() {
        return this.getInternalValue();
    }

    @Override
    public XmlElement getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(XmlElement element) {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException("value \"" + this + "\" is not mutable");
        }
        if (element == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        XmlElement xmlParent = this.getParent();
        if (xmlParent != null && xmlParent != element) {
            throw new IllegalStateException("parent already set");
        }
        this.m_parent = element;
    }

    @Override
    public boolean isEmpty() {
        Object o = this.getInternalValue();
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        return o instanceof Binary && ((Binary)o).length() == 0;
    }

    @Override
    public boolean isAttribute() {
        return this.m_fAttribute;
    }

    @Override
    public boolean isContent() {
        return !this.m_fAttribute;
    }

    @Override
    public boolean isMutable() {
        if (!this.m_fMutable) {
            return false;
        }
        XmlElement parent = this.getParent();
        return parent == null || parent.isMutable();
    }

    @Override
    public void writeValue(PrintWriter out, boolean fPretty) {
        Object o = this.getInternalValue();
        if (this.isAttribute()) {
            if (o instanceof Binary) {
                try {
                    Base64OutputStream stream = new Base64OutputStream(out, fPretty);
                    ((Binary)o).writeTo(stream);
                    ((OutputStream)stream).close();
                }
                catch (IOException e) {
                    throw SimpleValue.ensureRuntimeException(e);
                }
            } else {
                out.print(XmlHelper.quote(o.toString()));
            }
        } else if (o instanceof String) {
            out.print(XmlHelper.encodeContent((String)o, true));
        } else if (o instanceof Binary) {
            try {
                Base64OutputStream stream = new Base64OutputStream(out, fPretty);
                ((Binary)o).writeTo(stream);
                ((OutputStream)stream).close();
            }
            catch (IOException e) {
                throw SimpleValue.ensureRuntimeException(e);
            }
        } else if (o != null) {
            out.print(o.toString());
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        if (this.m_oValue != null || this.m_fAttribute || !this.m_fMutable) {
            throw new NotActiveException();
        }
        switch (in.readByte()) {
            case 0: {
                break;
            }
            case 1: {
                this.m_oValue = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 2: {
                this.m_oValue = SimpleValue.readInt(in);
                break;
            }
            case 3: {
                this.m_oValue = SimpleValue.readLong(in);
                break;
            }
            case 4: {
                this.m_oValue = new Double(in.readDouble());
                break;
            }
            case 5: {
                this.m_oValue = SimpleValue.readBigDecimal(in);
                break;
            }
            case 6: {
                this.m_oValue = SimpleValue.readUTF(in);
                break;
            }
            case 7: {
                Binary bin = new Binary();
                bin.readExternal(in);
                this.m_oValue = bin;
                break;
            }
            case 8: {
                this.m_oValue = SimpleValue.readDate(in);
                break;
            }
            case 9: {
                this.m_oValue = SimpleValue.readTime(in);
                break;
            }
            case 10: {
                this.m_oValue = SimpleValue.readTimestamp(in);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        this.m_fAttribute = in.readBoolean();
        this.m_fMutable = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        Object o = this.m_oValue;
        if (o == null) {
            out.writeByte(0);
        } else if (o instanceof String) {
            out.writeByte(6);
            SimpleValue.writeUTF(out, (String)o);
        } else if (o instanceof Boolean) {
            out.writeByte(1);
            out.writeBoolean((Boolean)o);
        } else if (o instanceof Integer) {
            out.writeByte(2);
            SimpleValue.writeInt(out, (int)((Integer)o));
        } else if (o instanceof Long) {
            out.writeByte(3);
            SimpleValue.writeLong(out, (long)((Long)o));
        } else if (o instanceof Double) {
            out.writeByte(4);
            out.writeDouble((Double)o);
        } else if (o instanceof BigDecimal) {
            out.writeByte(5);
            SimpleValue.writeBigDecimal(out, (BigDecimal)o);
        } else if (o instanceof Binary) {
            out.writeByte(7);
            ((Binary)o).writeExternal(out);
        } else if (o instanceof Date) {
            out.writeByte(8);
            SimpleValue.writeDate(out, (Date)o);
        } else if (o instanceof Time) {
            out.writeByte(9);
            SimpleValue.writeTime(out, (Time)o);
        } else if (o instanceof Timestamp) {
            out.writeByte(10);
            SimpleValue.writeTimestamp(out, (Timestamp)o);
        } else {
            throw new IOException("unsupported type to write: " + o.getClass().getName());
        }
        out.writeBoolean(this.m_fAttribute);
        out.writeBoolean(this.m_fMutable);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        if (this.m_oValue != null || this.m_fAttribute || !this.m_fMutable) {
            throw new NotActiveException();
        }
        switch (in.readByte(0)) {
            case 0: {
                break;
            }
            case 1: {
                this.m_oValue = in.readBoolean(1) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 2: {
                this.m_oValue = in.readInt(1);
                break;
            }
            case 3: {
                this.m_oValue = in.readLong(1);
                break;
            }
            case 4: {
                this.m_oValue = new Double(in.readDouble(1));
                break;
            }
            case 5: {
                this.m_oValue = in.readBigDecimal(1);
                break;
            }
            case 6: {
                this.m_oValue = in.readString(1);
                break;
            }
            case 7: {
                this.m_oValue = in.readBinary(1);
                break;
            }
            case 8: {
                this.m_oValue = in.readDate(1);
                break;
            }
            case 9: {
                this.m_oValue = in.readRawTime(1).toSqlTime();
                break;
            }
            case 10: {
                this.m_oValue = in.readRawDateTime(1).toSqlTimestamp();
                break;
            }
            default: {
                throw new IOException();
            }
        }
        this.m_fAttribute = in.readBoolean(2);
        this.m_fMutable = in.readBoolean(3);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        Object o = this.m_oValue;
        if (o == null) {
            out.writeByte(0, (byte)0);
        } else if (o instanceof String) {
            out.writeByte(0, (byte)6);
            out.writeString(1, (String)o);
        } else if (o instanceof Boolean) {
            out.writeByte(0, (byte)1);
            out.writeBoolean(1, (Boolean)o);
        } else if (o instanceof Integer) {
            out.writeByte(0, (byte)2);
            out.writeInt(1, (Integer)o);
        } else if (o instanceof Long) {
            out.writeByte(0, (byte)3);
            out.writeLong(1, (Long)o);
        } else if (o instanceof Double) {
            out.writeByte(0, (byte)4);
            out.writeDouble(1, (Double)o);
        } else if (o instanceof BigDecimal) {
            out.writeByte(0, (byte)5);
            out.writeBigDecimal(1, (BigDecimal)o);
        } else if (o instanceof Binary) {
            out.writeByte(0, (byte)7);
            out.writeBinary(1, (Binary)o);
        } else if (o instanceof Date) {
            out.writeByte(0, (byte)8);
            out.writeDate(1, (Date)o);
        } else if (o instanceof Time) {
            out.writeByte(0, (byte)9);
            out.writeTime(1, (Time)o);
        } else if (o instanceof Timestamp) {
            out.writeByte(0, (byte)10);
            out.writeDateTime(1, (Timestamp)o);
        } else {
            throw new IOException("unsupported type to write: " + o.getClass().getName());
        }
        out.writeBoolean(2, this.m_fAttribute);
        out.writeBoolean(3, this.m_fMutable);
    }

    protected Object getInternalValue() {
        return this.m_oValue;
    }

    protected void setInternalValue(Object oValue) {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException("value \"" + this + "\" is not mutable");
        }
        if (this.isAttribute() && oValue == null) {
            throw new IllegalArgumentException("attribute value must not be null");
        }
        this.m_oValue = oValue;
    }

    protected Object ensureType(int nType) {
        Object oNew;
        Object oOld = this.getInternalValue();
        if (oOld != (oNew = this.convert(oOld, nType)) && this.isMutable()) {
            this.setInternalValue(oNew);
        }
        return oNew;
    }

    protected Object convert(Object o, int nType) {
        try {
            return XmlHelper.convert(o, nType);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected void setAttribute(boolean fAttribute) {
        this.m_fAttribute = fAttribute;
    }

    protected void setMutable(boolean fMutable) {
        this.m_fMutable = fMutable;
    }

    @Override
    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return XmlHelper.hashValue(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof XmlValue)) {
            return false;
        }
        return XmlHelper.equalsValue(this, (XmlValue)o);
    }

    @Override
    public Object clone() {
        SimpleValue that;
        try {
            that = (SimpleValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw SimpleValue.ensureRuntimeException(e);
        }
        Object oValue = that.m_oValue;
        if (oValue instanceof Date) {
            that.m_oValue = ((Date)oValue).clone();
        } else if (oValue instanceof Time) {
            that.m_oValue = ((Time)oValue).clone();
        } else if (oValue instanceof Timestamp) {
            that.m_oValue = ((Timestamp)oValue).clone();
        }
        that.m_parent = null;
        that.m_fMutable = true;
        return that;
    }
}

