/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.EnumerationIterator;
import com.tangosol.util.NullImplementation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class ChainedEnumerator
extends Base
implements Enumeration,
Iterator {
    protected List m_listIter = new ArrayList();
    protected int m_iNextIter;
    protected Iterator m_iterCurrent;

    public ChainedEnumerator() {
    }

    public ChainedEnumerator(Enumeration enmrFirst) {
        this.addEnumeration(enmrFirst);
    }

    public ChainedEnumerator(Iterator iterator) {
        this.addIterator(iterator);
    }

    public ChainedEnumerator(Enumeration enmrFirst, Enumeration enmrSecond) {
        this.addEnumeration(enmrFirst);
        this.addEnumeration(enmrSecond);
    }

    public ChainedEnumerator(Iterator iterFirst, Iterator iterSecond) {
        this.addIterator(iterFirst);
        this.addIterator(iterSecond);
    }

    public ChainedEnumerator(Enumeration[] aEnum) {
        int c = aEnum.length;
        for (int i = 0; i < c; ++i) {
            this.addEnumeration(aEnum[i]);
        }
    }

    public ChainedEnumerator(Iterator[] aIterator) {
        int c = aIterator.length;
        for (int i = 0; i < c; ++i) {
            this.addIterator(aIterator[i]);
        }
    }

    public void addEnumeration(Enumeration enmr) {
        if (enmr != null) {
            this.m_listIter.add(enmr instanceof Iterator ? (Iterator)((Object)enmr) : new EnumerationIterator(enmr));
        }
    }

    public void addIterator(Iterator iterator) {
        if (iterator != null) {
            this.m_listIter.add(iterator);
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.getIterator().hasNext();
    }

    public Object nextElement() {
        return this.getIterator().next();
    }

    @Override
    public boolean hasNext() {
        return this.getIterator().hasNext();
    }

    public Object next() {
        return this.getIterator().next();
    }

    @Override
    public void remove() {
        Iterator iter = this.getRecentIterator();
        if (iter == null) {
            throw new IllegalStateException();
        }
        iter.remove();
    }

    protected Iterator getIterator() {
        Iterator iter = this.m_iterCurrent;
        if (iter == null || !iter.hasNext()) {
            int iIter = this.m_iNextIter;
            int cIter = this.m_listIter.size();
            do {
                if (iIter < cIter) continue;
                iter = NullImplementation.getIterator();
                break;
            } while (!(iter = (Iterator)this.m_listIter.get(iIter++)).hasNext());
            this.m_iNextIter = iIter;
            this.m_iterCurrent = iter;
        }
        return iter;
    }

    protected Iterator getRecentIterator() {
        return this.m_iterCurrent;
    }
}

