/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Holder;
import com.oracle.coherence.common.base.NaturalHasher;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.util.processor.CacheProcessors;
import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.QueryMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiFunction;

public abstract class ConverterCollections {
    public static <F, T> Iterator<T> getIterator(Iterator<F> iter, Converter<F, T> conv) {
        return new ConverterEnumerator<F, T>(iter, conv);
    }

    public static <F, T> ConverterCollection<F, T> getCollection(Collection<F> col, Converter<F, T> convUp, Converter<T, F> convDown) {
        return new ConverterCollection<F, T>(col, convUp, convDown);
    }

    public static <F, T> ConverterSet<F, T> getSet(Set<F> set, Converter<F, T> convUp, Converter<T, F> convDown) {
        return new ConverterSet<F, T>(set, convUp, convDown);
    }

    public static <F, T> ConverterSortedSet<F, T> getSortedSet(SortedSet<F> set, Converter<F, T> convUp, Converter<T, F> convDown) {
        return new ConverterSortedSet<F, T>(set, convUp, convDown);
    }

    public static <F, T> ConverterList<F, T> getList(List<F> list, Converter<F, T> convUp, Converter<T, F> convDown) {
        return new ConverterList<F, T>(list, convUp, convDown);
    }

    public static <F, T> ConverterListIterator<F, T> getListIterator(ListIterator<F> iter, Converter<F, T> convUp, Converter<T, F> convDown) {
        return new ConverterListIterator<F, T>(iter, convUp, convDown);
    }

    public static <FK, TK, FV, TV> ConverterMap<FK, TK, FV, TV> getMap(Map<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterMap<FK, TK, FV, TV>(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static <FK, TK, FV, TV> ConverterSortedMap<FK, TK, FV, TV> getSortedMap(SortedMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterSortedMap<FK, TK, FV, TV>(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static <FK, TK, FV, TV> ConverterEntrySet<FK, TK, FV, TV> getEntrySet(Collection<Map.Entry<FK, FV>> set, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterEntrySet<FK, TK, FV, TV>(set, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static <FK, TK, FV, TV> ConverterEntry<FK, TK, FV, TV> getEntry(Map.Entry<FK, FV> entry, Converter<FK, TK> convKeyUp, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterEntry<FK, TK, FV, TV>(entry, convKeyUp, convValUp, convValDown);
    }

    public static <F, T> ConverterHolder<F, T> getConverterHolder(F value, Converter<F, T> convUp) {
        return new ConverterHolder<F, T>(value, convUp);
    }

    public static <F, T> LongArray<T> getLongArray(LongArray<F> la, Converter<F, T> convUp, Converter<T, F> convDown) {
        return new ConverterLongArray<F, T>(la, convUp, convDown);
    }

    public static <FK, TK, FV, TV> ConcurrentMap<TK, TV> getConcurrentMap(ConcurrentMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterConcurrentMap<FK, TK, FV, TV>(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static <FK, TK, FV, TV> InvocableMap<TK, TV> getInvocableMap(InvocableMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterInvocableMap<FK, TK, FV, TV>(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static <FK, TK, FV, TV> ObservableMap<TK, TV> getObservableMap(ObservableMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterObservableMap<FK, TK, FV, TV>(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static <FK, TK, FV, TV> QueryMap<TK, TV> getQueryMap(QueryMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterQueryMap<FK, TK, FV, TV>(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static <FK, TK, FV, TV> CacheMap<TK, TV> getCacheMap(CacheMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterCacheMap<FK, TK, FV, TV>(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static <FK, FV, TK, TV> NamedCache<TK, TV> getNamedCache(NamedCache<FK, FV> cache, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
        return new ConverterNamedCache<FK, TK, FV, TV>(cache, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static MapEvent getMapEvent(ObservableMap map, MapEvent event, Converter convKey, Converter convVal) {
        return new ConverterMapEvent(map, event, convKey, convVal);
    }

    public static MapEvent getMapEvent(ObservableMap map, MapEvent event, Converter convKey, Converter convVal, BackingMapManagerContext context) {
        return new ConverterMapEvent(map, event, convKey, convVal, context);
    }

    public static MapListener getMapListener(ObservableMap map, MapListener listener, Converter convKey, Converter convVal) {
        ConverterMapListener listenerConv = map instanceof NamedCache ? new ConverterCacheListener((NamedCache)map, listener, convKey, convVal) : new ConverterMapListener(map, listener, convKey, convVal);
        return listener instanceof MapListenerSupport.SynchronousListener ? new MapListenerSupport.WrapperSynchronousListener(listenerConv) : listenerConv;
    }

    public static Object[] convertArray(Object[] ao, Converter conv) {
        int c = ao.length;
        for (int i = 0; i < c; ++i) {
            ao[i] = conv.convert(ao[i]);
        }
        return ao;
    }

    public static Object[] convertArray(Object[] aoSrc, Converter conv, Object[] aoDest) {
        int cSrc = aoSrc.length;
        int cDest = aoDest.length;
        if (cSrc > cDest) {
            cDest = cSrc;
            aoDest = (Object[])Array.newInstance(aoDest.getClass().getComponentType(), cDest);
        }
        if (cDest > cSrc) {
            aoDest[cSrc] = null;
        }
        for (int i = 0; i < cSrc; ++i) {
            aoDest[i] = conv.convert(aoSrc[i]);
        }
        return aoDest;
    }

    public static <F, I, T> Converter<F, T> combine(Converter<F, I> converter1, Converter<I, T> converter2) {
        return from -> converter2.convert(converter1.convert(from));
    }

    public static class ConverterLongArray<F, T>
    implements LongArray<T> {
        protected final LongArray<F> f_laDelegate;
        protected final Converter<F, T> f_convUp;
        protected final Converter<T, F> f_convDown;

        public ConverterLongArray(LongArray<F> laDelegate, Converter<F, T> convUp, Converter<T, F> convDown) {
            this.f_laDelegate = laDelegate;
            this.f_convUp = convUp;
            this.f_convDown = convDown;
        }

        @Override
        public T get(long lIndex) {
            return this.f_convUp.convert(this.f_laDelegate.get(lIndex));
        }

        @Override
        public long floorIndex(long lIndex) {
            return this.f_laDelegate.floorIndex(lIndex);
        }

        @Override
        public T floor(long lIndex) {
            return this.f_convUp.convert(this.f_laDelegate.floor(lIndex));
        }

        @Override
        public long ceilingIndex(long lIndex) {
            return this.f_laDelegate.ceilingIndex(lIndex);
        }

        @Override
        public T ceiling(long lIndex) {
            return this.f_convUp.convert(this.f_laDelegate.ceiling(lIndex));
        }

        @Override
        public T set(long lIndex, T oValue) {
            return this.f_convUp.convert(this.f_laDelegate.set(lIndex, this.f_convDown.convert(oValue)));
        }

        @Override
        public long add(T oValue) {
            return this.f_laDelegate.add(this.f_convDown.convert(oValue));
        }

        @Override
        public boolean exists(long lIndex) {
            return this.f_laDelegate.exists(lIndex);
        }

        @Override
        public T remove(long lIndex) {
            return this.f_convUp.convert(this.f_laDelegate.remove(lIndex));
        }

        @Override
        public void remove(long lIndexFrom, long lIndexTo) {
            this.f_laDelegate.remove(lIndexFrom, lIndexTo);
        }

        @Override
        public boolean contains(T oValue) {
            return this.f_laDelegate.contains(this.f_convDown.convert(oValue));
        }

        @Override
        public void clear() {
            this.f_laDelegate.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.f_laDelegate.isEmpty();
        }

        @Override
        public int getSize() {
            return this.f_laDelegate.getSize();
        }

        @Override
        public LongArray.Iterator<T> iterator() {
            return this.instantiateIterator((LongArray.Iterator<F>)this.f_laDelegate.iterator());
        }

        @Override
        public LongArray.Iterator<T> iterator(long lIndex) {
            return this.instantiateIterator(this.f_laDelegate.iterator(lIndex));
        }

        @Override
        public LongArray.Iterator<T> reverseIterator() {
            return this.instantiateIterator(this.f_laDelegate.reverseIterator());
        }

        @Override
        public LongArray.Iterator<T> reverseIterator(long lIndex) {
            return this.instantiateIterator(this.f_laDelegate.reverseIterator(lIndex));
        }

        @Override
        public long getFirstIndex() {
            return this.f_laDelegate.getFirstIndex();
        }

        @Override
        public long getLastIndex() {
            return this.f_laDelegate.getLastIndex();
        }

        @Override
        public long indexOf(T oValue) {
            return this.f_laDelegate.indexOf(this.f_convDown.convert(oValue));
        }

        @Override
        public long indexOf(T oValue, long lIndex) {
            return this.f_laDelegate.indexOf(this.f_convDown.convert(oValue), lIndex);
        }

        @Override
        public long lastIndexOf(T oValue) {
            return this.f_laDelegate.lastIndexOf(this.f_convDown.convert(oValue));
        }

        @Override
        public long lastIndexOf(T oValue, long lIndex) {
            return this.f_laDelegate.lastIndexOf(this.f_convDown.convert(oValue), lIndex);
        }

        @Override
        public LongArray<T> clone() {
            return new ConverterLongArray<F, T>(this.f_laDelegate.clone(), this.f_convUp, this.f_convDown);
        }

        protected LongArray.Iterator<T> instantiateIterator(LongArray.Iterator<F> iter) {
            return new ConverterLongArrayIterator(iter);
        }

        protected class ConverterLongArrayIterator
        extends ConverterEnumerator<F, T>
        implements LongArray.Iterator<T> {
            public ConverterLongArrayIterator(LongArray.Iterator<F> iter) {
                super(iter, ConverterLongArray.this.f_convUp);
            }

            @Override
            public long getIndex() {
                return ((LongArray.Iterator)this.m_iter).getIndex();
            }

            @Override
            public T getValue() {
                return this.m_conv.convert(((LongArray.Iterator)this.m_iter).getValue());
            }

            @Override
            public T setValue(T oValue) {
                return this.m_conv.convert(((LongArray.Iterator)this.m_iter).setValue(ConverterLongArray.this.f_convDown.convert(oValue)));
            }
        }
    }

    public static class ConverterHolder<F, T>
    implements Holder<T>,
    Serializable {
        private final F m_value;
        private final Converter<F, T> m_convUp;
        private transient T m_oValueUp;

        public ConverterHolder(F value, Converter<F, T> convUp) {
            this.m_value = value;
            this.m_convUp = convUp;
        }

        @Override
        public T get() {
            T oValueUp = this.m_oValueUp;
            if (oValueUp == null) {
                oValueUp = this.m_oValueUp = this.m_convUp.convert(this.m_value);
            }
            return oValueUp;
        }

        @Override
        public void set(T value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterHolder) {
                ConverterHolder that = (ConverterHolder)o;
                return NaturalHasher.INSTANCE.equals(this.get(), that.get());
            }
            return false;
        }

        public int hashCode() {
            T oKey = this.get();
            return oKey == null ? 0 : oKey.hashCode();
        }

        public String toString() {
            return "ConverterHolder{Value=\"" + this.get() + "\", Converter=\"" + this.m_convUp + "\"}";
        }
    }

    public static class ConverterComparator<F, T>
    implements Comparator<T>,
    Serializable {
        private final Converter<T, F> m_conv;
        private final Comparator<? super F> m_comparator;

        public ConverterComparator(Comparator<? super F> comparator, Converter<T, F> conv) {
            this.m_comparator = comparator;
            this.m_conv = conv;
        }

        @Override
        public int compare(T o1, T o2) {
            Converter<T, T> conv = this.m_conv;
            return this.m_comparator.compare(conv.convert(o1), conv.convert(o2));
        }
    }

    public static class ConverterCacheListener<K, V>
    extends ConverterMapListener<K, V>
    implements MapListener<K, V> {
        public ConverterCacheListener(NamedCache<K, V> cache, MapListener<K, V> listener, Converter<K, K> convKey, Converter<V, V> convVal) {
            super(cache, listener, convKey, convVal);
        }

        @Override
        protected void onMapEvent(MapEvent<K, V> evt) {
            if (((NamedCache)this.getObservableMap()).isActive()) {
                super.onMapEvent(evt);
            }
        }
    }

    public static class ConverterMapListener<K, V>
    extends MapListenerSupport.WrapperListener<K, V>
    implements MapListener<K, V> {
        protected ObservableMap<K, V> m_map;
        protected Converter<K, K> m_convKey;
        protected Converter<V, V> m_convVal;

        public ConverterMapListener(ObservableMap<K, V> map, MapListener<K, V> listener, Converter<K, K> convKey, Converter<V, V> convVal) {
            super(listener);
            ConverterMapListener.azzert(convKey != null && convVal != null, "Null converter");
            this.m_map = map;
            this.m_convKey = convKey;
            this.m_convVal = convVal;
        }

        @Override
        protected void onMapEvent(MapEvent<K, V> evt) {
            super.onMapEvent(ConverterCollections.getMapEvent(this.getObservableMap(), evt, this.getConverterKeyUp(), this.getConverterValueUp()));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (super.equals(o)) {
                ConverterMapListener that = (ConverterMapListener)o;
                return this.getConverterKeyUp().equals(that.getConverterKeyUp()) && this.getConverterValueUp().equals(that.getConverterValueUp());
            }
            return false;
        }

        public ObservableMap<K, V> getObservableMap() {
            return this.m_map;
        }

        public Converter<K, K> getConverterKeyUp() {
            return this.m_convKey;
        }

        public Converter<V, V> getConverterValueUp() {
            return this.m_convVal;
        }
    }

    public static class ConverterCacheEvent<K, V>
    extends ConverterMapEvent<K, V> {
        public ConverterCacheEvent(ObservableMap<K, V> map, CacheEvent<K, V> event, Converter<K, K> convKey, Converter<V, V> convVal) {
            this(map, event, convKey, convVal, (BackingMapManagerContext)null);
        }

        public ConverterCacheEvent(ObservableMap<K, V> map, CacheEvent<K, V> event, Converter<K, K> convKey, Converter<V, V> convVal, BackingMapManagerContext context) {
            super(map, event, convKey, convVal, context);
        }

        public CacheEvent<K, V> getCacheEvent() {
            return (CacheEvent)this.getMapEvent();
        }
    }

    public static class ConverterMapEvent<K, V>
    extends CacheEvent<K, V> {
        public static final Object NO_VALUE = new Object();
        protected MapEvent<K, V> m_event;
        protected Converter<K, K> m_convKey;
        protected Converter<V, V> m_convVal;
        protected BackingMapManagerContext m_context;
        protected Map.Entry<K, V> m_entryOld;
        protected Map.Entry<K, V> m_entryNew;

        public ConverterMapEvent(ObservableMap<K, V> map, MapEvent<K, V> event, Converter<K, K> convKey, Converter<V, V> convVal) {
            this(map, event, convKey, convVal, null);
        }

        public ConverterMapEvent(ObservableMap<K, V> map, MapEvent<K, V> event, Converter<K, K> convKey, Converter<V, V> convVal, BackingMapManagerContext context) {
            super(map, event.getId(), NO_VALUE, NO_VALUE, NO_VALUE, event instanceof CacheEvent && ((CacheEvent)event).isSynthetic(), event instanceof CacheEvent ? ((CacheEvent)event).getTransformationState() : CacheEvent.TransformationState.TRANSFORMABLE, event instanceof CacheEvent && ((CacheEvent)event).isPriming());
            this.m_event = event;
            this.m_convKey = convKey;
            this.m_convVal = convVal;
            this.m_context = context;
        }

        @Override
        public K getKey() {
            Object key = this.m_key;
            if (key == NO_VALUE) {
                key = this.getConverterKeyUp().convert(this.getMapEvent().getKey());
                this.setKey(key);
            }
            return (K)key;
        }

        @Override
        public V getOldValue() {
            Object valueOld = this.m_valueOld;
            if (valueOld == NO_VALUE) {
                valueOld = this.getConverterValueUp().convert(this.getMapEvent().getOldValue());
                this.setOldValue(valueOld);
            }
            return (V)valueOld;
        }

        @Override
        public V getNewValue() {
            Object valueNew = this.m_valueNew;
            if (valueNew == NO_VALUE) {
                valueNew = this.getConverterValueUp().convert(this.getMapEvent().getNewValue());
                this.setNewValue(valueNew);
            }
            return (V)valueNew;
        }

        @Override
        public Map.Entry<K, V> getOldEntry() {
            ConverterMapEventEntry entry = this.m_entryOld;
            if (entry == null) {
                this.m_entryOld = this.getContext() == null ? new ConverterMapEventEntry(false) : new ConverterMapEventBinaryEntry(false);
                entry = this.m_entryOld;
            }
            return entry;
        }

        @Override
        public Map.Entry<K, V> getNewEntry() {
            ConverterMapEventEntry entry = this.m_entryNew;
            if (entry == null) {
                this.m_entryNew = this.getContext() == null ? new ConverterMapEventEntry(true) : new ConverterMapEventBinaryEntry(true);
                entry = this.m_entryNew;
            }
            return entry;
        }

        public MapEvent<K, V> getMapEvent() {
            return this.m_event;
        }

        public BackingMapManagerContext getContext() {
            return this.m_context;
        }

        public Converter<K, K> getConverterKeyUp() {
            return this.m_convKey;
        }

        public Converter<V, V> getConverterValueUp() {
            return this.m_convVal;
        }

        public void setKey(K key) {
            this.m_key = key;
        }

        public void setOldValue(V value) {
            this.m_valueOld = value;
        }

        public void setNewValue(V value) {
            this.m_valueNew = value;
        }

        public boolean isKeyConverted() {
            return this.m_key != NO_VALUE;
        }

        public boolean isOldValueConverted() {
            return this.m_valueOld != NO_VALUE;
        }

        public boolean isNewValueConverted() {
            return this.m_valueNew != NO_VALUE;
        }

        public void clearConverted() {
            this.setKey(NO_VALUE);
            this.setOldValue(NO_VALUE);
            this.setNewValue(NO_VALUE);
            this.m_entryOld = null;
            this.m_entryNew = null;
        }

        protected class ConverterMapEventBinaryEntry
        extends ConverterMapEventEntry
        implements BinaryEntry<K, V> {
            private Map<ValueExtractor, Object> m_mapExtracted;

            public ConverterMapEventBinaryEntry(boolean fNewValue) {
                super(fNewValue);
            }

            @Override
            public boolean isPresent() {
                return this.getBinaryValue() != null;
            }

            @Override
            public boolean isSynthetic() {
                MapEvent event = ConverterMapEvent.this.getMapEvent();
                return event instanceof CacheEvent && ((CacheEvent)event).isSynthetic();
            }

            @Override
            public void remove(boolean fSynthetic) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setValue(V value, boolean fSynthetic) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> void update(ValueUpdater<V, T> updater, T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T, E> E extract(ValueExtractor<T, E> extractor) {
                Object oValue;
                Map<ValueExtractor, Object> mapExtracted = this.m_mapExtracted;
                if (mapExtracted == null) {
                    mapExtracted = this.m_mapExtracted = new LiteMap<ValueExtractor, Object>();
                    oValue = null;
                } else {
                    oValue = mapExtracted.get(extractor);
                }
                if (oValue == null) {
                    oValue = InvocableMapHelper.extractFromEntry(extractor, this);
                    mapExtracted.put(extractor, oValue == null ? NO_VALUE : oValue);
                } else if (oValue == NO_VALUE) {
                    oValue = null;
                }
                return (E)oValue;
            }

            @Override
            public BackingMapManagerContext getContext() {
                return ConverterMapEvent.this.getContext();
            }

            @Override
            public Serializer getSerializer() {
                return this.getContext().getCacheService().getSerializer();
            }

            @Override
            public void updateBinaryValue(Binary binValue) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void updateBinaryValue(Binary binValue, boolean fSynthetic) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V getOriginalValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Binary getOriginalBinaryValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ObservableMap<K, V> getBackingMap() {
                return ConverterMapEvent.this.m_event.getMap();
            }

            @Override
            public BackingMapContext getBackingMapContext() {
                return null;
            }

            @Override
            public void expire(long cMillis) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getExpiry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        }

        protected class ConverterMapEventEntry
        implements Map.Entry<K, V> {
            protected boolean m_fNewValue;

            public ConverterMapEventEntry(boolean fNewValue) {
                this.m_fNewValue = fNewValue;
            }

            public Binary getBinaryKey() {
                return (Binary)ConverterMapEvent.this.m_event.getKey();
            }

            public Binary getBinaryValue() {
                return this.m_fNewValue ? (Binary)ConverterMapEvent.this.m_event.getNewValue() : (Binary)ConverterMapEvent.this.m_event.getOldValue();
            }

            @Override
            public K getKey() {
                return ConverterMapEvent.this.getKey();
            }

            @Override
            public V getValue() {
                return this.m_fNewValue ? ConverterMapEvent.this.getNewValue() : ConverterMapEvent.this.getOldValue();
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class ConverterCacheEntry
    extends ConverterEntry
    implements ConfigurableCacheMap.Entry {
        public ConverterCacheEntry(ConfigurableCacheMap.Entry entry, Converter conKeyUp, Converter conValUp, Converter conValDown) {
            super(entry, conKeyUp, conValUp, conValDown);
        }

        @Override
        public ConfigurableCacheMap.Entry getEntry() {
            return (ConfigurableCacheMap.Entry)super.getEntry();
        }

        @Override
        public void touch() {
            this.getEntry().touch();
        }

        @Override
        public int getTouchCount() {
            return this.getEntry().getTouchCount();
        }

        @Override
        public long getLastTouchMillis() {
            return this.getEntry().getLastTouchMillis();
        }

        @Override
        public long getExpiryMillis() {
            return this.getEntry().getExpiryMillis();
        }

        @Override
        public void setExpiryMillis(long lMillis) {
            this.getEntry().setExpiryMillis(lMillis);
        }

        @Override
        public int getUnits() {
            return this.getEntry().getUnits();
        }

        @Override
        public void setUnits(int cUnits) {
            this.getEntry().setUnits(cUnits);
        }
    }

    public static class ConverterEntry<FK, TK, FV, TV>
    extends AbstractConverterEntry<FK, TK, FV, TV> {
        protected final Converter<FK, TK> m_convKeyUp;
        protected final Converter<FV, TV> m_convValUp;
        protected final Converter<TV, FV> m_convValDown;

        public ConverterEntry(Map.Entry<FK, FV> entry, Converter<FK, TK> convKeyUp, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            super(entry);
            this.m_convKeyUp = convKeyUp;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        @Override
        protected Converter<FK, TK> getConverterKeyUp() {
            return this.m_convKeyUp;
        }

        @Override
        protected Converter<FV, TV> getConverterValueUp() {
            return this.m_convValUp;
        }

        @Override
        protected Converter<TV, FV> getConverterValueDown() {
            return this.m_convValDown;
        }
    }

    protected static abstract class AbstractConverterEntry<FK, TK, FV, TV>
    implements Map.Entry<TK, TV>,
    Serializable {
        protected final Map.Entry<FK, FV> m_entry;
        protected transient TK m_oKeyUp;
        protected transient TV m_oValueUp;

        protected AbstractConverterEntry(Map.Entry<FK, FV> entry) {
            this.m_entry = entry;
        }

        protected abstract Converter<FK, TK> getConverterKeyUp();

        protected abstract Converter<FV, TV> getConverterValueUp();

        protected abstract Converter<TV, FV> getConverterValueDown();

        @Override
        public TK getKey() {
            Object oKeyUp = this.m_oKeyUp;
            if (oKeyUp == null) {
                this.m_oKeyUp = oKeyUp = this.getConverterKeyUp().convert(this.getEntry().getKey());
            }
            return oKeyUp;
        }

        @Override
        public TV getValue() {
            Object oValueUp = this.m_oValueUp;
            if (oValueUp == null) {
                this.m_oValueUp = oValueUp = this.getConverterValueUp().convert(this.getEntry().getValue());
            }
            return oValueUp;
        }

        @Override
        public TV setValue(TV value) {
            this.m_oValueUp = null;
            return (TV)this.getConverterValueUp().convert(this.getEntry().setValue(this.getConverterValueDown().convert(value)));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)o;
                return NaturalHasher.INSTANCE.equals(this.getKey(), that.getKey()) && NaturalHasher.INSTANCE.equals(this.getValue(), that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            TK oKey = this.getKey();
            TV oValue = this.getValue();
            return (oKey == null ? 0 : oKey.hashCode()) ^ (oValue == null ? 0 : oValue.hashCode());
        }

        public String toString() {
            return "ConverterEntry{Key=\"" + this.getKey() + "\", Value=\"" + this.getValue() + "\"}";
        }

        public Map.Entry<FK, FV> getEntry() {
            return this.m_entry;
        }
    }

    public static class ConverterEntrySet<FK, TK, FV, TV>
    implements Set<Map.Entry<TK, TV>>,
    Serializable {
        protected final Collection<Map.Entry<FK, FV>> m_set;
        protected final Converter<FK, TK> m_convKeyUp;
        protected final Converter<TK, FK> m_convKeyDown;
        protected final Converter<FV, TV> m_convValUp;
        protected final Converter<TV, FV> m_convValDown;

        public ConverterEntrySet(Collection<Map.Entry<FK, FV>> set, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            assert (set != null && convKeyUp != null && convKeyDown != null && convValUp != null && convValDown != null);
            this.m_set = set;
            this.m_convKeyUp = convKeyUp;
            this.m_convKeyDown = convKeyDown;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        @Override
        public int size() {
            return this.getEntrySet().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getEntrySet().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getEntrySet().contains(new com.tangosol.util.ConverterCollections$ConverterEntry<TK, FK, TV, FV>((Map.Entry)o, this.getConverterKeyDown(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public Iterator<Map.Entry<TK, TV>> iterator() {
            return this.wrapIterator(this.getEntrySet().iterator());
        }

        @Override
        public Object[] toArray() {
            Object[] ao = this.getEntrySet().toArray();
            int c = ao.length;
            Object[] aEntry = new Object[c];
            for (int i = 0; i < c; ++i) {
                aEntry[i] = this.wrapEntry((Map.Entry)ao[i]);
            }
            return aEntry;
        }

        @Override
        public <T> T[] toArray(T[] ao) {
            int cDest;
            Object[] aoSrc = this.getEntrySet().toArray();
            int cSrc = aoSrc.length;
            if (cSrc > (cDest = ao.length)) {
                cDest = cSrc;
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cDest);
            }
            if (cDest > cSrc) {
                ao[cSrc] = null;
            }
            for (int i = 0; i < cSrc; ++i) {
                ao[i] = this.wrapEntry((Map.Entry)aoSrc[i]);
            }
            return ao;
        }

        @Override
        public boolean add(Map.Entry<TK, TV> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = (Map.Entry)o;
            return this.getEntrySet().remove(new AbstractMap.SimpleEntry(this.getConverterKeyDown().convert(entry.getKey()), this.getConverterValueDown().convert(entry.getValue())));
        }

        @Override
        public boolean containsAll(Collection<?> col) {
            return this.getEntrySet().containsAll(this.instantiateEntrySet(col, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<TK, TV>> col) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> col) {
            return this.getEntrySet().removeAll(this.instantiateEntrySet(col, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public boolean retainAll(Collection<?> col) {
            return this.getEntrySet().retainAll(this.instantiateEntrySet(col, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public void clear() {
            this.getEntrySet().clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterEntrySet) {
                ConverterEntrySet that = (ConverterEntrySet)o;
                return this.getEntrySet().equals(that.getEntrySet()) && this.getConverterKeyUp().equals(that.getConverterKeyUp()) && this.getConverterKeyDown().equals(that.getConverterKeyDown()) && this.getConverterValueUp().equals(that.getConverterValueUp()) && this.getConverterValueDown().equals(that.getConverterValueDown());
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                return set.size() == this.size() && this.containsAll(set);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            for (Map.Entry<FK, FV> o : this.getEntrySet()) {
                nHash += NaturalHasher.INSTANCE.hashCode(o);
            }
            return nHash;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterEntrySet{");
            boolean fFirst = true;
            for (Map.Entry<TK, TV> o : this) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(o);
            }
            sb.append('}');
            return sb.toString();
        }

        protected <FK, FV, TK, TV> Set<Map.Entry<TK, TV>> instantiateEntrySet(Collection<Map.Entry<FK, FV>> col, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            return ConverterCollections.getEntrySet(col, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        protected Map.Entry<TK, TV> wrapEntry(Map.Entry<FK, FV> entry) {
            return new ConverterEntry(entry);
        }

        protected Iterator<Map.Entry<TK, TV>> wrapIterator(Iterator<Map.Entry<FK, FV>> iter) {
            return new ConverterIterator(iter);
        }

        public Collection<Map.Entry<FK, FV>> getEntrySet() {
            return this.m_set;
        }

        public Converter<FK, TK> getConverterKeyUp() {
            return this.m_convKeyUp;
        }

        public Converter<TK, FK> getConverterKeyDown() {
            return this.m_convKeyDown;
        }

        public Converter<FV, TV> getConverterValueUp() {
            return this.m_convValUp;
        }

        public Converter<TV, FV> getConverterValueDown() {
            return this.m_convValDown;
        }

        protected class ConverterIterator
        implements Iterator<Map.Entry<TK, TV>> {
            protected final Iterator<Map.Entry<FK, FV>> m_iter;

            public ConverterIterator(Iterator<Map.Entry<FK, FV>> iter) {
                this.m_iter = iter;
            }

            @Override
            public boolean hasNext() {
                return this.getIterator().hasNext();
            }

            @Override
            public Map.Entry<TK, TV> next() {
                return ConverterEntrySet.this.wrapEntry(this.getIterator().next());
            }

            @Override
            public void remove() {
                this.getIterator().remove();
            }

            public Iterator<Map.Entry<FK, FV>> getIterator() {
                return this.m_iter;
            }
        }

        protected class ConverterEntry
        extends AbstractConverterEntry<FK, TK, FV, TV> {
            public ConverterEntry(Map.Entry<FK, FV> entry) {
                super(entry);
            }

            @Override
            protected Converter<FK, TK> getConverterKeyUp() {
                return ConverterEntrySet.this.getConverterKeyUp();
            }

            @Override
            protected Converter<FV, TV> getConverterValueUp() {
                return ConverterEntrySet.this.getConverterValueUp();
            }

            @Override
            protected Converter<TV, FV> getConverterValueDown() {
                return ConverterEntrySet.this.getConverterValueDown();
            }
        }
    }

    public static class ConverterNamedCache<FK, TK, FV, TV>
    extends ConverterCacheMap<FK, TK, FV, TV>
    implements NamedCache<TK, TV>,
    Serializable {
        protected ConcurrentMap<TK, TV> m_mapConcurrent;
        protected InvocableMap<TK, TV> m_mapInvocable;
        protected QueryMap<TK, TV> m_mapQuery;

        public ConverterNamedCache(NamedCache<FK, FV> cache, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            super(cache, convKeyUp, convKeyDown, convValUp, convValDown);
            this.m_mapConcurrent = ConverterCollections.getConcurrentMap(cache, convKeyUp, convKeyDown, convValUp, convValDown);
            this.m_mapInvocable = ConverterCollections.getInvocableMap(cache, convKeyUp, convKeyDown, convValUp, convValDown);
            this.m_mapQuery = ConverterCollections.getQueryMap(cache, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public String getCacheName() {
            return this.getNamedCache().getCacheName();
        }

        @Override
        public CacheService getCacheService() {
            return this.getNamedCache().getCacheService();
        }

        @Override
        public boolean isActive() {
            return this.getNamedCache().isActive();
        }

        @Override
        public void release() {
            this.getNamedCache().release();
        }

        @Override
        public void destroy() {
            this.getNamedCache().destroy();
        }

        @Override
        public void truncate() {
            this.getNamedCache().truncate();
        }

        @Override
        public boolean isDestroyed() {
            return this.getNamedCache().isDestroyed();
        }

        @Override
        public boolean isReleased() {
            return this.getNamedCache().isReleased();
        }

        @Override
        public boolean lock(Object oKey, long cWait) {
            return this.m_mapConcurrent.lock(oKey, cWait);
        }

        @Override
        public boolean lock(Object oKey) {
            return this.m_mapConcurrent.lock(oKey);
        }

        @Override
        public boolean unlock(Object oKey) {
            return this.m_mapConcurrent.unlock(oKey);
        }

        @Override
        public <R> R invoke(TK key, InvocableMap.EntryProcessor<TK, TV, R> agent) {
            return this.m_mapInvocable.invoke(key, agent);
        }

        @Override
        public <R> Map<TK, R> invokeAll(Collection<? extends TK> collKeys, InvocableMap.EntryProcessor<TK, TV, R> agent) {
            return this.m_mapInvocable.invokeAll(collKeys, agent);
        }

        @Override
        public <R> Map<TK, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<TK, TV, R> agent) {
            return this.m_mapInvocable.invokeAll(filter, agent);
        }

        @Override
        public <R> R aggregate(Collection<? extends TK> collKeys, InvocableMap.EntryAggregator<? super TK, ? super TV, R> agent) {
            return this.m_mapInvocable.aggregate(collKeys, agent);
        }

        @Override
        public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super TK, ? super TV, R> agent) {
            return this.m_mapInvocable.aggregate(filter, agent);
        }

        @Override
        public Set<TK> keySet(Filter filter) {
            return this.m_mapQuery.keySet(filter);
        }

        @Override
        public Set<Map.Entry<TK, TV>> entrySet(Filter filter) {
            return this.m_mapQuery.entrySet(filter);
        }

        @Override
        public Set<Map.Entry<TK, TV>> entrySet(Filter filter, Comparator comparator) {
            return this.m_mapQuery.entrySet(filter, comparator);
        }

        @Override
        public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> extractor, boolean fOrdered, Comparator<? super E> comparator) {
            this.m_mapQuery.addIndex(extractor, fOrdered, comparator);
        }

        @Override
        public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> extractor) {
            this.m_mapQuery.removeIndex(extractor);
        }

        @Override
        public TV putIfAbsent(TK key, TV value) {
            return this.m_mapInvocable.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.m_mapInvocable.remove(key, value);
        }

        @Override
        public boolean replace(TK key, TV oldValue, TV newValue) {
            return this.m_mapInvocable.replace(key, oldValue, newValue);
        }

        @Override
        public TV replace(TK key, TV value) {
            return this.m_mapInvocable.replace(key, value);
        }

        @Override
        public TV merge(TK key, TV value, Remote.BiFunction<? super TV, ? super TV, ? extends TV> remappingFunction) {
            return this.m_mapInvocable.merge(key, value, remappingFunction);
        }

        @Override
        public TV merge(TK key, TV value, BiFunction<? super TV, ? super TV, ? extends TV> remappingFunction) {
            return this.m_mapInvocable.merge(key, value, remappingFunction);
        }

        public NamedCache<FK, FV> getNamedCache() {
            return (NamedCache)this.getMap();
        }
    }

    public static class ConverterCacheMap<FK, TK, FV, TV>
    extends ConverterObservableMap<FK, TK, FV, TV>
    implements CacheMap<TK, TV>,
    Serializable {
        public ConverterCacheMap(CacheMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public Map<TK, TV> getAll(Collection<? extends TK> colKeys) {
            Converter convKeyDown = this.getConverterKeyDown();
            Converter convKeyUp = this.getConverterKeyUp();
            Converter convValDown = this.getConverterValueDown();
            Converter convValUp = this.getConverterValueUp();
            Collection colKeysConv = colKeys instanceof Set ? this.instantiateSet((Set)colKeys, convKeyDown, convKeyUp) : this.instantiateCollection(colKeys, convKeyDown, convKeyUp);
            return this.instantiateMap(this.getCacheMap().getAll(colKeysConv), convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public TV put(TK key, TV value, long cMillis) {
            return (TV)this.getConverterValueUp().convert(this.getCacheMap().put(this.getConverterKeyDown().convert(key), this.getConverterValueDown().convert(value), cMillis));
        }

        public CacheMap<FK, FV> getCacheMap() {
            return (CacheMap)this.getMap();
        }
    }

    public static class ConverterQueryMap<FK, TK, FV, TV>
    extends ConverterMap<FK, TK, FV, TV>
    implements QueryMap<TK, TV>,
    Serializable {
        public ConverterQueryMap(QueryMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public Set<TK> keySet(Filter filter) {
            return this.instantiateSet(this.getQueryMap().keySet(filter), this.getConverterKeyUp(), this.getConverterKeyDown());
        }

        @Override
        public Set<Map.Entry<TK, TV>> entrySet(Filter filter) {
            return this.instantiateEntrySet(this.getQueryMap().entrySet(filter), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        @Override
        public Set<Map.Entry<TK, TV>> entrySet(Filter filter, Comparator comparator) {
            return this.instantiateEntrySet(this.getQueryMap().entrySet(filter, comparator), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        @Override
        public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> extractor, boolean fOrdered, Comparator<? super E> comparator) {
            this.getQueryMap().addIndex(extractor, fOrdered, comparator);
        }

        @Override
        public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> extractor) {
            this.getQueryMap().removeIndex(extractor);
        }

        public QueryMap<FK, FV> getQueryMap() {
            return (QueryMap)this.getMap();
        }
    }

    public static class ConverterObservableMap<FK, TK, FV, TV>
    extends ConverterMap<FK, TK, FV, TV>
    implements ObservableMap<TK, TV>,
    Serializable {
        public ConverterObservableMap(ObservableMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public void addMapListener(MapListener<? super TK, ? super TV> listener) {
            this.getObservableMap().addMapListener(this.getConverterListener(listener));
        }

        @Override
        public void removeMapListener(MapListener<? super TK, ? super TV> listener) {
            this.getObservableMap().removeMapListener(this.getConverterListener(listener));
        }

        @Override
        public void addMapListener(MapListener<? super TK, ? super TV> listener, TK key, boolean fLite) {
            this.getObservableMap().addMapListener(this.getConverterListener(listener), this.getConverterKeyDown().convert(key), fLite);
        }

        @Override
        public void removeMapListener(MapListener<? super TK, ? super TV> listener, TK key) {
            this.getObservableMap().removeMapListener(this.getConverterListener(listener), this.getConverterKeyDown().convert(key));
        }

        @Override
        public void addMapListener(MapListener<? super TK, ? super TV> listener, Filter filter, boolean fLite) {
            this.getObservableMap().addMapListener(this.getConverterListener(listener), filter, fLite);
        }

        @Override
        public void removeMapListener(MapListener<? super TK, ? super TV> listener, Filter filter) {
            this.getObservableMap().removeMapListener(this.getConverterListener(listener), filter);
        }

        protected MapListener<? super FK, ? super FV> getConverterListener(MapListener<? super TK, ? super TV> listener) {
            if (listener instanceof MapTriggerListener || listener instanceof NamedCacheDeactivationListener) {
                return listener;
            }
            return ConverterCollections.getMapListener(this, listener, this.getConverterKeyUp(), this.getConverterValueUp());
        }

        public ObservableMap<FK, FV> getObservableMap() {
            return (ObservableMap)this.getMap();
        }
    }

    public static class ConverterInvocableMap<FK, TK, FV, TV>
    extends ConverterMap<FK, TK, FV, TV>
    implements InvocableMap<TK, TV>,
    Serializable {
        public ConverterInvocableMap(InvocableMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public <R> R aggregate(Collection<? extends TK> collKeys, InvocableMap.EntryAggregator<? super TK, ? super TV, R> agent) {
            Converter convKeyDown = this.getConverterKeyDown();
            Converter convKeyUp = this.getConverterKeyUp();
            Collection colKeysConv = collKeys instanceof Set ? this.instantiateSet((Set)collKeys, convKeyDown, convKeyUp) : this.instantiateCollection(collKeys, convKeyDown, convKeyUp);
            return (R)ConverterInvocableMap.convertSafe(this.getConverterValueUp(), this.getInvocableMap().aggregate(colKeysConv, agent));
        }

        @Override
        public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super TK, ? super TV, R> agent) {
            return (R)ConverterInvocableMap.convertSafe(this.getConverterValueUp(), this.getInvocableMap().aggregate(filter, agent));
        }

        @Override
        public <R> R invoke(TK key, InvocableMap.EntryProcessor<TK, TV, R> agent) {
            R oResult = this.getInvocableMap().invoke(this.getConverterKeyDown().convert(key), agent);
            return (R)ConverterInvocableMap.convertSafe(this.getConverterValueUp(), oResult);
        }

        @Override
        public <R> Map<TK, R> invokeAll(Collection<? extends TK> collKeys, InvocableMap.EntryProcessor<TK, TV, R> agent) {
            Converter convKeyDown = this.getConverterKeyDown();
            Converter convKeyUp = this.getConverterKeyUp();
            Collection colKeysConv = collKeys instanceof Set ? this.instantiateSet((Set)collKeys, convKeyDown, convKeyUp) : this.instantiateCollection(collKeys, convKeyDown, convKeyUp);
            Map<FK, R> mapResult = this.getInvocableMap().invokeAll(colKeysConv, agent);
            return mapResult == null || mapResult.isEmpty() ? Collections.emptyMap() : this.instantiateMap(mapResult, convKeyUp, convKeyDown, value -> ConverterInvocableMap.convertSafe(this.getConverterValueUp(), value), value -> ConverterInvocableMap.convertSafe(this.getConverterValueDown(), value));
        }

        @Override
        public <R> Map<TK, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<TK, TV, R> agent) {
            Map<FK, R> mapResult = this.getInvocableMap().invokeAll(filter, agent);
            return mapResult == null || mapResult.isEmpty() ? Collections.emptyMap() : this.instantiateMap(mapResult, this.getConverterKeyUp(), this.getConverterKeyDown(), value -> ConverterInvocableMap.convertSafe(this.getConverterValueUp(), value), value -> ConverterInvocableMap.convertSafe(this.getConverterValueDown(), value));
        }

        @Override
        public TV putIfAbsent(TK key, TV value) {
            InvocableMap.EntryProcessor processor = CacheProcessors.putIfAbsent(this.getConverterValueDown().convert(value));
            return (TV)this.invoke(key, processor);
        }

        @Override
        public boolean remove(Object key, Object value) {
            InvocableMap.EntryProcessor processor = CacheProcessors.remove(this.getConverterValueDown().convert(value));
            return this.invoke((TK)key, processor);
        }

        @Override
        public boolean replace(TK key, TV oldValue, TV newValue) {
            InvocableMap.EntryProcessor processor = CacheProcessors.replace(this.getConverterValueDown().convert(oldValue), this.getConverterValueDown().convert(newValue));
            return this.invoke(key, processor);
        }

        @Override
        public TV replace(TK key, TV value) {
            InvocableMap.EntryProcessor processor = CacheProcessors.replace(this.getConverterValueDown().convert(value));
            return (TV)this.invoke(key, processor);
        }

        @Override
        public TV merge(TK key, TV value, Remote.BiFunction<? super TV, ? super TV, ? extends TV> remappingFunction) {
            InvocableMap.EntryProcessor processor = CacheProcessors.merge(this.getConverterValueDown().convert(value), remappingFunction);
            return this.invoke(key, processor);
        }

        @Override
        public TV merge(TK key, TV value, BiFunction<? super TV, ? super TV, ? extends TV> remappingFunction) {
            InvocableMap.EntryProcessor processor = CacheProcessors.merge(this.getConverterValueDown().convert(value), (Remote.BiFunction)remappingFunction);
            return (TV)this.invoke(key, processor);
        }

        public InvocableMap<FK, FV> getInvocableMap() {
            return (InvocableMap)this.getMap();
        }

        protected static Object convertSafe(Converter converter, Object oValue) {
            try {
                return oValue == null ? null : converter.convert(oValue);
            }
            catch (ClassCastException classCastException) {
                return oValue;
            }
        }
    }

    public static class ConverterConcurrentMap<FK, TK, FV, TV>
    extends ConverterMap<FK, TK, FV, TV>
    implements ConcurrentMap<TK, TV>,
    Serializable {
        public ConverterConcurrentMap(ConcurrentMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public boolean lock(Object oKey) {
            return this.getConcurrentMap().lock(this.getConverterKeyDown().convert(oKey));
        }

        @Override
        public boolean lock(Object oKey, long cWait) {
            return this.getConcurrentMap().lock(this.getConverterKeyDown().convert(oKey), cWait);
        }

        @Override
        public boolean unlock(Object oKey) {
            return this.getConcurrentMap().unlock(this.getConverterKeyDown().convert(oKey));
        }

        public ConcurrentMap<FK, FV> getConcurrentMap() {
            return (ConcurrentMap)this.getMap();
        }
    }

    public static class ConverterSortedMap<FK, TK, FV, TV>
    extends ConverterMap<FK, TK, FV, TV>
    implements SortedMap<TK, TV>,
    Serializable {
        public ConverterSortedMap(SortedMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        @Override
        public Comparator<TK> comparator() {
            Comparator<FK> comparator = this.getSortedMap().comparator();
            if (comparator != null) {
                return new ConverterComparator(comparator, this.m_convKeyDown);
            }
            return null;
        }

        @Override
        public SortedMap<TK, TV> subMap(TK fromKey, TK toKey) {
            return this.instantiateSortedMap(this.getSortedMap().subMap(this.getConverterKeyDown().convert(fromKey), this.getConverterKeyDown().convert(toKey)), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        @Override
        public SortedMap<TK, TV> headMap(TK toKey) {
            return this.instantiateSortedMap(this.getSortedMap().headMap(this.getConverterKeyDown().convert(toKey)), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        @Override
        public SortedMap<TK, TV> tailMap(TK fromKey) {
            return this.instantiateSortedMap(this.getSortedMap().tailMap(this.getConverterKeyDown().convert(fromKey)), this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        @Override
        public TK firstKey() {
            return (TK)this.getConverterKeyUp().convert(this.getSortedMap().firstKey());
        }

        @Override
        public TK lastKey() {
            return (TK)this.getConverterKeyUp().convert(this.getSortedMap().lastKey());
        }

        protected SortedMap<TK, TV> instantiateSortedMap(SortedMap<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            return ConverterCollections.getSortedMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public SortedMap<FK, FV> getSortedMap() {
            return (SortedMap)this.getMap();
        }
    }

    public static class ConverterMap<FK, TK, FV, TV>
    implements Map<TK, TV>,
    Serializable {
        protected final Map<FK, FV> m_map;
        protected final Converter<FK, TK> m_convKeyUp;
        protected final Converter<TK, FK> m_convKeyDown;
        protected final Converter<FV, TV> m_convValUp;
        protected final Converter<TV, FV> m_convValDown;
        protected transient Set<Map.Entry<TK, TV>> m_set;

        public ConverterMap(Map<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            assert (map != null && convKeyUp != null && convKeyDown != null && convValUp != null && convValDown != null);
            this.m_map = map;
            this.m_convKeyUp = convKeyUp;
            this.m_convKeyDown = convKeyDown;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        @Override
        public int size() {
            return this.getMap().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.getMap().containsKey(this.getConverterKeyDown().convert(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.getMap().containsValue(this.getConverterValueDown().convert(value));
        }

        @Override
        public TV get(Object key) {
            return (TV)this.getConverterValueUp().convert(this.getMap().get(this.getConverterKeyDown().convert(key)));
        }

        @Override
        public TV put(TK key, TV value) {
            return (TV)this.getConverterValueUp().convert(this.getMap().put(this.getConverterKeyDown().convert(key), this.getConverterValueDown().convert(value)));
        }

        @Override
        public TV remove(Object key) {
            return (TV)this.getConverterValueUp().convert(this.getMap().remove(this.getConverterKeyDown().convert(key)));
        }

        @Override
        public void putAll(Map<? extends TK, ? extends TV> map) {
            this.getMap().putAll(this.instantiateMap(map, this.getConverterKeyDown(), this.getConverterKeyUp(), this.getConverterValueDown(), this.getConverterValueUp()));
        }

        @Override
        public void clear() {
            this.getMap().clear();
        }

        @Override
        public Set<TK> keySet() {
            return this.instantiateSet(this.getMap().keySet(), this.getConverterKeyUp(), this.getConverterKeyDown());
        }

        @Override
        public Collection<TV> values() {
            return this.instantiateCollection(this.getMap().values(), this.getConverterValueUp(), this.getConverterValueDown());
        }

        @Override
        public Set<Map.Entry<TK, TV>> entrySet() {
            if (this.m_set == null) {
                Set<Map.Entry<FK, FV>> set = this.getMap().entrySet();
                this.m_set = this.instantiateEntrySet(set, this.getConverterKeyUp(), this.getConverterKeyDown(), this.getConverterValueUp(), this.getConverterValueDown());
            }
            return this.m_set;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterMap{");
            boolean fFirst = true;
            for (Map.Entry<TK, TV> o : this.entrySet()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(o);
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map) {
                return this.entrySet().equals(((Map)o).entrySet());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            for (Map.Entry<TK, TV> o : this.entrySet()) {
                nHash += NaturalHasher.INSTANCE.hashCode(o);
            }
            return nHash;
        }

        protected <F, T> Collection<T> instantiateCollection(Collection<F> col, Converter<F, T> convUp, Converter<T, F> convDown) {
            return ConverterCollections.getCollection(col, convUp, convDown);
        }

        protected <T, F> Set<T> instantiateSet(Set<F> set, Converter<F, T> convUp, Converter<T, F> convDown) {
            return ConverterCollections.getSet(set, convUp, convDown);
        }

        protected <FK, TK, FV, TV> Map<TK, TV> instantiateMap(Map<FK, FV> map, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            return ConverterCollections.getMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        protected Set<Map.Entry<TK, TV>> instantiateEntrySet(Set<Map.Entry<FK, FV>> set, Converter<FK, TK> convKeyUp, Converter<TK, FK> convKeyDown, Converter<FV, TV> convValUp, Converter<TV, FV> convValDown) {
            return ConverterCollections.getEntrySet(set, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public Map<FK, FV> getMap() {
            return this.m_map;
        }

        public Converter<FK, TK> getConverterKeyUp() {
            return this.m_convKeyUp;
        }

        public Converter<TK, FK> getConverterKeyDown() {
            return this.m_convKeyDown;
        }

        public Converter<FV, TV> getConverterValueUp() {
            return this.m_convValUp;
        }

        public Converter<TV, FV> getConverterValueDown() {
            return this.m_convValDown;
        }
    }

    public static class ConverterListIterator<F, T>
    implements ListIterator<T> {
        protected final ListIterator<F> m_iter;
        protected final Converter<F, T> m_convUp;
        protected final Converter<T, F> m_convDown;

        public ConverterListIterator(ListIterator<F> iter, Converter<F, T> convUp, Converter<T, F> convDown) {
            assert (iter != null && convUp != null && convDown != null);
            this.m_iter = iter;
            this.m_convUp = convUp;
            this.m_convDown = convDown;
        }

        @Override
        public boolean hasNext() {
            return this.getListIterator().hasNext();
        }

        @Override
        public T next() {
            return this.getConverterUp().convert(this.getListIterator().next());
        }

        @Override
        public boolean hasPrevious() {
            return this.getListIterator().hasPrevious();
        }

        @Override
        public T previous() {
            return this.getConverterUp().convert(this.getListIterator().previous());
        }

        @Override
        public int nextIndex() {
            return this.getListIterator().nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.getListIterator().previousIndex();
        }

        @Override
        public void remove() {
            this.getListIterator().remove();
        }

        @Override
        public void set(T o) {
            this.getListIterator().set(this.getConverterDown().convert(o));
        }

        @Override
        public void add(T o) {
            this.getListIterator().add(this.getConverterDown().convert(o));
        }

        public ListIterator<F> getListIterator() {
            return this.m_iter;
        }

        public Converter<F, T> getConverterUp() {
            return this.m_convUp;
        }

        public Converter<T, F> getConverterDown() {
            return this.m_convDown;
        }
    }

    public static class ConverterList<F, T>
    extends ConverterCollection<F, T>
    implements List<T>,
    Serializable {
        public ConverterList(List<F> list, Converter<F, T> convUp, Converter<T, F> convDown) {
            super(list, convUp, convDown);
        }

        @Override
        public T get(int index) {
            return this.getConverterUp().convert(this.getList().get(index));
        }

        @Override
        public T set(int index, T element) {
            return this.getConverterUp().convert(this.getList().set(index, this.getConverterDown().convert(element)));
        }

        @Override
        public void add(int index, T element) {
            this.getList().add(index, this.getConverterDown().convert(element));
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> col) {
            return this.getList().addAll(index, this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        @Override
        public T remove(int index) {
            return this.getConverterUp().convert(this.getList().remove(index));
        }

        @Override
        public int indexOf(Object o) {
            return this.getList().indexOf(this.getConverterDown().convert(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.getList().lastIndexOf(this.getConverterDown().convert(o));
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.instantiateListIterator(this.getList().listIterator(), this.getConverterUp(), this.getConverterDown());
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.instantiateListIterator(this.getList().listIterator(index), this.getConverterUp(), this.getConverterDown());
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.instantiateList(this.getList().subList(fromIndex, toIndex), this.getConverterUp(), this.getConverterDown());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return this.getCollection().equals(that.getCollection()) && this.getConverterUp().equals(that.getConverterUp()) && this.getConverterDown().equals(that.getConverterDown());
            }
            if (o instanceof List) {
                ListIterator<T> iterThis = this.listIterator();
                ListIterator iterThat = ((List)o).listIterator();
                while (iterThis.hasNext() && iterThat.hasNext()) {
                    if (NaturalHasher.INSTANCE.equals(iterThis.next(), iterThat.next())) continue;
                    return false;
                }
                return !iterThis.hasNext() && !iterThat.hasNext();
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 1;
            ListIterator<T> iter = this.listIterator();
            while (iter.hasNext()) {
                nHash = 31 * nHash + NaturalHasher.INSTANCE.hashCode(iter.next());
            }
            return nHash;
        }

        protected <F, T> List<T> instantiateList(List<F> list, Converter<F, T> convUp, Converter<T, F> convDown) {
            return ConverterCollections.getList(list, convUp, convDown);
        }

        protected <F, T> ListIterator<T> instantiateListIterator(ListIterator<F> iter, Converter<F, T> convUp, Converter<T, F> convDown) {
            return ConverterCollections.getListIterator(iter, convUp, convDown);
        }

        public List<F> getList() {
            return (List)this.getCollection();
        }
    }

    public static class ConverterSortedSet<F, T>
    extends ConverterSet<F, T>
    implements SortedSet<T>,
    Serializable {
        public ConverterSortedSet(SortedSet<F> set, Converter<F, T> convUp, Converter<T, F> convDown) {
            super(set, convUp, convDown);
        }

        @Override
        public Comparator<T> comparator() {
            Comparator<F> comparator = this.getSortedSet().comparator();
            return comparator == null ? null : new ConverterComparator(comparator, this.m_convDown);
        }

        @Override
        public SortedSet<T> subSet(T fromElement, T toElement) {
            SortedSet<F> subset = this.getSortedSet().subSet(this.getConverterDown().convert(fromElement), this.getConverterDown().convert(toElement));
            return this.instantiateSortedSet(subset, this.getConverterUp(), this.getConverterDown());
        }

        @Override
        public SortedSet<T> headSet(T toElement) {
            SortedSet<F> subset = this.getSortedSet().headSet(this.getConverterDown().convert(toElement));
            return this.instantiateSortedSet(subset, this.getConverterUp(), this.getConverterDown());
        }

        @Override
        public SortedSet<T> tailSet(T fromElement) {
            SortedSet<F> subset = this.getSortedSet().tailSet(this.getConverterDown().convert(fromElement));
            return this.instantiateSortedSet(subset, this.getConverterUp(), this.getConverterDown());
        }

        @Override
        public T first() {
            return this.getConverterUp().convert(this.getSortedSet().first());
        }

        @Override
        public T last() {
            return this.getConverterUp().convert(this.getSortedSet().last());
        }

        protected SortedSet<T> instantiateSortedSet(SortedSet<F> set, Converter<F, T> convUp, Converter<T, F> convDown) {
            return ConverterCollections.getSortedSet(set, convUp, convDown);
        }

        public SortedSet<F> getSortedSet() {
            return (SortedSet)this.getCollection();
        }
    }

    public static class ConverterSet<F, T>
    extends ConverterCollection<F, T>
    implements Set<T>,
    Serializable {
        public ConverterSet(Collection<F> col, Converter<F, T> convUp, Converter<T, F> convDown) {
            super(col, convUp, convDown);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return this.getCollection().equals(that.getCollection()) && this.getConverterUp().equals(that.getConverterUp()) && this.getConverterDown().equals(that.getConverterDown());
            }
            if (o instanceof Set) {
                Set set = (Set)o;
                return set.size() == this.size() && this.containsAll(set);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            for (Object o : this.getCollection()) {
                nHash += NaturalHasher.INSTANCE.hashCode(o);
            }
            return nHash;
        }
    }

    public static class ConverterCollection<F, T>
    implements Collection<T>,
    Serializable {
        protected Collection<F> m_col;
        protected Converter<F, T> m_convUp;
        protected Converter<T, F> m_convDown;

        public ConverterCollection(Collection<F> col, Converter<F, T> convUp, Converter<T, F> convDown) {
            assert (col != null && convUp != null && convDown != null);
            this.m_col = col;
            this.m_convUp = convUp;
            this.m_convDown = convDown;
        }

        @Override
        public int size() {
            return this.getCollection().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getCollection().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getCollection().contains(this.getConverterDown().convert(o));
        }

        @Override
        public Iterator<T> iterator() {
            return this.instantiateIterator(this.getCollection().iterator(), this.getConverterUp());
        }

        @Override
        public Object[] toArray() {
            return ConverterCollections.convertArray(this.getCollection().toArray(), this.getConverterUp());
        }

        @Override
        public <E> E[] toArray(E[] aoDest) {
            return ConverterCollections.convertArray(this.getCollection().toArray(), this.getConverterUp(), aoDest);
        }

        @Override
        public boolean add(T o) {
            return this.getCollection().add(this.getConverterDown().convert(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.getCollection().remove(this.getConverterDown().convert(o));
        }

        @Override
        public boolean containsAll(Collection<?> col) {
            return this.getCollection().containsAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        @Override
        public boolean addAll(Collection<? extends T> col) {
            return this.getCollection().addAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        @Override
        public boolean removeAll(Collection<?> col) {
            return this.getCollection().removeAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        @Override
        public boolean retainAll(Collection<?> col) {
            return this.getCollection().retainAll(this.instantiateCollection(col, this.getConverterDown(), this.getConverterUp()));
        }

        @Override
        public void clear() {
            this.getCollection().clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return this.getCollection().equals(that.getCollection()) && this.getConverterUp().equals(that.getConverterUp()) && this.getConverterDown().equals(that.getConverterDown());
            }
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterCollection{");
            boolean fFirst = true;
            for (T o : this) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(o);
            }
            sb.append('}');
            return sb.toString();
        }

        public void invalidate() {
            this.m_col = null;
            this.m_convUp = null;
            this.m_convDown = null;
        }

        protected <T, F> Collection<T> instantiateCollection(Collection<F> col, Converter<F, T> convUp, Converter<T, F> convDown) {
            return ConverterCollections.getCollection(col, convUp, convDown);
        }

        protected Iterator<T> instantiateIterator(Iterator<F> iter, Converter<F, T> conv) {
            return ConverterCollections.getIterator(iter, conv);
        }

        public Collection<F> getCollection() {
            return this.m_col;
        }

        public Converter<F, T> getConverterUp() {
            return this.m_convUp;
        }

        public Converter<T, F> getConverterDown() {
            return this.m_convDown;
        }
    }

    public static class ConverterEnumerator<F, T>
    implements Enumeration<T>,
    Iterator<T> {
        protected Iterator<F> m_iter;
        protected Converter<F, T> m_conv;

        public ConverterEnumerator(final Enumeration<F> enmr, Converter<F, T> conv) {
            this(new Iterator<F>(){

                @Override
                public boolean hasNext() {
                    return enmr.hasMoreElements();
                }

                @Override
                public F next() {
                    return enmr.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }, conv);
        }

        public ConverterEnumerator(Iterator<F> iter, Converter<F, T> conv) {
            this.m_iter = iter;
            this.m_conv = conv;
        }

        public ConverterEnumerator(Object[] aoItem, Converter<F, T> conv) {
            this(Arrays.asList(aoItem).iterator(), conv);
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public T nextElement() {
            return this.next();
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public T next() {
            return this.m_conv.convert(this.m_iter.next());
        }

        @Override
        public void remove() {
            this.m_iter.remove();
        }
    }
}

