/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.net.BackingMapContext;
import com.tangosol.util.Base;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SegmentedHashMap;
import com.tangosol.util.ValueExtractor;
import java.util.Comparator;
import java.util.Map;

public class ForwardOnlyMapIndex
implements MapIndex {
    protected final ValueExtractor f_extractor;
    protected final Map f_mapForward;
    protected final BackingMapContext f_ctx;
    protected boolean f_fLazy;

    public ForwardOnlyMapIndex(ValueExtractor extractor, BackingMapContext ctx, boolean fOnDemand) {
        Base.azzert(extractor != null);
        this.f_extractor = extractor;
        this.f_ctx = ctx;
        this.f_fLazy = fOnDemand;
        this.f_mapForward = this.instantiateForwardIndex();
    }

    public ValueExtractor getValueExtractor() {
        return this.f_extractor;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean isPartial() {
        return false;
    }

    public Comparator getComparator() {
        return null;
    }

    public Map getIndexContents() {
        return NullImplementation.getMap();
    }

    public Object get(Object oKey) {
        Object oValue = this.f_mapForward.get(oKey);
        if (oValue == null && !this.f_mapForward.containsKey(oKey)) {
            if (this.f_fLazy) {
                ObservableMap mapBacking = this.f_ctx.getBackingMap();
                if (mapBacking.containsKey(oKey)) {
                    oValue = mapBacking.get(oKey);
                }
                if (oValue != null) {
                    oValue = this.f_ctx.getManagerContext().getValueFromInternalConverter().convert(oValue);
                    this.f_mapForward.put(oKey, oValue);
                    return oValue;
                }
            }
            return NO_VALUE;
        }
        return oValue;
    }

    public void insert(Map.Entry entry) {
        this.updateInternal(entry);
    }

    public void update(Map.Entry entry) {
        this.updateInternal(entry);
    }

    public void delete(Map.Entry entry) {
        this.deleteInternal(entry);
    }

    protected Map instantiateForwardIndex() {
        return new SegmentedHashMap();
    }

    protected void updateInternal(Map.Entry entry) {
        Object oKey;
        Object object = oKey = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
        if (!this.f_fLazy || this.f_mapForward.containsKey(oKey)) {
            try {
                this.f_mapForward.put(oKey, InvocableMapHelper.extractFromEntry(this.f_extractor, entry));
            }
            catch (RuntimeException e) {
                Logger.warn("An Exception occurred during index update for key " + entry.getKey() + ". The entry will be excluded from the index" + (this.f_ctx == null ? "" : " for cache " + this.f_ctx.getCacheName()) + ".\n" + e + ":\n", (Throwable)e);
                this.f_mapForward.remove(oKey);
            }
        }
    }

    protected void deleteInternal(Map.Entry entry) {
        Object oKey = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
        this.f_mapForward.remove(oKey);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + ": Extractor=" + this.getValueExtractor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ForwardOnlyMapIndex that = (ForwardOnlyMapIndex)o;
        return Base.equals(this.getValueExtractor(), that.getValueExtractor());
    }

    public int hashCode() {
        return this.f_extractor.hashCode();
    }
}

