/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.collections.InflatableMap;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

public class LiteMap<K, V>
extends InflatableMap<K, V>
implements ExternalizableLite {
    private static final long serialVersionUID = -4530874198920262848L;

    public LiteMap() {
    }

    public LiteMap(Map<? extends K, ? extends V> map) {
        this.putAll(map);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        Map map;
        ObjectInput inObj;
        if (!this.isEmpty()) {
            throw new NotActiveException();
        }
        int c = ExternalizableHelper.readInt(in);
        if (c == 0) {
            return;
        }
        boolean fLite = in.readBoolean();
        ObjectInput objectInput = inObj = fLite ? null : ExternalizableHelper.getObjectInput(in, null);
        if (c > 8) {
            map = this.instantiateMap();
            this.m_nImpl = (byte)10;
            this.m_oContents = map;
        } else {
            map = this;
        }
        for (int i = 0; i < c; ++i) {
            Object value;
            Object key;
            if (fLite) {
                key = ExternalizableHelper.readObject(in);
                value = ExternalizableHelper.readObject(in);
            } else {
                try {
                    key = inObj.readObject();
                    value = inObj.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("readObject failed: " + e + "\n" + Base.getStackTrace(e));
                }
            }
            map.put(key, value);
        }
    }

    @Override
    public synchronized void writeExternal(DataOutput out) throws IOException {
        int c = this.size();
        Map.Entry[] aEntry = this.entrySet().toArray(new Map.Entry[c]);
        ExternalizableHelper.writeInt(out, c);
        if (c == 0) {
            return;
        }
        boolean fLite = true;
        int FMT_OBJ_SER = 11;
        for (int i = 0; i < c; ++i) {
            Map.Entry entry = aEntry[i];
            if (ExternalizableHelper.getStreamFormat(entry.getKey()) != 11 && ExternalizableHelper.getStreamFormat(entry.getValue()) != 11) continue;
            fLite = false;
            break;
        }
        out.writeBoolean(fLite);
        ObjectOutput outObj = fLite ? null : ExternalizableHelper.getObjectOutput(out);
        for (int i = 0; i < c; ++i) {
            Map.Entry entry = aEntry[i];
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (fLite) {
                ExternalizableHelper.writeObject(out, key);
                ExternalizableHelper.writeObject(out, value);
                continue;
            }
            outObj.writeObject(key);
            outObj.writeObject(value);
        }
        if (outObj != null) {
            outObj.close();
        }
    }
}

